/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.rules.Example;
import ai.grazie.rules.Rule;
import ai.grazie.rules.StyleFlavor;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.en.Articles;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.en.NegativePhrases;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.NodePointer;
import ai.grazie.rules.tree.ReportingKind;

class DoubleNegation {
    private static final String DOUBLE_NEGATION_MSG = "Avoid double negation";

    DoubleNegation() {
    }

    static Rule.PatternRule rule() {
        return new Rule.PatternRule("Style.DOUBLE_NEGATION", DOUBLE_NEGATION_MSG, "Sentences with several negating words can be perceived as colloquial and nonstandard.", "https://www.niu.edu/writingtutorial/grammar/double-negatives.shtml", () -> DoubleNegation.pattern(), new Example("I <b>didn\u2019t</b> meet <b>nobody</b>.", "I <b>met</b> nobody.", "I didn\u2019t <b>meet</b> anybody.")).styleFlavor(StyleFlavor.Readability).honorCrazyParses();
    }

    private static NodePattern pattern() {
        NodePattern imperativeDo = EnglishTreePatterns.auxDo.withHead(NodePattern.N.noDependents("nsubj(:pass|:outer)?|csubj(:pass)?|expl"));
        NodePattern removeNegation = NodePattern.or(NodePattern.N.directlyAfter(imperativeDo), NodePattern.N.correct(EnglishTreePatterns.removeNegation(NodePointer.anchor())));
        NodePattern noXToAny = NodePattern.N.includeIntoReport().correct(NodeCorrector.regexReplace("no(.*)", "any$1")).correct(NodeCorrector.regexReplace("neither", "either"));
        NodePattern noQuotesToNot = NodePattern.N.noMatchUntil("Not", EnglishTreePatterns.quotations);
        NodePattern noQuotesToSubj = NodePattern.N.noMatchUntil("NoXSubj", EnglishTreePatterns.quotations);
        NodePattern toWithoutPhrase = NodePattern.N.form("no").beforeHead().withHead(NodePattern.or(NodePattern.N.withDependent("case", NodePattern.N.form("with").markAs("Prep")), NodePattern.N.lemma("reason").withDependent("case", NodePattern.N.form("for").markAs("Prep")))).and((no, match) -> {
            Node noun = no.head();
            String det = Articles.singularCountableNoun.matches(noun) && !Articles.allowMissingArticleAfterWithout.matches(noun) ? Articles.getIndefiniteArticle(no.neighbor(1)) : "";
            NodeCorrector fixDet = NodeCorrector.replace(no, det);
            return match.withCorrector(NodeCorrector.replace(match.getMarkedNode("Prep"), "without").join(fixDet));
        });
        NodePattern reportPossiblyContracted = NodePattern.N.includeIntoReport().andOptionally(NodePattern.N.noSpaceBefore().directlyAfter(CommonPatterns.letterWord.includeIntoReport()));
        NodePattern notHead = NodePattern.or(NodePattern.N.withDependent("xcomp", NodePattern.N.withDependent("mark", NodePattern.N.form("to").includeIntoReport().directlyAfter(NodePattern.N.form("not").after("Not").and(noQuotesToNot).includeIntoReport()).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), "to not")))), NodePattern.N.withDependent("advmod", NodePattern.or(NodePattern.or(NodePattern.N.form("nowhere").markAs("Start"), NodePattern.N.form("where").directlyAfter(NodePattern.N.form("no").includeIntoReport().markAs("Start"))).and(noQuotesToNot).includeIntoReport().and(NodePattern.markedNodeMatches("Not", removeNegation)).correct(NodeCorrector.replaceNodes(NodePointer.marked("Start"), NodePointer.anchor(), "anywhere")), NegativePhrases.negativeContentAdverb.after("Not").includeIntoReport(ReportingKind.Hover).and(noQuotesToNot).andOptionally(NodePattern.N.form("never").correct(NodeCorrector.replace("ever"))).and(NodePattern.markedNodeMatches("Not", removeNegation)), NodePattern.N.form("not").after("Not").noMatchUntil("Not", CommonPatterns.slash).and(noQuotesToNot).andNot(NodePattern.N.inFormSequence(2, "not", "to", "not")).andNot(NodePattern.N.directlyAfter(NodePattern.N.withHeadRelation("cop"))).includeIntoReport().and(removeNegation))), NodePattern.N.withDependent("i?obj|obl", DoubleNegation.negativeNP("NoX").and(noQuotesToNot)).noLemma("mean|constitute").andOptionally(NodePattern.markedNodeMatches("NoX", toWithoutPhrase)).and(NodePattern.markedNodeMatches("Not", removeNegation)).and(NodePattern.markedNodeMatches("NoX", noXToAny)));
        NodePattern aint = EnglishTreePatterns.contractedNot.directlyAfter(NodePattern.N.form("ai"));
        return NodePattern.or(NodePattern.or(NodePattern.N.lemma("not").markAs("Not").and(reportPossiblyContracted).withHead("advmod", notHead), NegativePhrases.singleTokenCannot.markAs("Not").includeIntoReport().withHead("aux", notHead)).andNot(aint), DoubleNegation.negativeNP("NoXSubj").withHead("nsubj(:pass)?", NodePattern.or(NodePattern.N.withDependent("advmod", NodePattern.N.lemma("not").markAs("Not").and(noQuotesToSubj).andNot(aint).and(reportPossiblyContracted).and(removeNegation)).andNot(NodePattern.N.withDependent("nsubj", NodePattern.N.beforeHead().after("Not"))), NodePattern.N.withDependent("i?obj|obl", DoubleNegation.negativeNP("NoX").and(noQuotesToSubj)).and(NodePattern.markedNodeMatches("NoXSubj", NodePattern.N.includeIntoReport(ReportingKind.Hover))).and(NodePattern.markedNodeMatches("NoX", noXToAny))).noMatchUntil("NoXSubj", CommonPatterns.comma).andOptionally(NodePattern.N.withDependent("expl").and(NodePattern.markedNodeMatches("NoXSubj", noXToAny)))).andNot(CommonPatterns.beforeSkipping(NodePattern.N.withHeadRelation("cop|aux|aux:pass"), NodePattern.N.form("not")))).message(DOUBLE_NEGATION_MSG);
    }

    private static NodePattern negativeNP(String markAs) {
        return NodePattern.or(NodePattern.N.form("no(body|thing|where)").andNot(NodePattern.N.directlyAfter(NodePattern.N.form("for"))).markAs(markAs), NodePattern.N.withDependent("det", NodePattern.N.form("no|neither").andNot(NodePattern.N.inFormSequence(0, "no", "-|name")).markAs(markAs)));
    }
}

