/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.util.ImportableFqNameClassifier;
import org.jetbrains.kotlin.idea.completion.CompletionUtilsNoResolveKt;
import org.jetbrains.kotlin.idea.completion.ItemPriority;
import org.jetbrains.kotlin.idea.core.completion.DescriptorBasedDeclarationLookupObject;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/completion/NotImportedStaticMemberWeigher;", "Lcom/intellij/codeInsight/lookup/LookupElementWeigher;", "classifier", "Lorg/jetbrains/kotlin/idea/base/util/ImportableFqNameClassifier;", "<init>", "(Lorg/jetbrains/kotlin/idea/base/util/ImportableFqNameClassifier;)V", "weigh", "", "element", "Lcom/intellij/codeInsight/lookup/LookupElement;", "kotlin.completion.impl.k1"})
public final class NotImportedStaticMemberWeigher
extends LookupElementWeigher {
    @NotNull
    private final ImportableFqNameClassifier classifier;

    public NotImportedStaticMemberWeigher(@NotNull ImportableFqNameClassifier classifier) {
        Intrinsics.checkNotNullParameter((Object)classifier, (String)"classifier");
        super("kotlin.notImportedMember");
        this.classifier = classifier;
    }

    @Nullable
    public Comparable<?> weigh(@NotNull LookupElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (CompletionUtilsNoResolveKt.getPriority(element) != ItemPriority.STATIC_MEMBER) {
            return null;
        }
        Object object = element.getObject();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.idea.core.completion.DescriptorBasedDeclarationLookupObject");
        FqName fqName2 = ((DescriptorBasedDeclarationLookupObject)object).getImportableFqName();
        if (fqName2 == null) {
            return null;
        }
        FqName fqName3 = fqName2;
        return (Comparable)((Object)this.classifier.classify(fqName3.parent(), false));
    }
}

