/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion.implCommon;

import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.concurrency.ThreadingAssertions;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0002\u0012\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011R\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/completion/implCommon/LookupCancelService;", "", "<init>", "()V", "lookupCancelListener", "Lcom/intellij/codeInsight/lookup/LookupListener;", "getLookupCancelListener", "()Lcom/intellij/codeInsight/lookup/LookupListener;", "disposeLastReminiscence", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "lastReminiscence", "Lorg/jetbrains/kotlin/idea/completion/implCommon/LookupCancelService$Reminiscence;", "wasAutoPopupRecentlyCancelled", "", "offset", "", "Reminiscence", "Companion", "kotlin.completion.impl.shared"})
public final class LookupCancelService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @ApiStatus.Internal
    @NotNull
    private final LookupListener lookupCancelListener = new LookupListener(this){
        final /* synthetic */ LookupCancelService this$0;
        {
            this.this$0 = $receiver;
        }

        public void lookupCanceled(LookupEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Lookup lookup = event.getLookup();
            if (event.isCanceledExplicitly() && lookup.isCompletion()) {
                Integer offset;
                LookupElement lookupElement2 = lookup.getCurrentItem();
                Integer n = offset = lookupElement2 != null ? (Integer)lookupElement2.getUserData(LookupCancelService.Companion.getAUTO_POPUP_AT()) : null;
                if (offset != null) {
                    Reminiscence reminiscence = LookupCancelService.access$getLastReminiscence$p(this.this$0);
                    if (reminiscence != null) {
                        reminiscence.dispose();
                    }
                    if (offset <= lookup.getEditor().getDocument().getTextLength()) {
                        Editor editor = lookup.getEditor();
                        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                        LookupCancelService.access$setLastReminiscence$p(this.this$0, new Reminiscence(editor, offset));
                    }
                }
            }
        }
    };
    @Nullable
    private Reminiscence lastReminiscence;
    @NotNull
    private static final Key<Integer> AUTO_POPUP_AT = new Key("LookupCancelService.AUTO_POPUP_AT");

    @NotNull
    public final LookupListener getLookupCancelListener() {
        return this.lookupCancelListener;
    }

    @ApiStatus.Internal
    public final void disposeLastReminiscence(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Reminiscence reminiscence = this.lastReminiscence;
        if (Intrinsics.areEqual((Object)(reminiscence != null ? reminiscence.getEditor() : null), (Object)editor)) {
            Reminiscence reminiscence2 = this.lastReminiscence;
            Intrinsics.checkNotNull((Object)reminiscence2);
            reminiscence2.dispose();
            this.lastReminiscence = null;
        }
    }

    public final boolean wasAutoPopupRecentlyCancelled(@NotNull Editor editor, int offset) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Reminiscence reminiscence = this.lastReminiscence;
        return reminiscence != null ? reminiscence.matches(editor, offset) : false;
    }

    public static final /* synthetic */ Reminiscence access$getLastReminiscence$p(LookupCancelService $this) {
        return $this.lastReminiscence;
    }

    public static final /* synthetic */ void access$setLastReminiscence$p(LookupCancelService $this, Reminiscence reminiscence) {
        $this.lastReminiscence = reminiscence;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/completion/implCommon/LookupCancelService$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/kotlin/idea/completion/implCommon/LookupCancelService;", "project", "Lcom/intellij/openapi/project/Project;", "getServiceIfCreated", "AUTO_POPUP_AT", "Lcom/intellij/openapi/util/Key;", "", "getAUTO_POPUP_AT", "()Lcom/intellij/openapi/util/Key;", "kotlin.completion.impl.shared"})
    @SourceDebugExtension(value={"SMAP\nLookupCancelService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LookupCancelService.kt\norg/jetbrains/kotlin/idea/completion/implCommon/LookupCancelService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,90:1\n30#2,2:91\n*S KotlinDebug\n*F\n+ 1 LookupCancelService.kt\norg/jetbrains/kotlin/idea/completion/implCommon/LookupCancelService$Companion\n*L\n78#1:91,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LookupCancelService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<LookupCancelService> serviceClass$iv = LookupCancelService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (LookupCancelService)object;
        }

        @Nullable
        public final LookupCancelService getServiceIfCreated(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return (LookupCancelService)project.getServiceIfCreated(LookupCancelService.class);
        }

        @NotNull
        public final Key<Integer> getAUTO_POPUP_AT() {
            return AUTO_POPUP_AT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0012\u001a\u00020\u0013R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/completion/implCommon/LookupCancelService$Reminiscence;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "offset", "", "<init>", "(Lcom/intellij/openapi/editor/Editor;I)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "setEditor", "(Lcom/intellij/openapi/editor/Editor;)V", "marker", "Lcom/intellij/openapi/editor/RangeMarker;", "editorListener", "Lcom/intellij/openapi/editor/event/CaretListener;", "matches", "", "dispose", "", "kotlin.completion.impl.shared"})
    public static final class Reminiscence {
        @Nullable
        private Editor editor;
        @Nullable
        private RangeMarker marker;
        @Nullable
        private CaretListener editorListener;

        public Reminiscence(@NotNull Editor editor, int offset) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            this.editor = editor;
            this.marker = editor.getDocument().createRangeMarker(offset, offset);
            this.editorListener = new CaretListener(this, editor, offset){
                final /* synthetic */ Reminiscence this$0;
                final /* synthetic */ Editor $editor;
                final /* synthetic */ int $offset;
                {
                    this.this$0 = $receiver;
                    this.$editor = $editor;
                    this.$offset = $offset;
                }

                public void caretPositionChanged(CaretEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (Reminiscence.access$getMarker$p(this.this$0) != null) {
                        RangeMarker rangeMarker = Reminiscence.access$getMarker$p(this.this$0);
                        Intrinsics.checkNotNull((Object)rangeMarker);
                        if (!rangeMarker.isValid() || this.$editor.logicalPositionToOffset(e.getNewPosition()) <= this.$offset) {
                            this.this$0.dispose();
                        }
                    }
                }
            };
            ThreadingAssertions.assertEventDispatchThread();
            CaretModel caretModel = editor.getCaretModel();
            CaretListener caretListener = this.editorListener;
            Intrinsics.checkNotNull((Object)caretListener);
            caretModel.addCaretListener(caretListener);
        }

        @Nullable
        public final Editor getEditor() {
            return this.editor;
        }

        public final void setEditor(@Nullable Editor editor) {
            this.editor = editor;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean matches(@NotNull Editor editor, int offset) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            if (!Intrinsics.areEqual((Object)editor, (Object)this.editor)) return false;
            RangeMarker rangeMarker = this.marker;
            if (rangeMarker == null) return false;
            if (rangeMarker.getStartOffset() != offset) return false;
            return true;
        }

        public final void dispose() {
            ThreadingAssertions.assertEventDispatchThread();
            if (this.marker != null) {
                Editor editor = this.editor;
                Intrinsics.checkNotNull((Object)editor);
                CaretModel caretModel = editor.getCaretModel();
                CaretListener caretListener = this.editorListener;
                Intrinsics.checkNotNull((Object)caretListener);
                caretModel.removeCaretListener(caretListener);
                this.marker = null;
                this.editor = null;
                this.editorListener = null;
            }
        }

        public static final /* synthetic */ RangeMarker access$getMarker$p(Reminiscence $this) {
            return $this.marker;
        }
    }
}

