﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/es/ElasticsearchService_EXPORTS.h>
#include <aws/es/model/ServiceSoftwareOptions.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace ElasticsearchService {
namespace Model {
/**
 * <p>The result of a <code>StartElasticsearchServiceSoftwareUpdate</code>
 * operation. Contains the status of the update.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/StartElasticsearchServiceSoftwareUpdateResponse">AWS
 * API Reference</a></p>
 */
class StartElasticsearchServiceSoftwareUpdateResult {
 public:
  AWS_ELASTICSEARCHSERVICE_API StartElasticsearchServiceSoftwareUpdateResult() = default;
  AWS_ELASTICSEARCHSERVICE_API StartElasticsearchServiceSoftwareUpdateResult(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_ELASTICSEARCHSERVICE_API StartElasticsearchServiceSoftwareUpdateResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The current status of the Elasticsearch service software update.</p>
   */
  inline const ServiceSoftwareOptions& GetServiceSoftwareOptions() const { return m_serviceSoftwareOptions; }
  template <typename ServiceSoftwareOptionsT = ServiceSoftwareOptions>
  void SetServiceSoftwareOptions(ServiceSoftwareOptionsT&& value) {
    m_serviceSoftwareOptionsHasBeenSet = true;
    m_serviceSoftwareOptions = std::forward<ServiceSoftwareOptionsT>(value);
  }
  template <typename ServiceSoftwareOptionsT = ServiceSoftwareOptions>
  StartElasticsearchServiceSoftwareUpdateResult& WithServiceSoftwareOptions(ServiceSoftwareOptionsT&& value) {
    SetServiceSoftwareOptions(std::forward<ServiceSoftwareOptionsT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  StartElasticsearchServiceSoftwareUpdateResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  ServiceSoftwareOptions m_serviceSoftwareOptions;
  bool m_serviceSoftwareOptionsHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ElasticsearchService
}  // namespace Aws
