/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.outline;

import java.awt.ComponentOrientation;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.view.swing.map.outline.ExpansionControls;
import org.freeplane.view.swing.map.outline.NavigationButtonHider;
import org.freeplane.view.swing.map.outline.OutlineDisplayMode;
import org.freeplane.view.swing.map.outline.OutlineGeometry;
import org.freeplane.view.swing.map.outline.RightToLeftLayout;
import org.freeplane.view.swing.map.outline.TreeNode;

class NavigationButtons {
    final JButton expandMoreBtn;
    final JButton reduceBtn;
    private OutlineGeometry geometry;
    private final ExpansionControls expansionControls;
    private JPanel currentParent;
    private TreeNode node;
    private final OutlineDisplayMode displayMode;

    NavigationButtons(OutlineGeometry geometry, OutlineDisplayMode displayMode, ExpansionControls expansionControls) {
        this.geometry = geometry;
        this.expansionControls = expansionControls;
        this.displayMode = displayMode;
        this.expandMoreBtn = new JButton("\u25bc");
        this.reduceBtn = new JButton("\u25b2");
        this.configureNavigationButtons();
    }

    private void configureNavigationButtons() {
        this.configureNavButton(this.expandMoreBtn, e -> this.expansionControls.expandNodeMore(this.node));
        this.configureNavButton(this.reduceBtn, e -> this.expansionControls.reduceNodeExpansion(this.node));
    }

    private void configureNavButton(JButton button, ActionListener actionListener) {
        button.setMargin(new Insets(0, 0, 0, 0));
        this.applyButtonFont(button);
        button.setFocusable(false);
        button.setBorder(BorderFactory.createRaisedBevelBorder());
        button.setVisible(false);
        button.addActionListener(actionListener);
    }

    private void applyButtonFont(JButton button) {
        button.setFont(button.getFont().deriveFont(this.geometry.getItemFontSize()));
    }

    public void attachToNode(TreeNode node, JPanel targetPanel, int rowIndex, int rowIndent) {
        this.node = node;
        this.hideNavigationButtons();
        if (node.getChildren().isEmpty()) {
            return;
        }
        boolean showFoldingButtons = ResourceController.getResourceController().getBooleanProperty("showOutlineFoldingButtons", true);
        if (showFoldingButtons) {
            targetPanel.add(this.expandMoreBtn);
            targetPanel.add(this.reduceBtn);
            this.currentParent = targetPanel;
            Point position = this.calculateNavigationButtonPosition(rowIndex, rowIndent);
            if (position == null) {
                return;
            }
            int baseX = position.x;
            int y = position.y;
            int level = node.getLevel();
            this.showButtons(baseX, y, level);
            NavigationButtonHider.INSTANCE.enable(targetPanel, this);
        }
    }

    private Point calculateNavigationButtonPosition(int nodeIndex, int rowIndent) {
        int baseX = this.geometry.calculateNavigationButtonX(rowIndent);
        int rowHeight = this.geometry.rowHeight;
        int y = nodeIndex * rowHeight + 1;
        return new Point(baseX, y);
    }

    void hideNavigationButtons() {
        this.expandMoreBtn.setVisible(false);
        this.reduceBtn.setVisible(false);
        if (this.currentParent != null) {
            if (this.expandMoreBtn.getParent() == this.currentParent) {
                this.currentParent.remove(this.expandMoreBtn);
            }
            if (this.reduceBtn.getParent() == this.currentParent) {
                this.currentParent.remove(this.reduceBtn);
            }
        }
    }

    private void showButtons(int baseX, int y, int level) {
        if (this.displayMode == OutlineDisplayMode.BOOKMARK) {
            return;
        }
        int buttonY = y + 2;
        int buttonHeight = this.geometry.rowHeight - 4;
        int reduceX = baseX;
        int expandX = reduceX + this.geometry.navButtonWidth;
        this.expandMoreBtn.setBounds(expandX, buttonY, this.geometry.navButtonWidth, buttonHeight);
        RightToLeftLayout.applyToSingleComponent(this.expandMoreBtn);
        ComponentOrientation componentOrientation = this.geometry.outlineTextOrientation;
        this.expandMoreBtn.setComponentOrientation(componentOrientation);
        this.expandMoreBtn.setVisible(true);
        if (this.node.isExpanded() && (level > 0 || this.node.getMaxExpansionLevel() > 1)) {
            this.reduceBtn.setBounds(reduceX, buttonY, this.geometry.navButtonWidth, buttonHeight);
            this.reduceBtn.setVisible(true);
            this.reduceBtn.setComponentOrientation(componentOrientation);
            RightToLeftLayout.applyToSingleComponent(this.reduceBtn);
        }
    }

    void updateGeometry(OutlineGeometry geometry) {
        this.geometry = geometry;
        this.applyButtonFont(this.expandMoreBtn);
        this.applyButtonFont(this.reduceBtn);
    }
}

