/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import groovy.lang.Binding;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.Script;
import java.io.File;
import java.io.PrintStream;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.freeplane.features.map.NodeModel;
import org.freeplane.plugin.script.CompileTimeStrategy;
import org.freeplane.plugin.script.ExecuteScriptException;
import org.freeplane.plugin.script.FreeplaneScriptBaseClass;
import org.freeplane.plugin.script.GroovyShell;
import org.freeplane.plugin.script.GroovyStaticImports;
import org.freeplane.plugin.script.IFreeplaneScriptErrorHandler;
import org.freeplane.plugin.script.IScript;
import org.freeplane.plugin.script.ScriptClassLoader;
import org.freeplane.plugin.script.ScriptContext;
import org.freeplane.plugin.script.ScriptResources;
import org.freeplane.plugin.script.ScriptSecurity;
import org.freeplane.plugin.script.ScriptingPermissions;
import org.freeplane.plugin.script.ScriptingSecurityManager;
import org.freeplane.plugin.script.proxy.ScriptUtils;

public class GroovyScript
implements IScript {
    private final Object script;
    private final ScriptingPermissions specificPermissions;
    private FreeplaneScriptBaseClass compiledScript;
    private Throwable errorsInScript;
    private CompileTimeStrategy compileTimeStrategy;
    private ScriptClassLoader scriptClassLoader;
    private static boolean accessPermissionCheckerChecked = false;

    public GroovyScript(String script) {
        this((Object)script);
    }

    public GroovyScript(File script) {
        this((Object)script);
        this.compileTimeStrategy = new CompileTimeStrategy(script);
    }

    public GroovyScript(String script, ScriptingPermissions permissions) {
        this((Object)script, permissions);
    }

    public GroovyScript(File script, ScriptingPermissions permissions) {
        this((Object)script, permissions);
        this.compileTimeStrategy = new CompileTimeStrategy(script);
    }

    private GroovyScript(Object script, ScriptingPermissions permissions) {
        this.script = script;
        this.specificPermissions = permissions;
        this.compiledScript = null;
        this.errorsInScript = null;
        this.compileTimeStrategy = new CompileTimeStrategy(null);
    }

    private GroovyScript(Object script) {
        this(script, null);
    }

    public Script getCompiledScript() {
        return this.compiledScript;
    }

    @Override
    public Object execute(final NodeModel node, final PrintStream outStream, IFreeplaneScriptErrorHandler errorHandler, final ScriptContext scriptContext) {
        if (this.errorsInScript != null && this.compileTimeStrategy.canUseOldCompiledScript()) {
            throw new ExecuteScriptException(this.errorsInScript.getMessage(), this.errorsInScript);
        }
        final PrintStream oldOut = System.out;
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Object object = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    try {
                        ScriptingSecurityManager scriptingSecurityManager = GroovyScript.this.createScriptingSecurityManager(outStream);
                        GroovyScript.this.compileAndCache(scriptingSecurityManager);
                        Thread.currentThread().setContextClassLoader((ClassLoader)((Object)GroovyScript.this.scriptClassLoader));
                        FreeplaneScriptBaseClass scriptWithBinding = GroovyScript.this.compiledScript.withBinding(node, scriptContext);
                        if (oldOut != outStream) {
                            System.setOut(outStream);
                        }
                        Object result = scriptWithBinding.run();
                        return result;
                    }
                    catch (Exception e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            return object;
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof GroovyRuntimeException) {
                outStream.print("message: " + e.getMessage());
                int lineNumber = this.findErrorLine((GroovyRuntimeException)cause);
                outStream.print("Line number: " + lineNumber);
                errorHandler.gotoLine(lineNumber);
                throw new ExecuteScriptException(cause.getMessage() + " at line " + lineNumber, cause);
            }
            throw new ExecuteScriptException(cause.getMessage(), cause);
        }
        catch (ExecuteScriptException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ExecuteScriptException(e.getMessage(), e);
        }
        finally {
            if (oldOut != outStream) {
                System.setOut(oldOut);
            }
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    private ScriptingSecurityManager createScriptingSecurityManager(PrintStream outStream) {
        return new ScriptSecurity(this.script, this.specificPermissions, outStream).getScriptingSecurityManager();
    }

    private void compileAndCache(ScriptingSecurityManager scriptingSecurityManager) throws Throwable {
        GroovyScript.checkAccessPermissionCheckerExists();
        if (this.compileTimeStrategy.canUseOldCompiledScript()) {
            this.scriptClassLoader.setSecurityManager(scriptingSecurityManager);
        } else {
            this.removeOldScript();
            this.errorsInScript = null;
            try {
                Binding binding = this.createBindingForCompilation();
                this.scriptClassLoader = ScriptClassLoader.createClassLoader();
                this.scriptClassLoader.setSecurityManager(scriptingSecurityManager);
                GroovyShell shell = new GroovyShell((ClassLoader)((Object)this.scriptClassLoader), binding, GroovyScript.createCompilerConfiguration());
                this.compileTimeStrategy.scriptCompileStart();
                if (this.script instanceof String) {
                    this.compiledScript = (FreeplaneScriptBaseClass)shell.parse((String)this.script);
                } else if (this.script instanceof File) {
                    this.compiledScript = (FreeplaneScriptBaseClass)shell.parse((File)this.script);
                } else {
                    throw new IllegalArgumentException();
                }
                this.compiledScript.setScript(this.script);
                this.compileTimeStrategy.scriptCompiled();
            }
            catch (Throwable e) {
                this.errorsInScript = e;
                throw e;
            }
        }
    }

    static void checkAccessPermissionCheckerExists() {
        if (!accessPermissionCheckerChecked) {
            if (System.getSecurityManager() != null) {
                try {
                    GroovyScript.class.getClassLoader().loadClass("org.codehaus.groovy.reflection.AccessPermissionChecker");
                }
                catch (ClassNotFoundException e) {
                    throw new AccessControlException("class org.codehaus.groovy.reflection.AccessPermissionChecker not found");
                }
            }
            accessPermissionCheckerChecked = true;
        }
    }

    private void removeOldScript() {
        if (this.compiledScript != null) {
            InvokerHelper.removeClass(((Object)((Object)this.compiledScript)).getClass());
            this.compiledScript = null;
        }
    }

    private Binding createBindingForCompilation() {
        Binding binding = new Binding();
        binding.setVariable("script", this.script);
        return binding;
    }

    private int findErrorLine(GroovyRuntimeException e) {
        ModuleNode module = e.getModule();
        ASTNode astNode = e.getNode();
        int lineNumber = -1;
        lineNumber = module != null ? module.getLineNumber() : (astNode != null ? astNode.getLineNumber() : this.findLineNumberInString(e.getMessage(), lineNumber));
        return lineNumber;
    }

    static CompilerConfiguration createCompilerConfiguration() {
        CompilerConfiguration config = new CompilerConfiguration();
        config.setScriptBaseClass(FreeplaneScriptBaseClass.class.getName());
        if (ScriptResources.getClasspath() != null && !ScriptResources.getClasspath().isEmpty()) {
            config.setClasspathList(ScriptResources.getClasspath());
        }
        ImportCustomizer importCustomizer = new ImportCustomizer();
        importCustomizer.addStaticImport(ScriptUtils.class.getName(), "ignoreCycles");
        importCustomizer.addStaticStars(new String[]{GroovyStaticImports.class.getName()});
        config.addCompilationCustomizers(new CompilationCustomizer[]{importCustomizer});
        return config;
    }

    private int findLineNumberInString(String resultString, int lineNumber) {
        Pattern pattern = Pattern.compile(".*@ line ([0-9]+).*", 32);
        Matcher matcher = pattern.matcher(resultString);
        if (matcher.matches()) {
            lineNumber = Integer.parseInt(matcher.group(1));
        }
        return lineNumber;
    }

    protected void finalize() throws Throwable {
        this.removeOldScript();
        super.finalize();
    }

    @Override
    public boolean hasPermissions(ScriptingPermissions permissions) {
        if (this.specificPermissions == null) {
            return this.specificPermissions == permissions;
        }
        return this.specificPermissions.equals(permissions);
    }
}

