/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.save;

import javax.swing.table.AbstractTableModel;
import tim.prune.I18nManager;
import tim.prune.save.PhotoTableEntry;

public class PhotoTableModel
extends AbstractTableModel {
    private final PhotoTableEntry[] _photos;
    private int _addIndex = 0;

    public PhotoTableModel(int n) {
        this._photos = new PhotoTableEntry[n];
    }

    public void addPhotoInfo(PhotoTableEntry photoTableEntry) {
        if (this._addIndex < this._photos.length && photoTableEntry != null && photoTableEntry.getStatus() != null) {
            this._photos[this._addIndex] = photoTableEntry;
            ++this._addIndex;
        }
    }

    public int getNumSaveablePhotos() {
        return this._addIndex;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return this._addIndex;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return this._photos[n].getName();
        }
        if (n2 == 1) {
            return this._photos[n].getStatus();
        }
        return this._photos[n].getSaveFlag();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 2;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 2) {
            this._photos[n].setSaveFlag((Boolean)object);
        }
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (n < 2) {
            return String.class;
        }
        return Boolean.class;
    }

    @Override
    public String getColumnName(int n) {
        if (n == 0) {
            return I18nManager.getText("dialog.saveexif.table.photoname");
        }
        if (n == 1) {
            return I18nManager.getText("dialog.saveexif.table.status");
        }
        return I18nManager.getText("dialog.saveexif.table.save");
    }

    public PhotoTableEntry getPhotoTableEntry(int n) {
        if (n < 0 || n >= this._photos.length) {
            return null;
        }
        return this._photos[n];
    }
}

