/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.constants.UnsignedValueConstant;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import org.jetbrains.annotations.NotNull;

public final class UShortValue
extends UnsignedValueConstant<Short> {
    public UShortValue(short shortValue) {
        super(shortValue);
    }

    @Override
    @NotNull
    public KotlinType getType(@NotNull ModuleDescriptor module) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        ClassDescriptor classDescriptor = FindClassInModuleKt.findClassAcrossModuleDependencies(module, StandardNames.FqNames.uShort);
        if (classDescriptor == null) {
            SimpleType simpleType2 = ErrorUtils.createErrorType("Unsigned type UShort not found");
            Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"createErrorType(\"Unsigned type UShort not found\")");
            kotlinType = simpleType2;
        } else {
            SimpleType simpleType3 = classDescriptor.getDefaultType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType3, (String)"module.findClassAcrossMo\u2026d type UShort not found\")");
            kotlinType = simpleType3;
        }
        return kotlinType;
    }

    @Override
    @NotNull
    public String toString() {
        return ((Number)this.getValue()).intValue() + ".toUShort()";
    }
}

