/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project.auto.reload;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.externalSystem.autoimport.AutoImportProjectTracker;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectAware;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectId;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectTracker;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.auto.reload.MavenGeneralSettingsWatcher;
import org.jetbrains.idea.maven.project.auto.reload.MavenProfileWatcher;
import org.jetbrains.idea.maven.project.auto.reload.MavenProjectAware;
import org.jetbrains.idea.maven.project.auto.reload.MavenRenameModuleWatcher;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

@ApiStatus.Internal
public final class MavenProjectManagerWatcher {
    private final Project myProject;
    private final MavenProjectAware myProjectAware;
    private final MavenProfileWatcher myProfileWatcher;
    private final MavenRenameModuleWatcher myRenameModuleWatcher;
    private final MavenGeneralSettingsWatcher myGeneralSettingsWatcher;
    private final Disposable myDisposable;
    private final AtomicBoolean myStarted = new AtomicBoolean(false);

    public MavenProjectManagerWatcher(Project project) {
        this.myProject = project;
        ExecutorService backgroundExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"MavenProjectsManagerWatcher.backgroundExecutor", (int)1);
        MavenProjectsManager projectManager = MavenProjectsManager.getInstance(this.myProject);
        ExternalSystemProjectTracker projectTracker = ExternalSystemProjectTracker.getInstance((Project)this.myProject);
        ExternalSystemProjectId projectId = new ExternalSystemProjectId(MavenUtil.SYSTEM_ID, this.myProject.getName());
        this.myProjectAware = new MavenProjectAware(project, projectId, projectManager);
        this.myProfileWatcher = new MavenProfileWatcher(projectId, projectTracker, projectManager);
        this.myRenameModuleWatcher = new MavenRenameModuleWatcher();
        this.myGeneralSettingsWatcher = new MavenGeneralSettingsWatcher(projectManager, backgroundExecutor);
        this.myDisposable = Disposer.newDisposable((Disposable)projectManager, (String)MavenProjectManagerWatcher.class.toString());
    }

    public synchronized void start() {
        if (!this.myStarted.compareAndSet(false, true)) {
            MavenLog.LOG.error("Trying to start the watcher one more time", (Throwable)new Exception());
            return;
        }
        MessageBusConnection busConnection = this.myProject.getMessageBus().connect(this.myDisposable);
        busConnection.subscribe(ModuleListener.TOPIC, (Object)this.myRenameModuleWatcher);
        this.myGeneralSettingsWatcher.subscribeOnSettingsChanges(this.myDisposable);
        this.myGeneralSettingsWatcher.subscribeOnSettingsFileChanges(this.myDisposable);
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(this.myProject);
        ExternalSystemProjectTracker projectTracker = ExternalSystemProjectTracker.getInstance((Project)this.myProject);
        projectTracker.register((ExternalSystemProjectAware)this.myProjectAware, (Disposable)projectsManager);
        projectTracker.activate(this.myProjectAware.getProjectId());
        this.myProfileWatcher.subscribeOnProfileChanges(this.myDisposable);
    }

    @TestOnly
    public synchronized void enableAutoImportInTests() {
        AutoImportProjectTracker.Companion.enableAutoReloadInTests(this.myDisposable);
    }

    public synchronized void stop() {
        Disposer.dispose((Disposable)this.myDisposable);
    }
}

