/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets.indy;

import org.jruby.RubyClass;
import org.jruby.compiler.NotCompilableException;
import org.jruby.ir.instructions.AsStringInstr;
import org.jruby.ir.instructions.CallBase;
import org.jruby.ir.instructions.EQQInstr;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.targets.IRBytecodeAdapter;
import org.jruby.ir.targets.InvocationCompiler;
import org.jruby.ir.targets.JVM;
import org.jruby.ir.targets.indy.ArrayDerefInvokeSite;
import org.jruby.ir.targets.indy.AsStringSite;
import org.jruby.ir.targets.indy.BlockGivenSite;
import org.jruby.ir.targets.indy.CallInfoBootstrap;
import org.jruby.ir.targets.indy.FrameNameSite;
import org.jruby.ir.targets.indy.SelfInvokeSite;
import org.jruby.ir.targets.indy.SuperInvokeSite;
import org.jruby.ir.targets.simple.NormalInvocationCompiler;
import org.jruby.ir.targets.simple.NormalInvokeSite;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.invokedynamic.MathLinker;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JavaNameMangler;

public class IndyInvocationCompiler
implements InvocationCompiler {
    private final IRBytecodeAdapter compiler;
    private final InvocationCompiler normalCompiler;

    public IndyInvocationCompiler(IRBytecodeAdapter compiler) {
        this.compiler = compiler;
        this.normalCompiler = new NormalInvocationCompiler(compiler);
    }

    @Override
    public void invokeOther(String file2, String scopeFieldName, CallBase call2, int arity2) {
        String id2 = call2.getId();
        if (arity2 > 250) {
            throw new NotCompilableException("call to '" + id2 + "' has more than 250 arguments");
        }
        if (call2.isPotentiallyRefined()) {
            this.normalCompiler.invokeOther(file2, scopeFieldName, call2, arity2);
            return;
        }
        int flags2 = call2.getFlags();
        IRBytecodeAdapter.BlockPassType blockPassType = IRBytecodeAdapter.BlockPassType.fromIR(call2);
        if (blockPassType.given()) {
            if (arity2 == -1) {
                this.compiler.adapter.invokedynamic("invoke:" + JavaNameMangler.mangleMethodName(id2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT_ARRAY, Block.class)), NormalInvokeSite.BOOTSTRAP, blockPassType.literal(), flags2, file2, this.compiler.getLastLine());
            } else {
                this.compiler.adapter.invokedynamic("invoke:" + JavaNameMangler.mangleMethodName(id2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, arity2 + 2, Block.class)), NormalInvokeSite.BOOTSTRAP, blockPassType.literal(), flags2, file2, this.compiler.getLastLine());
            }
        } else if (arity2 == -1) {
            this.compiler.adapter.invokedynamic("invoke:" + JavaNameMangler.mangleMethodName(id2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT_ARRAY)), NormalInvokeSite.BOOTSTRAP, false, flags2, file2, this.compiler.getLastLine());
        } else {
            this.compiler.adapter.invokedynamic("invoke:" + JavaNameMangler.mangleMethodName(id2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT, arity2)), NormalInvokeSite.BOOTSTRAP, false, flags2, file2, this.compiler.getLastLine());
        }
    }

    @Override
    public void invokeArrayDeref(String file2, String scopeFieldName, CallBase call2) {
        this.compiler.adapter.invokedynamic("aref", CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT, 1)), ArrayDerefInvokeSite.BOOTSTRAP, file2, this.compiler.getLastLine());
    }

    @Override
    public void invokeOtherOneFixnum(String file2, CallBase call2, long fixnum) {
        String id2 = call2.getId();
        if (!MethodIndex.hasFastFixnumOps(id2)) {
            this.compiler.getValueCompiler().pushFixnum(fixnum);
            this.invokeOtherOrSelfArity1(file2, this.compiler.getLastLine(), call2);
            return;
        }
        String signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class));
        this.compiler.adapter.invokedynamic("fixnumOperator:" + JavaNameMangler.mangleMethodName(id2), signature, MathLinker.FIXNUM_OPERATOR_BOOTSTRAP, fixnum, call2.getCallType().ordinal(), file2, this.compiler.getLastLine());
    }

    @Override
    public void invokeOtherOneFloat(String file2, CallBase call2, double flote) {
        String id2 = call2.getId();
        if (!MethodIndex.hasFastFloatOps(id2)) {
            this.compiler.getValueCompiler().pushFloat(flote);
            this.invokeOtherOrSelfArity1(file2, this.compiler.getLastLine(), call2);
            return;
        }
        String signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class));
        this.compiler.adapter.invokedynamic("floatOperator:" + JavaNameMangler.mangleMethodName(id2), signature, MathLinker.FLOAT_OPERATOR_BOOTSTRAP, flote, call2.getCallType().ordinal(), file2, this.compiler.getLastLine());
    }

    private void invokeOtherOrSelfArity1(String file2, int line, CallBase call2) {
        if (call2.getCallType() == CallType.NORMAL) {
            this.invokeOther(file2, null, call2, 1);
        } else {
            this.invokeSelf(file2, null, call2, 1);
        }
    }

    @Override
    public void invokeSelf(String file2, String scopeFieldName, CallBase call2, int arity2) {
        String id2 = call2.getId();
        if (arity2 > 250) {
            throw new NotCompilableException("call to '" + id2 + "' has more than 250 arguments");
        }
        if (call2.isPotentiallyRefined()) {
            this.normalCompiler.invokeSelf(file2, scopeFieldName, call2, arity2);
            return;
        }
        int flags2 = call2.getFlags();
        String action = call2.getCallType() == CallType.FUNCTIONAL ? "callFunctional" : "callVariable";
        IRBytecodeAdapter.BlockPassType blockPassType = IRBytecodeAdapter.BlockPassType.fromIR(call2);
        String callName = IndyInvocationCompiler.constructIndyCallName(action, id2);
        if (blockPassType != IRBytecodeAdapter.BlockPassType.NONE) {
            if (arity2 == -1) {
                this.compiler.adapter.invokedynamic(callName, CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT_ARRAY, Block.class)), SelfInvokeSite.BOOTSTRAP, blockPassType.literal(), flags2, file2, this.compiler.getLastLine());
            } else {
                this.compiler.adapter.invokedynamic(callName, CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, arity2 + 1, Block.class)), SelfInvokeSite.BOOTSTRAP, blockPassType.literal(), flags2, file2, this.compiler.getLastLine());
            }
        } else if (arity2 == -1) {
            this.compiler.adapter.invokedynamic(callName, CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT_ARRAY)), SelfInvokeSite.BOOTSTRAP, false, flags2, file2, this.compiler.getLastLine());
        } else {
            this.compiler.adapter.invokedynamic(callName, CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, arity2)), SelfInvokeSite.BOOTSTRAP, false, flags2, file2, this.compiler.getLastLine());
        }
    }

    public static String constructIndyCallName(String action, String id2) {
        return action + ":" + JavaNameMangler.mangleMethodName(id2);
    }

    @Override
    public void invokeInstanceSuper(String file2, String name2, int arity2, boolean hasClosure, boolean literalClosure, boolean[] splatmap, int flags2) {
        if (arity2 > 250) {
            throw new NotCompilableException("call to instance super has more than 250 arguments");
        }
        String splatmapString = IRRuntimeHelpers.encodeSplatmap(splatmap);
        if (hasClosure) {
            String operation = literalClosure ? "invokeInstanceSuperIter" : "invokeInstanceSuper";
            this.compiler.adapter.invokedynamic(operation + ":" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, RubyClass.class, JVM.OBJECT, arity2, Block.class)), SuperInvokeSite.BOOTSTRAP, splatmapString, flags2, file2, this.compiler.getLastLine());
        } else {
            this.compiler.adapter.invokedynamic("invokeInstanceSuper:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, RubyClass.class, JVM.OBJECT, arity2)), SuperInvokeSite.BOOTSTRAP, splatmapString, flags2, file2, this.compiler.getLastLine());
        }
    }

    @Override
    public void invokeClassSuper(String file2, String name2, int arity2, boolean hasClosure, boolean literalClosure, boolean[] splatmap, int flags2) {
        if (arity2 > 250) {
            throw new NotCompilableException("call to class super has more than 250 arguments");
        }
        String splatmapString = IRRuntimeHelpers.encodeSplatmap(splatmap);
        if (hasClosure) {
            String operation = literalClosure ? "invokeClassSuperIter" : "invokeClassSuper";
            this.compiler.adapter.invokedynamic(operation + ":" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, RubyClass.class, JVM.OBJECT, arity2, Block.class)), SuperInvokeSite.BOOTSTRAP, splatmapString, flags2, file2, this.compiler.getLastLine());
        } else {
            this.compiler.adapter.invokedynamic("invokeClassSuper:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, RubyClass.class, JVM.OBJECT, arity2)), SuperInvokeSite.BOOTSTRAP, splatmapString, flags2, file2, this.compiler.getLastLine());
        }
    }

    @Override
    public void invokeUnresolvedSuper(String file2, String name2, int arity2, boolean hasClosure, boolean literalClosure, boolean[] splatmap, int flags2) {
        if (arity2 > 250) {
            throw new NotCompilableException("call to unresolved super has more than 250 arguments");
        }
        String splatmapString = IRRuntimeHelpers.encodeSplatmap(splatmap);
        if (hasClosure) {
            String operation = literalClosure ? "invokeUnresolvedSuperIter" : "invokeUnresolvedSuper";
            this.compiler.adapter.invokedynamic(operation + ":" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, RubyClass.class, JVM.OBJECT, arity2, Block.class)), SuperInvokeSite.BOOTSTRAP, splatmapString, flags2, file2, this.compiler.getLastLine());
        } else {
            this.compiler.adapter.invokedynamic("invokeUnresolvedSuper:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, RubyClass.class, JVM.OBJECT, arity2)), SuperInvokeSite.BOOTSTRAP, splatmapString, flags2, file2, this.compiler.getLastLine());
        }
    }

    @Override
    public void invokeZSuper(String file2, String name2, int arity2, boolean hasClosure, boolean[] splatmap, int flags2) {
        if (arity2 > 250) {
            throw new NotCompilableException("call to zsuper has more than 250 arguments");
        }
        String splatmapString = IRRuntimeHelpers.encodeSplatmap(splatmap);
        if (hasClosure) {
            this.compiler.adapter.invokedynamic("invokeZSuper:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, RubyClass.class, JVM.OBJECT, arity2, Block.class)), SuperInvokeSite.BOOTSTRAP, splatmapString, flags2, file2, this.compiler.getLastLine());
        } else {
            this.compiler.adapter.invokedynamic("invokeZSuper:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, RubyClass.class, JVM.OBJECT, arity2)), SuperInvokeSite.BOOTSTRAP, splatmapString, flags2, file2, this.compiler.getLastLine());
        }
    }

    @Override
    public void invokeEQQ(EQQInstr call2) {
        this.normalCompiler.invokeEQQ(call2);
    }

    @Override
    public void asString(AsStringInstr call2, String scopeFieldName, String file2) {
        if (call2.isPotentiallyRefined()) {
            this.normalCompiler.asString(call2, scopeFieldName, file2);
            return;
        }
        this.compiler.adapter.invokedynamic("asString", CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT)), AsStringSite.BOOTSTRAP, file2, this.compiler.getLastLine());
    }

    @Override
    public void setCallInfo(int flags2) {
        this.compiler.loadContext();
        this.compiler.adapter.invokedynamic("callInfo", CodegenUtils.sig(Void.TYPE, ThreadContext.class), CallInfoBootstrap.CALL_INFO_BOOTSTRAP, flags2);
    }

    @Override
    public void invokeBlockGiven(String methodName, String file2) {
        IndyInvocationCompiler.invokeBlockGiven(this.compiler, methodName, file2);
    }

    public static void invokeBlockGiven(IRBytecodeAdapter compiler, String methodName, String file2) {
        compiler.loadContext();
        compiler.loadSelf();
        compiler.loadFrameBlock();
        compiler.adapter.invokedynamic(IndyInvocationCompiler.constructIndyCallName("callFunctional", methodName), CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, Block.class), BlockGivenSite.BLOCK_GIVEN_BOOTSTRAP, file2, compiler.getLastLine());
    }

    @Override
    public void invokeFrameName(String methodName, String file2) {
        IndyInvocationCompiler.invokeFrameName(this.compiler, methodName, file2);
    }

    public static void invokeFrameName(IRBytecodeAdapter compiler, String methodName, String file2) {
        compiler.loadContext();
        compiler.loadSelf();
        compiler.loadFrameName();
        compiler.adapter.invokedynamic(IndyInvocationCompiler.constructIndyCallName("callVariable", methodName), CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, String.class), FrameNameSite.FRAME_NAME_BOOTSTRAP, file2, compiler.getLastLine());
    }
}

