/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.spi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.util.Collection;
import java.util.Map;
import org.hibernate.models.IllegalCastException;
import org.hibernate.models.internal.CollectionElementSwitch;
import org.hibernate.models.internal.MapKeySwitch;
import org.hibernate.models.internal.MapValueSwitch;
import org.hibernate.models.internal.ModifierUtils;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.ClassBasedTypeDetails;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassLoading;
import org.hibernate.models.spi.ModelsContext;
import org.hibernate.models.spi.ParameterizedTypeDetails;
import org.hibernate.models.spi.TypeDetails;
import org.hibernate.models.spi.TypeDetailsHelper;
import org.hibernate.models.spi.TypeVariableDetails;
import org.hibernate.models.spi.TypeVariableScope;

public interface MemberDetails
extends AnnotationTarget {
    @Override
    public String getName();

    public TypeDetails getType();

    @Override
    default public ClassDetails getContainer(ModelsContext modelsContext) {
        return this.getDeclaringType();
    }

    default public TypeDetails getAssociatedType() {
        return this.isPlural() ? this.getElementType() : this.getType();
    }

    default public TypeDetails getElementType() {
        TypeDetails memberType = this.getType();
        if (memberType == null) {
            return null;
        }
        if (memberType.getTypeKind() == TypeDetails.Kind.ARRAY) {
            return memberType.asArrayType().getConstituentType();
        }
        if (memberType.isImplementor(Collection.class)) {
            if (memberType.getTypeKind() == TypeDetails.Kind.CLASS) {
                return CollectionElementSwitch.extractCollectionElementType(memberType);
            }
            if (memberType.getTypeKind() == TypeDetails.Kind.PARAMETERIZED_TYPE) {
                ParameterizedTypeDetails parameterizedType = memberType.asParameterizedType();
                if (!1.$assertionsDisabled && parameterizedType.getArguments().size() != 1) {
                    throw new AssertionError();
                }
                return parameterizedType.getArguments().get(0);
            }
            if (memberType.getTypeKind() == TypeDetails.Kind.TYPE_VARIABLE) {
                TypeVariableDetails typeVariable = memberType.asTypeVariable();
                if (!1.$assertionsDisabled && typeVariable.getBounds().size() != 1) {
                    throw new AssertionError();
                }
                return typeVariable.getBounds().get(0);
            }
        }
        if (memberType.isImplementor(Map.class)) {
            if (memberType.getTypeKind() == TypeDetails.Kind.CLASS) {
                return MapValueSwitch.extractMapValueType(memberType);
            }
            if (memberType.getTypeKind() == TypeDetails.Kind.PARAMETERIZED_TYPE) {
                ParameterizedTypeDetails parameterizedType = memberType.asParameterizedType();
                if (!1.$assertionsDisabled && parameterizedType.getArguments().size() != 2) {
                    throw new AssertionError();
                }
                return parameterizedType.getArguments().get(1);
            }
            if (memberType.getTypeKind() == TypeDetails.Kind.TYPE_VARIABLE) {
                TypeVariableDetails typeVariable = memberType.asTypeVariable();
                if (!1.$assertionsDisabled && typeVariable.getBounds().size() != 2) {
                    throw new AssertionError();
                }
                return typeVariable.getBounds().get(1);
            }
        }
        return null;
    }

    default public TypeDetails getMapKeyType() {
        TypeDetails memberType = this.getType();
        if (memberType == null) {
            return null;
        }
        if (memberType.isImplementor(Map.class)) {
            if (memberType.getTypeKind() == TypeDetails.Kind.CLASS) {
                return MapKeySwitch.extractMapKeyType(memberType);
            }
            if (memberType.getTypeKind() == TypeDetails.Kind.PARAMETERIZED_TYPE) {
                ParameterizedTypeDetails parameterizedType = memberType.asParameterizedType();
                if (!1.$assertionsDisabled && parameterizedType.getArguments().size() != 2) {
                    throw new AssertionError();
                }
                return parameterizedType.getArguments().get(0);
            }
            if (memberType.getTypeKind() == TypeDetails.Kind.TYPE_VARIABLE) {
                TypeVariableDetails typeVariable = memberType.asTypeVariable();
                if (!1.$assertionsDisabled && typeVariable.getBounds().size() != 2) {
                    throw new AssertionError();
                }
                return typeVariable.getBounds().get(0);
            }
        }
        return null;
    }

    public ClassDetails getDeclaringType();

    public boolean isPlural();

    public boolean isArray();

    public int getModifiers();

    default public Visibility getVisibility() {
        return ModifierUtils.resolveVisibility(this.getModifiers());
    }

    default public boolean isStatic() {
        return ModifierUtils.isStatic(this.getModifiers());
    }

    default public boolean isSynthetic() {
        return ModifierUtils.isSynthetic(this.getModifiers());
    }

    default public boolean isFinal() {
        return ModifierUtils.isFinal(this.getModifiers());
    }

    default public boolean isField() {
        return this.getKind() == AnnotationTarget.Kind.FIELD;
    }

    public boolean isPersistable();

    public String resolveAttributeName();

    public Member toJavaMember();

    public Member toJavaMember(Class<?> var1, ClassLoading var2, ModelsContext var3);

    default public TypeDetails resolveRelativeType(TypeVariableScope container) {
        return this.getType().determineRelativeType(container);
    }

    default public TypeDetails resolveRelativeAssociatedType(TypeVariableScope container) {
        return this.getAssociatedType().determineRelativeType(container);
    }

    default public ClassBasedTypeDetails resolveRelativeClassType(TypeVariableScope container) {
        return TypeDetailsHelper.resolveRelativeClassType(this.getType(), container);
    }

    @Override
    default public MemberDetails asMemberDetails() {
        return this;
    }

    @Override
    default public <A extends Annotation> AnnotationDescriptor<A> asAnnotationDescriptor() {
        throw new IllegalCastException("MemberDetails cannot be cast to an AnnotationDescriptor");
    }

    @Override
    default public ClassDetails asClassDetails() {
        throw new IllegalCastException("MemberDetails cannot be cast to a ClassDetails");
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static enum Visibility {
        PUBLIC,
        PROTECTED,
        PACKAGE,
        PRIVATE;

    }
}

