/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.IOException;
import java.util.Objects;
import java.util.function.LongPredicate;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesSkipper;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.ConstantScoreScorerSupplier;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.DocValuesRangeIterator;
import org.apache.lucene.search.FieldExistsQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;

final class SortedNumericDocValuesRangeQuery
extends Query {
    private final String field;
    private final long lowerValue;
    private final long upperValue;

    SortedNumericDocValuesRangeQuery(String field, long lowerValue, long upperValue) {
        this.field = Objects.requireNonNull(field);
        this.lowerValue = lowerValue;
        this.upperValue = upperValue;
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        SortedNumericDocValuesRangeQuery that = (SortedNumericDocValuesRangeQuery)obj;
        return Objects.equals(this.field, that.field) && this.lowerValue == that.lowerValue && this.upperValue == that.upperValue;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.classHash(), this.field, this.lowerValue, this.upperValue);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf(this);
        }
    }

    @Override
    public String toString(String field) {
        StringBuilder b = new StringBuilder();
        if (!this.field.equals(field)) {
            b.append(this.field).append(":");
        }
        return b.append("[").append(this.lowerValue).append(" TO ").append(this.upperValue).append("]").toString();
    }

    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        if (this.lowerValue == Long.MIN_VALUE && this.upperValue == Long.MAX_VALUE) {
            return new FieldExistsQuery(this.field);
        }
        if (this.lowerValue > this.upperValue) {
            return new MatchNoDocsQuery();
        }
        long globalMin = DocValuesSkipper.globalMinValue(indexSearcher, this.field);
        long globalMax = DocValuesSkipper.globalMaxValue(indexSearcher, this.field);
        if (this.lowerValue > globalMax || this.upperValue < globalMin) {
            return new MatchNoDocsQuery();
        }
        if (this.lowerValue <= globalMin && this.upperValue >= globalMax && DocValuesSkipper.globalDocCount(indexSearcher, this.field) == indexSearcher.getIndexReader().maxDoc()) {
            return new MatchAllDocsQuery();
        }
        return super.rewrite(indexSearcher);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return DocValues.isCacheable(ctx, SortedNumericDocValuesRangeQuery.this.field);
            }

            @Override
            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                TwoPhaseIterator iterator;
                if (context.reader().getFieldInfos().fieldInfo(SortedNumericDocValuesRangeQuery.this.field) == null) {
                    return null;
                }
                int maxDoc = context.reader().maxDoc();
                int count = this.docCountIgnoringDeletes(context);
                if (count == 0) {
                    return null;
                }
                if (count == maxDoc) {
                    return ConstantScoreScorerSupplier.matchAll(this.score(), scoreMode, maxDoc);
                }
                final SortedNumericDocValues values = DocValues.getSortedNumeric(context.reader(), SortedNumericDocValuesRangeQuery.this.field);
                final NumericDocValues singleton = DocValues.unwrapSingleton(values);
                DocValuesSkipper skipper = context.reader().getDocValuesSkipper(SortedNumericDocValuesRangeQuery.this.field);
                if (singleton != null) {
                    DocIdSetIterator psIterator;
                    if (skipper != null && (psIterator = SortedNumericDocValuesRangeQuery.this.getDocIdSetIteratorOrNullForPrimarySort(context.reader(), singleton, skipper)) != null) {
                        return ConstantScoreScorerSupplier.fromIterator(psIterator, this.score(), scoreMode, maxDoc);
                    }
                    iterator = new TwoPhaseIterator(singleton){

                        @Override
                        public boolean matches() throws IOException {
                            long value = singleton.longValue();
                            return value >= SortedNumericDocValuesRangeQuery.this.lowerValue && value <= SortedNumericDocValuesRangeQuery.this.upperValue;
                        }

                        @Override
                        public float matchCost() {
                            return 2.0f;
                        }
                    };
                } else {
                    iterator = new TwoPhaseIterator(values){

                        @Override
                        public boolean matches() throws IOException {
                            int count = values.docValueCount();
                            for (int i = 0; i < count; ++i) {
                                long value = values.nextValue();
                                if (value < SortedNumericDocValuesRangeQuery.this.lowerValue) continue;
                                return value <= SortedNumericDocValuesRangeQuery.this.upperValue;
                            }
                            return false;
                        }

                        @Override
                        public float matchCost() {
                            return 2.0f;
                        }
                    };
                }
                if (skipper != null) {
                    iterator = new DocValuesRangeIterator(iterator, skipper, SortedNumericDocValuesRangeQuery.this.lowerValue, SortedNumericDocValuesRangeQuery.this.upperValue, false);
                }
                return ConstantScoreScorerSupplier.fromIterator(TwoPhaseIterator.asDocIdSetIterator(iterator), this.score(), scoreMode, maxDoc);
            }

            @Override
            public int count(LeafReaderContext context) throws IOException {
                int maxDoc = context.reader().maxDoc();
                int cnt = this.docCountIgnoringDeletes(context);
                if (cnt == maxDoc) {
                    return context.reader().numDocs();
                }
                return cnt;
            }

            private int docCountIgnoringDeletes(LeafReaderContext context) throws IOException {
                DocValuesSkipper skipper = context.reader().getDocValuesSkipper(SortedNumericDocValuesRangeQuery.this.field);
                if (skipper != null) {
                    if (skipper.minValue() > SortedNumericDocValuesRangeQuery.this.upperValue || skipper.maxValue() < SortedNumericDocValuesRangeQuery.this.lowerValue) {
                        return 0;
                    }
                    if (skipper.docCount() == context.reader().maxDoc() && skipper.minValue() >= SortedNumericDocValuesRangeQuery.this.lowerValue && skipper.maxValue() <= SortedNumericDocValuesRangeQuery.this.upperValue) {
                        return context.reader().maxDoc();
                    }
                }
                return -1;
            }
        };
    }

    private DocIdSetIterator getDocIdSetIteratorOrNullForPrimarySort(LeafReader reader, NumericDocValues numericDocValues, DocValuesSkipper skipper) throws IOException {
        int maxDocID;
        int minDocID;
        if (skipper.docCount() != reader.maxDoc()) {
            return null;
        }
        Sort indexSort = reader.getMetaData().sort();
        if (indexSort == null || indexSort.getSort().length == 0 || !indexSort.getSort()[0].getField().equals(this.field)) {
            return null;
        }
        if (indexSort.getSort()[0].getReverse()) {
            if (skipper.maxValue() <= this.upperValue) {
                minDocID = 0;
            } else {
                skipper.advance(Long.MIN_VALUE, this.upperValue);
                minDocID = SortedNumericDocValuesRangeQuery.nextDoc(skipper.minDocID(0), numericDocValues, l -> l <= this.upperValue);
            }
            if (skipper.minValue() >= this.lowerValue) {
                maxDocID = skipper.docCount();
            } else {
                skipper.advance(Long.MIN_VALUE, this.lowerValue);
                maxDocID = SortedNumericDocValuesRangeQuery.nextDoc(skipper.minDocID(0), numericDocValues, l -> l < this.lowerValue);
            }
        } else {
            if (skipper.minValue() >= this.lowerValue) {
                minDocID = 0;
            } else {
                skipper.advance(this.lowerValue, Long.MAX_VALUE);
                minDocID = SortedNumericDocValuesRangeQuery.nextDoc(skipper.minDocID(0), numericDocValues, l -> l >= this.lowerValue);
            }
            if (skipper.maxValue() <= this.upperValue) {
                maxDocID = skipper.docCount();
            } else {
                skipper.advance(this.upperValue, Long.MAX_VALUE);
                maxDocID = SortedNumericDocValuesRangeQuery.nextDoc(skipper.minDocID(0), numericDocValues, l -> l > this.upperValue);
            }
        }
        return minDocID == maxDocID ? DocIdSetIterator.empty() : DocIdSetIterator.range(minDocID, maxDocID);
    }

    private static int nextDoc(int startDoc, NumericDocValues docValues, LongPredicate predicate) throws IOException {
        int doc = docValues.docID();
        if (startDoc > doc) {
            doc = docValues.advance(startDoc);
        }
        while (doc < Integer.MAX_VALUE && !predicate.test(docValues.longValue())) {
            doc = docValues.nextDoc();
        }
        return doc;
    }
}

