/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.exception.DataElementParseErrorException;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.DataElementData;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StorageIndexCellMapping;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StorageIndexManifestMapping;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StorageIndexRevisionMapping;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObjectHeaderStart;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObjectTypeHeaderStart;

public class StorageIndexDataElementData
extends DataElementData {
    public StorageIndexManifestMapping storageIndexManifestMapping = new StorageIndexManifestMapping();
    public List<StorageIndexCellMapping> storageIndexCellMappingList = new ArrayList<StorageIndexCellMapping>();
    public List<StorageIndexRevisionMapping> storageIndexRevisionMappingList = new ArrayList<StorageIndexRevisionMapping>();

    @Override
    public List<Byte> serializeToByteList() throws TikaException, IOException {
        ArrayList<Byte> byteList = new ArrayList<Byte>();
        if (this.storageIndexManifestMapping != null) {
            byteList.addAll(this.storageIndexManifestMapping.serializeToByteList());
        }
        if (this.storageIndexCellMappingList != null) {
            for (StorageIndexCellMapping cellMapping : this.storageIndexCellMappingList) {
                byteList.addAll(cellMapping.serializeToByteList());
            }
        }
        if (this.storageIndexRevisionMappingList != null) {
            for (StorageIndexRevisionMapping revisionMapping : this.storageIndexRevisionMappingList) {
                byteList.addAll(revisionMapping.serializeToByteList());
            }
        }
        return byteList;
    }

    @Override
    public int deserializeDataElementDataFromByteArray(byte[] byteArray, int startIndex) throws TikaException, IOException {
        AtomicInteger index = new AtomicInteger(startIndex);
        int headerLength = 0;
        AtomicReference<StreamObjectHeaderStart> header = new AtomicReference<StreamObjectHeaderStart>();
        boolean isStorageIndexManifestMappingExist = false;
        while ((headerLength = StreamObjectHeaderStart.tryParse(byteArray, index.get(), header)) != 0) {
            index.addAndGet(headerLength);
            if (header.get().type == StreamObjectTypeHeaderStart.StorageIndexManifestMapping) {
                if (isStorageIndexManifestMappingExist) {
                    throw new DataElementParseErrorException(index.get() - headerLength, "Failed to parse StorageIndexDataElement, only can contain zero or one StorageIndexManifestMapping", null);
                }
                this.storageIndexManifestMapping = (StorageIndexManifestMapping)StreamObject.parseStreamObject(header.get(), byteArray, index);
                isStorageIndexManifestMappingExist = true;
                continue;
            }
            if (header.get().type == StreamObjectTypeHeaderStart.StorageIndexCellMapping) {
                this.storageIndexCellMappingList.add((StorageIndexCellMapping)StreamObject.parseStreamObject(header.get(), byteArray, index));
                continue;
            }
            if (header.get().type == StreamObjectTypeHeaderStart.StorageIndexRevisionMapping) {
                this.storageIndexRevisionMappingList.add((StorageIndexRevisionMapping)StreamObject.parseStreamObject(header.get(), byteArray, index));
                continue;
            }
            throw new DataElementParseErrorException(index.get() - headerLength, "Failed to parse StorageIndexDataElement, expect the inner object type StorageIndexCellMapping or StorageIndexRevisionMapping, but actual type value is " + header.get().type, null);
        }
        return index.get() - startIndex;
    }
}

