/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.algorithms.metrics_correlation;

import ai.djl.modality.Output;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.types.Shape;
import ai.djl.translate.Batchifier;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorContext;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import org.opensearch.ml.common.output.execute.metrics_correlation.MCorrModelTensor;
import org.opensearch.ml.common.output.execute.metrics_correlation.MCorrModelTensors;

public class MetricsCorrelationTranslator
implements Translator<float[][], Output> {
    public Batchifier getBatchifier() {
        return null;
    }

    public void prepare(TranslatorContext ctx) {
    }

    public NDList processInput(TranslatorContext ctx, float[][] input) {
        FloatBuffer buffer = FloatBuffer.allocate(input.length * input[0].length);
        for (float[] d : input) {
            buffer.put(d);
        }
        buffer.rewind();
        NDArray array = ctx.getNDManager().create((Buffer)buffer, new Shape(new long[]{input.length, input[0].length}));
        NDList inputNDList = new NDList(new NDArray[]{array});
        inputNDList.attach(ctx.getNDManager());
        return inputNDList;
    }

    public Output processOutput(TranslatorContext ctx, NDList list) {
        Output output = new Output(200, "OK");
        ArrayList<MCorrModelTensor> outputs = new ArrayList<MCorrModelTensor>();
        Iterator iterator = list.iterator();
        int i = 0;
        float[] event_window = null;
        float[] event_pattern = null;
        long[] suspected_metrics = null;
        while (iterator.hasNext()) {
            ++i;
            NDArray ndArray = (NDArray)iterator.next();
            if ("event_window".equals(ndArray.getName())) {
                event_window = ndArray.toFloatArray();
            } else if ("suspected_metrics".equals(ndArray.getName())) {
                suspected_metrics = ndArray.toLongArray();
            } else if ("event_pattern".equals(ndArray.getName())) {
                event_pattern = ndArray.toFloatArray();
            }
            if (i % 3 != 0) continue;
            outputs.add(new MCorrModelTensor(event_window, event_pattern, suspected_metrics));
            event_window = null;
            event_pattern = null;
            suspected_metrics = null;
        }
        MCorrModelTensors modelTensorOutput = new MCorrModelTensors(outputs);
        output.add(modelTensorOutput.toBytes());
        return output;
    }
}

