/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.Refresh;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch._types.VersionType;
import org.opensearch.client.opensearch.core.search.SourceConfigParam;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.BooleanEndpoint;
import org.opensearch.client.transport.endpoints.BooleanResponse;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

public final class ExistsRequest
extends RequestBase
implements ToCopyableBuilder<Builder, ExistsRequest> {
    @Nonnull
    private final String id;
    @Nonnull
    private final String index;
    @Nullable
    private final String preference;
    @Nullable
    private final Boolean realtime;
    @Nullable
    private final Refresh refresh;
    @Nonnull
    private final List<String> routing;
    @Nullable
    private final SourceConfigParam source;
    @Nonnull
    private final List<String> sourceExcludes;
    @Nonnull
    private final List<String> sourceIncludes;
    @Nonnull
    private final List<String> storedFields;
    @Nullable
    private final Long version;
    @Nullable
    private final VersionType versionType;
    public static final Endpoint<ExistsRequest, BooleanResponse, ErrorResponse> _ENDPOINT = new BooleanEndpoint<ExistsRequest>(request -> "HEAD", request -> {
        StringBuilder buf = new StringBuilder();
        buf.append("/");
        SimpleEndpoint.pathEncode(request.index, buf);
        buf.append("/_doc/");
        SimpleEndpoint.pathEncode(request.id, buf);
        return buf.toString();
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap());

    private ExistsRequest(Builder builder) {
        super(builder);
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.preference = builder.preference;
        this.realtime = builder.realtime;
        this.refresh = builder.refresh;
        this.routing = ApiTypeHelper.unmodifiable(builder.routing);
        this.source = builder.source;
        this.sourceExcludes = ApiTypeHelper.unmodifiable(builder.sourceExcludes);
        this.sourceIncludes = ApiTypeHelper.unmodifiable(builder.sourceIncludes);
        this.storedFields = ApiTypeHelper.unmodifiable(builder.storedFields);
        this.version = builder.version;
        this.versionType = builder.versionType;
    }

    public static ExistsRequest of(Function<Builder, ObjectBuilder<ExistsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final String id() {
        return this.id;
    }

    @Nonnull
    public final String index() {
        return this.index;
    }

    @Nullable
    public final String preference() {
        return this.preference;
    }

    @Nullable
    public final Boolean realtime() {
        return this.realtime;
    }

    @Nullable
    public final Refresh refresh() {
        return this.refresh;
    }

    @Nonnull
    public final List<String> routing() {
        return this.routing;
    }

    @Nullable
    public final SourceConfigParam source() {
        return this.source;
    }

    @Nonnull
    public final List<String> sourceExcludes() {
        return this.sourceExcludes;
    }

    @Nonnull
    public final List<String> sourceIncludes() {
        return this.sourceIncludes;
    }

    @Nonnull
    public final List<String> storedFields() {
        return this.storedFields;
    }

    @Nullable
    public final Long version() {
        return this.version;
    }

    @Nullable
    public final VersionType versionType() {
        return this.versionType;
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (this.preference != null) {
            params.put("preference", this.preference);
        }
        if (this.realtime != null) {
            params.put("realtime", String.valueOf(this.realtime));
        }
        if (this.refresh != null) {
            params.put("refresh", this.refresh.jsonValue());
        }
        if (ApiTypeHelper.isDefined(this.routing)) {
            params.put("routing", String.join((CharSequence)",", this.routing));
        }
        if (this.source != null) {
            params.put("_source", this.source._toJsonString());
        }
        if (ApiTypeHelper.isDefined(this.sourceExcludes)) {
            params.put("_source_excludes", String.join((CharSequence)",", this.sourceExcludes));
        }
        if (ApiTypeHelper.isDefined(this.sourceIncludes)) {
            params.put("_source_includes", String.join((CharSequence)",", this.sourceIncludes));
        }
        if (ApiTypeHelper.isDefined(this.storedFields)) {
            params.put("stored_fields", String.join((CharSequence)",", this.storedFields));
        }
        if (this.version != null) {
            params.put("version", String.valueOf(this.version));
        }
        if (this.versionType != null) {
            params.put("version_type", this.versionType.jsonValue());
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.id.hashCode();
        result = 31 * result + this.index.hashCode();
        result = 31 * result + Objects.hashCode(this.preference);
        result = 31 * result + Objects.hashCode(this.realtime);
        result = 31 * result + Objects.hashCode(this.refresh);
        result = 31 * result + Objects.hashCode(this.routing);
        result = 31 * result + Objects.hashCode(this.source);
        result = 31 * result + Objects.hashCode(this.sourceExcludes);
        result = 31 * result + Objects.hashCode(this.sourceIncludes);
        result = 31 * result + Objects.hashCode(this.storedFields);
        result = 31 * result + Objects.hashCode(this.version);
        result = 31 * result + Objects.hashCode(this.versionType);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExistsRequest other = (ExistsRequest)o;
        return this.id.equals(other.id) && this.index.equals(other.index) && Objects.equals(this.preference, other.preference) && Objects.equals(this.realtime, other.realtime) && Objects.equals(this.refresh, other.refresh) && Objects.equals(this.routing, other.routing) && Objects.equals(this.source, other.source) && Objects.equals(this.sourceExcludes, other.sourceExcludes) && Objects.equals(this.sourceIncludes, other.sourceIncludes) && Objects.equals(this.storedFields, other.storedFields) && Objects.equals(this.version, other.version) && Objects.equals(this.versionType, other.versionType);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, ExistsRequest> {
        private String id;
        private String index;
        @Nullable
        private String preference;
        @Nullable
        private Boolean realtime;
        @Nullable
        private Refresh refresh;
        @Nullable
        private List<String> routing;
        @Nullable
        private SourceConfigParam source;
        @Nullable
        private List<String> sourceExcludes;
        @Nullable
        private List<String> sourceIncludes;
        @Nullable
        private List<String> storedFields;
        @Nullable
        private Long version;
        @Nullable
        private VersionType versionType;

        public Builder() {
        }

        private Builder(ExistsRequest o) {
            super(o);
            this.id = o.id;
            this.index = o.index;
            this.preference = o.preference;
            this.realtime = o.realtime;
            this.refresh = o.refresh;
            this.routing = Builder._listCopy(o.routing);
            this.source = o.source;
            this.sourceExcludes = Builder._listCopy(o.sourceExcludes);
            this.sourceIncludes = Builder._listCopy(o.sourceIncludes);
            this.storedFields = Builder._listCopy(o.storedFields);
            this.version = o.version;
            this.versionType = o.versionType;
        }

        private Builder(Builder o) {
            super(o);
            this.id = o.id;
            this.index = o.index;
            this.preference = o.preference;
            this.realtime = o.realtime;
            this.refresh = o.refresh;
            this.routing = Builder._listCopy(o.routing);
            this.source = o.source;
            this.sourceExcludes = Builder._listCopy(o.sourceExcludes);
            this.sourceIncludes = Builder._listCopy(o.sourceIncludes);
            this.storedFields = Builder._listCopy(o.storedFields);
            this.version = o.version;
            this.versionType = o.versionType;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        @Nonnull
        public final Builder index(String value) {
            this.index = value;
            return this;
        }

        @Nonnull
        public final Builder preference(@Nullable String value) {
            this.preference = value;
            return this;
        }

        @Nonnull
        public final Builder realtime(@Nullable Boolean value) {
            this.realtime = value;
            return this;
        }

        @Nonnull
        public final Builder refresh(@Nullable Refresh value) {
            this.refresh = value;
            return this;
        }

        @Nonnull
        public final Builder routing(List<String> list) {
            this.routing = Builder._listAddAll(this.routing, list);
            return this;
        }

        @Nonnull
        public final Builder routing(String value, String ... values) {
            this.routing = Builder._listAdd(this.routing, value, values);
            return this;
        }

        @Nonnull
        public final Builder source(@Nullable SourceConfigParam value) {
            this.source = value;
            return this;
        }

        @Nonnull
        public final Builder source(Function<SourceConfigParam.Builder, ObjectBuilder<SourceConfigParam>> fn) {
            return this.source(fn.apply(new SourceConfigParam.Builder()).build());
        }

        @Nonnull
        public final Builder sourceExcludes(List<String> list) {
            this.sourceExcludes = Builder._listAddAll(this.sourceExcludes, list);
            return this;
        }

        @Nonnull
        public final Builder sourceExcludes(String value, String ... values) {
            this.sourceExcludes = Builder._listAdd(this.sourceExcludes, value, values);
            return this;
        }

        @Nonnull
        public final Builder sourceIncludes(List<String> list) {
            this.sourceIncludes = Builder._listAddAll(this.sourceIncludes, list);
            return this;
        }

        @Nonnull
        public final Builder sourceIncludes(String value, String ... values) {
            this.sourceIncludes = Builder._listAdd(this.sourceIncludes, value, values);
            return this;
        }

        @Nonnull
        public final Builder storedFields(List<String> list) {
            this.storedFields = Builder._listAddAll(this.storedFields, list);
            return this;
        }

        @Nonnull
        public final Builder storedFields(String value, String ... values) {
            this.storedFields = Builder._listAdd(this.storedFields, value, values);
            return this;
        }

        @Nonnull
        public final Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        @Nonnull
        public final Builder versionType(@Nullable VersionType value) {
            this.versionType = value;
            return this;
        }

        @Override
        @Nonnull
        public ExistsRequest build() {
            this._checkSingleUse();
            return new ExistsRequest(this);
        }
    }
}

