/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.SyncContext;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.deployment.DeployResult;
import org.eclipse.aether.deployment.DeploymentException;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.impl.ArtifactDescriptorReader;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.impl.DependencyCollector;
import org.eclipse.aether.impl.Deployer;
import org.eclipse.aether.impl.Installer;
import org.eclipse.aether.impl.LocalRepositoryProvider;
import org.eclipse.aether.impl.MetadataResolver;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.impl.SyncContextFactory;
import org.eclipse.aether.impl.VersionRangeResolver;
import org.eclipse.aether.impl.VersionResolver;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.installation.InstallResult;
import org.eclipse.aether.installation.InstallationException;
import org.eclipse.aether.internal.impl.ArtifactRequestBuilder;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.NoLocalRepositoryManagerException;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.resolution.MetadataRequest;
import org.eclipse.aether.resolution.MetadataResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.resolution.VersionRequest;
import org.eclipse.aether.resolution.VersionResolutionException;
import org.eclipse.aether.resolution.VersionResult;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.spi.log.LoggerFactory;
import org.eclipse.aether.util.graph.visitor.FilteringDependencyVisitor;
import org.eclipse.aether.util.graph.visitor.TreeDependencyVisitor;

@Named
public class DefaultRepositorySystem
implements RepositorySystem,
Service {
    private VersionResolver versionResolver;
    private VersionRangeResolver versionRangeResolver;
    private ArtifactResolver artifactResolver;
    private MetadataResolver metadataResolver;
    private ArtifactDescriptorReader artifactDescriptorReader;
    private DependencyCollector dependencyCollector;
    private Installer installer;
    private Deployer deployer;
    private LocalRepositoryProvider localRepositoryProvider;
    private SyncContextFactory syncContextFactory;
    private RemoteRepositoryManager remoteRepositoryManager;

    public DefaultRepositorySystem() {
    }

    @Inject
    DefaultRepositorySystem(VersionResolver versionResolver, VersionRangeResolver versionRangeResolver, ArtifactResolver artifactResolver, MetadataResolver metadataResolver, ArtifactDescriptorReader artifactDescriptorReader, DependencyCollector dependencyCollector, Installer installer, Deployer deployer, LocalRepositoryProvider localRepositoryProvider, SyncContextFactory syncContextFactory, RemoteRepositoryManager remoteRepositoryManager) {
        this.setVersionResolver(versionResolver);
        this.setVersionRangeResolver(versionRangeResolver);
        this.setArtifactResolver(artifactResolver);
        this.setMetadataResolver(metadataResolver);
        this.setArtifactDescriptorReader(artifactDescriptorReader);
        this.setDependencyCollector(dependencyCollector);
        this.setInstaller(installer);
        this.setDeployer(deployer);
        this.setLocalRepositoryProvider(localRepositoryProvider);
        this.setSyncContextFactory(syncContextFactory);
        this.setRemoteRepositoryManager(remoteRepositoryManager);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setVersionResolver(locator.getService(VersionResolver.class));
        this.setVersionRangeResolver(locator.getService(VersionRangeResolver.class));
        this.setArtifactResolver(locator.getService(ArtifactResolver.class));
        this.setMetadataResolver(locator.getService(MetadataResolver.class));
        this.setArtifactDescriptorReader(locator.getService(ArtifactDescriptorReader.class));
        this.setDependencyCollector(locator.getService(DependencyCollector.class));
        this.setInstaller(locator.getService(Installer.class));
        this.setDeployer(locator.getService(Deployer.class));
        this.setLocalRepositoryProvider(locator.getService(LocalRepositoryProvider.class));
        this.setRemoteRepositoryManager(locator.getService(RemoteRepositoryManager.class));
        this.setSyncContextFactory(locator.getService(SyncContextFactory.class));
    }

    @Deprecated
    public DefaultRepositorySystem setLoggerFactory(LoggerFactory loggerFactory) {
        return this;
    }

    public DefaultRepositorySystem setVersionResolver(VersionResolver versionResolver) {
        this.versionResolver = Objects.requireNonNull(versionResolver, "version resolver cannot be null");
        return this;
    }

    public DefaultRepositorySystem setVersionRangeResolver(VersionRangeResolver versionRangeResolver) {
        this.versionRangeResolver = Objects.requireNonNull(versionRangeResolver, "version range resolver cannot be null");
        return this;
    }

    public DefaultRepositorySystem setArtifactResolver(ArtifactResolver artifactResolver) {
        this.artifactResolver = Objects.requireNonNull(artifactResolver, "artifact resolver cannot be null");
        return this;
    }

    public DefaultRepositorySystem setMetadataResolver(MetadataResolver metadataResolver) {
        this.metadataResolver = Objects.requireNonNull(metadataResolver, "metadata resolver cannot be null");
        return this;
    }

    public DefaultRepositorySystem setArtifactDescriptorReader(ArtifactDescriptorReader artifactDescriptorReader) {
        this.artifactDescriptorReader = Objects.requireNonNull(artifactDescriptorReader, "artifact descriptor reader cannot be null");
        return this;
    }

    public DefaultRepositorySystem setDependencyCollector(DependencyCollector dependencyCollector) {
        this.dependencyCollector = Objects.requireNonNull(dependencyCollector, "dependency collector cannot be null");
        return this;
    }

    public DefaultRepositorySystem setInstaller(Installer installer) {
        this.installer = Objects.requireNonNull(installer, "installer cannot be null");
        return this;
    }

    public DefaultRepositorySystem setDeployer(Deployer deployer) {
        this.deployer = Objects.requireNonNull(deployer, "deployer cannot be null");
        return this;
    }

    public DefaultRepositorySystem setLocalRepositoryProvider(LocalRepositoryProvider localRepositoryProvider) {
        this.localRepositoryProvider = Objects.requireNonNull(localRepositoryProvider, "local repository provider cannot be null");
        return this;
    }

    public DefaultRepositorySystem setSyncContextFactory(SyncContextFactory syncContextFactory) {
        this.syncContextFactory = Objects.requireNonNull(syncContextFactory, "sync context factory cannot be null");
        return this;
    }

    public DefaultRepositorySystem setRemoteRepositoryManager(RemoteRepositoryManager remoteRepositoryManager) {
        this.remoteRepositoryManager = Objects.requireNonNull(remoteRepositoryManager, "remote repository provider cannot be null");
        return this;
    }

    @Override
    public VersionResult resolveVersion(RepositorySystemSession session2, VersionRequest request) throws VersionResolutionException {
        this.validateSession(session2);
        return this.versionResolver.resolveVersion(session2, request);
    }

    @Override
    public VersionRangeResult resolveVersionRange(RepositorySystemSession session2, VersionRangeRequest request) throws VersionRangeResolutionException {
        this.validateSession(session2);
        return this.versionRangeResolver.resolveVersionRange(session2, request);
    }

    @Override
    public ArtifactDescriptorResult readArtifactDescriptor(RepositorySystemSession session2, ArtifactDescriptorRequest request) throws ArtifactDescriptorException {
        this.validateSession(session2);
        return this.artifactDescriptorReader.readArtifactDescriptor(session2, request);
    }

    @Override
    public ArtifactResult resolveArtifact(RepositorySystemSession session2, ArtifactRequest request) throws ArtifactResolutionException {
        this.validateSession(session2);
        return this.artifactResolver.resolveArtifact(session2, request);
    }

    @Override
    public List<ArtifactResult> resolveArtifacts(RepositorySystemSession session2, Collection<? extends ArtifactRequest> requests) throws ArtifactResolutionException {
        this.validateSession(session2);
        return this.artifactResolver.resolveArtifacts(session2, requests);
    }

    @Override
    public List<MetadataResult> resolveMetadata(RepositorySystemSession session2, Collection<? extends MetadataRequest> requests) {
        this.validateSession(session2);
        return this.metadataResolver.resolveMetadata(session2, requests);
    }

    @Override
    public CollectResult collectDependencies(RepositorySystemSession session2, CollectRequest request) throws DependencyCollectionException {
        this.validateSession(session2);
        return this.dependencyCollector.collectDependencies(session2, request);
    }

    @Override
    public DependencyResult resolveDependencies(RepositorySystemSession session2, DependencyRequest request) throws DependencyResolutionException {
        List<ArtifactResult> results;
        this.validateSession(session2);
        RequestTrace trace2 = RequestTrace.newChild(request.getTrace(), request);
        DependencyResult result = new DependencyResult(request);
        DependencyCollectionException dce = null;
        ArtifactResolutionException are2 = null;
        if (request.getRoot() != null) {
            result.setRoot(request.getRoot());
        } else if (request.getCollectRequest() != null) {
            CollectResult collectResult;
            try {
                request.getCollectRequest().setTrace(trace2);
                collectResult = this.dependencyCollector.collectDependencies(session2, request.getCollectRequest());
            }
            catch (DependencyCollectionException e2) {
                dce = e2;
                collectResult = e2.getResult();
            }
            result.setRoot(collectResult.getRoot());
            result.setCycles(collectResult.getCycles());
            result.setCollectExceptions(collectResult.getExceptions());
        } else {
            throw new NullPointerException("dependency node and collect request cannot be null");
        }
        ArtifactRequestBuilder builder = new ArtifactRequestBuilder(trace2);
        DependencyFilter filter2 = request.getFilter();
        DependencyVisitor visitor = filter2 != null ? new FilteringDependencyVisitor(builder, filter2) : builder;
        visitor = new TreeDependencyVisitor(visitor);
        if (result.getRoot() != null) {
            result.getRoot().accept(visitor);
        }
        List<ArtifactRequest> requests = builder.getRequests();
        try {
            results = this.artifactResolver.resolveArtifacts(session2, requests);
        }
        catch (ArtifactResolutionException e3) {
            are2 = e3;
            results = e3.getResults();
        }
        result.setArtifactResults(results);
        this.updateNodesWithResolvedArtifacts(results);
        if (dce != null) {
            throw new DependencyResolutionException(result, (Throwable)dce);
        }
        if (are2 != null) {
            throw new DependencyResolutionException(result, (Throwable)are2);
        }
        return result;
    }

    private void updateNodesWithResolvedArtifacts(List<ArtifactResult> results) {
        for (ArtifactResult result : results) {
            Artifact artifact = result.getArtifact();
            if (artifact == null) continue;
            result.getRequest().getDependencyNode().setArtifact(artifact);
        }
    }

    @Override
    public InstallResult install(RepositorySystemSession session2, InstallRequest request) throws InstallationException {
        this.validateSession(session2);
        return this.installer.install(session2, request);
    }

    @Override
    public DeployResult deploy(RepositorySystemSession session2, DeployRequest request) throws DeploymentException {
        this.validateSession(session2);
        return this.deployer.deploy(session2, request);
    }

    @Override
    public LocalRepositoryManager newLocalRepositoryManager(RepositorySystemSession session2, LocalRepository localRepository) {
        try {
            return this.localRepositoryProvider.newLocalRepositoryManager(session2, localRepository);
        }
        catch (NoLocalRepositoryManagerException e2) {
            throw new IllegalArgumentException(e2.getMessage(), e2);
        }
    }

    @Override
    public SyncContext newSyncContext(RepositorySystemSession session2, boolean shared2) {
        this.validateSession(session2);
        return this.syncContextFactory.newInstance(session2, shared2);
    }

    @Override
    public List<RemoteRepository> newResolutionRepositories(RepositorySystemSession session2, List<RemoteRepository> repositories) {
        this.validateSession(session2);
        repositories = this.remoteRepositoryManager.aggregateRepositories(session2, new ArrayList<RemoteRepository>(), repositories, true);
        return repositories;
    }

    @Override
    public RemoteRepository newDeploymentRepository(RepositorySystemSession session2, RemoteRepository repository) {
        this.validateSession(session2);
        RemoteRepository.Builder builder = new RemoteRepository.Builder(repository);
        Authentication auth = session2.getAuthenticationSelector().getAuthentication(repository);
        builder.setAuthentication(auth);
        Proxy proxy2 = session2.getProxySelector().getProxy(repository);
        builder.setProxy(proxy2);
        return builder.build();
    }

    private void validateSession(RepositorySystemSession session2) {
        Objects.requireNonNull(session2, "repository system session cannot be null");
        this.invalidSession(session2.getLocalRepositoryManager(), "local repository manager");
        this.invalidSession(session2.getSystemProperties(), "system properties");
        this.invalidSession(session2.getUserProperties(), "user properties");
        this.invalidSession(session2.getConfigProperties(), "config properties");
        this.invalidSession(session2.getMirrorSelector(), "mirror selector");
        this.invalidSession(session2.getProxySelector(), "proxy selector");
        this.invalidSession(session2.getAuthenticationSelector(), "authentication selector");
        this.invalidSession(session2.getArtifactTypeRegistry(), "artifact type registry");
        this.invalidSession(session2.getData(), "data");
    }

    private void invalidSession(Object obj, String name2) {
        Objects.requireNonNull(obj, "repository system session's " + name2 + " cannot be null");
    }
}

