/*
* gravity.cc
* DIN Is Noise is copyright (c) 2006-2022 Jagannathan Sampath
* DIN Is Noise is released under GNU Public License 2.0
* For more information, please visit https://dinisnoise.org/
*/

#include "gravity.h"
#include "font.h"
#include "vector2d.h"
#include "drone.h"
#include "console.h"
#include "din.h"

#include <fstream>

using namespace std;

#define NUDGEUP(W) W.set_pos (W.extents.left, W.extents.bottom + 3);

gravity_t::gravity_t () {

  pguil = &guil;
  mouse_slider_listener::name = "Gravity";
  handlesize = 4;
  strength = 0;
  hitt = NOTHING;
  lmb_clicked = 0;
  tracked_drone = 0;
  restormod = 0;
	mag0 = 50;
  mag = 0;
	keep_size = 0;

  label* w [] = {&zero, &reset, &keepsize, &mouse, &dron, &changesize, &mod.yes, &mod.edit, &lbl, &dronsize, &toscrcent, &tocenter, &todrone};
  const char* txt [] = {"0", "Reset", "Keep size", "Mouse", "Drone", "Change size", "Modulate", "Edit", "Gravity", "Size", "To Screen + ", "To Drones + ", "To drone"};
  for (int i = 0; i < 13; ++i) w[i]->set_text (txt[i]);

  arrow_button* ab [] = {&left, &right, &up, &down};
  int dirr [] = {arrow_button::left, arrow_button::right, arrow_button::up, arrow_button::down};
  for (int i = 0, j = 1; i < 4; ++i, ++j) {
    arrow_button* abi = ab[i];
    abi->id = j;
    abi->set_dir (dirr[i]);
    abi->set_listener(this);
  }

  LISTEN(fold,this)
  LISTEN(zero,this)
  LISTEN(reset,this)
  LISTEN(toscrcent, &scrcenl)
  LISTEN(tocenter, &cenl)
  LISTEN(todrone, &drol)
  LISTEN(changesize,this)
  LISTEN(mouse,&ml)

  mod.depth.set ("Depth", 0.1f, 0.0f, 1.0f, &mod.dl, 0);
  mod.bpm.set ("BPM", 1, 0, MILLIONF, &mod.bl, 0);

#ifdef __WIDGET_MOVE__
  {
    widget* w[] = {&mod.yes, &mod.depth, &mod.bpm, &mod.edit, 0};
    for (widget** p = w; *p != 0; ++p) (*p)->set_moveable(1);
    makehier (w);
  }
#endif

}

int gravity_t::handle_input () {
  HANDLEINPUT(fold)
  else HANDLEINPUT(lbl)
  else if (fold.dir == arrow_button::down) {
    widget* w [] = {&zero, &reset, &left, &right, &up, &down, &keepsize, &dronsize, &mouse, &dron, &changesize, &mod.yes, &mod.depth, &mod.bpm, &mod.edit, &toscrcent, &tocenter, &todrone, 0};
    for (widget** p = w; *p != 0; ++p) if ((*p)->handle_input ()) break; 
  }
  return 1;
}

int gravity_t::handle_input2 () {

	if (is_lmb (this)) {
		if (lmb_clicked == 0) {
			lmb_clicked = 1;
			if (hitt != NOTHING) {
				hitt = NEXT_TO_NOTHING;
			} else {
				if (hit (tip, din0.win_mousex, din0.win_mousey)) {
					hitt = TIP; // edit tip
					is_lmb.tie = this;
				} else 
				if (hit (base, din0.win_mousex, din0.win_mousey)) {
					hitt = BASE; // edit base
					is_lmb.tie = this;
				}
			}
		}
	} else {
		if (hitt == NOTHING) {
    }
    else 
		if (hitt == NEXT_TO_NOTHING) {
			stop_editing ();
		} else if (hitt == TIP) { // update tip
			set (tip, din0.win_mousex, din0.win_mousey);
		} else if (hitt == BASE) { // update base
			set (tip, din0.win_mousex + base2tip.x, din0.win_mousey + base2tip.y, 0);
			set (base, din0.win_mousex, din0.win_mousey, 0);
      calcui ();
		} 
		lmb_clicked = 0;
	}

  return hitt;
}

void gravity_t::draw () {
  fold.draw ();
  lbl.draw ();
  if (fold.dir == arrow_button::down) {
    widget* w [] = {&zero, &reset, &left, &right, &up, &down, &keepsize, &dronsize, &mouse, &dron, &changesize, &mod.yes, &mod.depth, &mod.bpm, &mod.edit, &toscrcent, &tocenter, &todrone, 0};
    for (widget** p = w; *p != 0; ++p) (*p)->draw (); 
  }
}

void gravity_t::drawrrow () {
  glColor3f (1, 0.6, 0.5);
  glVertexPointer (2, GL_INT, 0, gl_base);
  glDrawArrays (GL_LINE_LOOP, 0, 4);
  glVertexPointer (2, GL_FLOAT, 0, gl_arrow);
  glDrawArrays (GL_LINES, 0, 6);
}

void gravity_t::calcbase2tip () {
  direction (base2tip, base, tip);
  perpendicular (p_base2tip, base2tip);
  gx = strength * base2tip.x; gy = strength * base2tip.y;
}

void gravity_t::calcvisual () {
  bottomleft (base.x - handlesize, base.y - handlesize);
  topright (base.x + handlesize, base.y + handlesize);
  gl_base[0]=bottomleft.x; gl_base[1]=bottomleft.y;
  gl_base[2]=topright.x; gl_base[3]=gl_base[1];
  gl_base[4]=gl_base[2];gl_base[5]=topright.y;
  gl_base[6]=gl_base[0];gl_base[7]=gl_base[5];
  int cap = 0;
  int da = 0;
  make_arrow (gl_arrow, 0, cap, da, base.x, base.y, base2tip.x, base2tip.y, p_base2tip.x, p_base2tip.y, 0.6f, 0.2f);
}

void gravity_t::calc (int calc_mag) {
  calcbase2tip ();
  calcvisual ();
  if (calc_mag) mag = magnitude (base2tip);
}

void gravity_t::calcui () {

  win2view (base.x, base.y, textpos.x, textpos.y, din0.win, view);

  static const int ds = 10, ds2 = ds / 2;

  textpos.x += ds;

  fold.set_pos (textpos.x, textpos.y - ds2);
  lbl.set_pos (fold.extents.right + ds, fold.extents.bottom);

  int xx = textpos.x, yy = fold.extents.bottom - line_height;

  button* bt [] = {&zero, &left, &right, &up, &down, &mouse, &dron, &dronsize, 0};
  for (button** p = bt; *p != 0; ++p) {
    button* bti = *p;
    bti->set_pos (xx, yy);
    xx = bti->extents.right + ds;
  }

  {
    widget* w[] = {&left, &right, &up, &down, 0};
    for (widget** p = w; *p != 0; ++p) {
      widget& wp = **p;
      NUDGEUP (wp);
    }
  }

  yy -= line_height;
  reset.set_pos (textpos.x, yy);
  keepsize.set_pos (reset.extents.right + ds, yy);
  {
    widget* w[] = {&changesize, &mod.yes, &mod.depth, &mod.bpm, &mod.edit, 0};
    int  lh = line_height;
    for (widget** p = w; *p != 0; ++p) {
      widget& pi = **p;
      pi.set_pos (textpos.x, yy -= lh);
    }
  }

  toscrcent.set_pos (textpos.x, yy -= line_height);
  tocenter.set_pos (toscrcent.extents.right + ds, yy);
  todrone.set_pos (tocenter.extents.right + ds, yy); 

  ldwx = ldwy = -1;
}

void gravity_t::set (point<float>& what, float mx, float my, int calc_mag) {
  what.x = mx;
  what.y = my;
  calc (calc_mag);
}

void gravity_t::move (float tox, float toy) {
  base.x = tox;
  base.y = toy;
  tip.x = tox + base2tip.x;
  tip.y = toy + base2tip.y;
  calcvisual ();
}

int gravity_t::hit (const point<float>& what, float mx, float my) {
  double m = magnitude (what.x, what.y, mx, my);
  return !(m > handlesize);
}

void gravity_t::load (ifstream& file) {
	string ignore;
  float bx, by, tx, ty; 
  file >> ignore >> bx >> by >> tx >> ty;
  set (base, bx, by);
  set (tip, tx, ty);
	file >> strength >> visible >> keep_size >> maos >> dronn >> modyes >> mod.params.depth >> mod.params.bv.bpm >> modparin >> dronsz;
}

void gravity_t::save (ofstream& file) {
  file << "gravity " << base.x << spc << base.y << spc << tip.x << spc << tip.y << spc << strength << spc << visible << spc << keep_size << spc << mouse.state << spc << dron.state << spc << mod.yes.state << spc << mod.params.depth << spc << mod.params.bv.bpm << spc << mod.params.initial << spc << dronsize.state << endl;
  mod.crv.save ("gravmod.crv");
}

void gravity_t::doreset (int ks) {
	keep_size = ks;
  if (!keep_size) mag = mag0;
  preset (down.id);
}

void gravity_t::preset (int id) {

	if (!mod.yes.state) {
		if (!id) {
			mag = 0; 
		} else {
			if (mag == 0) {
				mag = mag0;
			}	
		}
	}
  float xx [] = {base.x, float (base.x - mag), float(base.x + mag), base.x, base.x};
  float yy [] = {base.y, base.y, base.y, float(base.y + mag), float(base.y - mag)};
  tip.x = xx [id]; 
  tip.y = yy [id];
  calc (0);
  unit_vector<double> (btux, btuy, base2tip.x, base2tip.y);
}

void gravity_t::track (float vx, float vy) {
  double magg = unit_vector (btux, btuy, base.x, base.y, vx, vy);
  if (dronsize.state) mag = magg;
  vx = base.x + mag * btux; 
  vy = base.y + mag * btuy; 
  set (tip, vx, vy, 0);
}

int gravity_t::stop_editing () {
	if (hitt != NOTHING) {
		hitt = NOTHING;
		is_lmb.clear (this);
		return 1;
	}
	return 0;
}

void gravity_t::clicked (button& b) {
  if (&b == &fold) {
    if (fold.dir == arrow_button::right) {
      fold.set_dir(arrow_button::down);
    } else {
      fold.set_dir(arrow_button::right);
    }
  } else {
    if (&b == &reset) {
      doreset (keepsize.state);
    } else if (&b == &changesize) {
      if (mod.yes.state) {
        mod.yes.turn_off ();
        restormod = 1;
      }
      unit_vector<double> (btux, btuy, base2tip.x, base2tip.y);
      mouse_slider0.add (this);
      activate_mouse_slider ();
    } else {
      preset (b.id);
    }
  }
}

void gravity_t::moused (int dir, double scl) {
  mag += (sign(dir) * scl);
  updmag (mag);
  cons << GREEN << "Gravity size = " << mag << eol;
}

void gravity_t::after_slide () {
  if (restormod) {
    mod.yes.turn_on ();
    restormod = 0;
  }
}

void gravity_t::updmag (double m) {
  mag = m;
  if (mag < 0) mag = 0;
  tip.x = base.x + mag * btux;
  tip.y = base.y + mag * btuy;
  #define DONTCALCMAG 0
  calc (DONTCALCMAG);
}

int gravity_t::unfolded () {return fold.dir == arrow_button::down;}

CLICKED_CHECKBUTTON (gravity_t, mousel) {
  if (cb.state) din0.dinfo.gravity.track (din0.win_mousex, din0.win_mousey);
}

void gravity_t::modulate () {
  if (mod.yes.state) updmag (mod.eval());
}

float gravity_t::modulatet::eval () {
  double now = ui_clk ();
  double dt = now - t;
  params.calc (dt);
  t = now;
  return ((1 + params.result) * params.initial); 
}


CLICKED_BUTTON (gravity_t::modulatet, editl) {
  uis.load_editor (&din0.dinfo.gravity.mod.ed);
}

VALUE_CHANGED (gravity_t::modulatet, depthl) {
  gravity_t& gravity = din0.dinfo.gravity;
  mod_params& params = din0.dinfo.gravity.mod.params;
  params.depth = gravity.mod.depth();
}

VALUE_CHANGED (gravity_t::modulatet, bpml) {
  gravity_t& gravity = din0.dinfo.gravity;
  mod_params& params = din0.dinfo.gravity.mod.params;
  params.bv.set_bpm (gravity.mod.bpm());
}

void gravity_t::modulatet::curvel::edited (curve_editor* e, int i) {
  beat2value& bv = din0.dinfo.gravity.mod.params.bv;
  bv.sol (bv.crv);
}

void gravity_t::initui () {
  mouse.set_state (maos);
  dron.set_state (dronn);
  dronsize.set_state (dronsz);
  mod.depth.set_value (mod.params.depth);
  mod.bpm.set_value (mod.params.bv.bpm);
  mod.yes.set_state (modyes);
  mod.params.initial = modparin;
  calcui ();
}

void gravlis::released () {
  din0.dinfo.gravity.calcui ();
}

#define DONTCALCMAG 0

CLICKED_BUTTON (gravity_t, toscrcenl) {
  din_info& di = din0.dinfo;
  gravity_t& g = di.gravity;
  float wx, wy;
  view2win (view.midx, view.midy, wx, wy, view, din0.win);
  g.move (wx, wy);
}

CLICKED_BUTTON (gravity_t, tocenl) {
  din_info& di = din0.dinfo;
  gravity_t& g = di.gravity;
  din_info::cent& cen = di.cen;
  g.move (cen.x, cen.y);
}

CLICKED_BUTTON (gravity_t, todrol) {
  if (din0.num_selected_drones) {
    drone* pd = din0.selected_drones[0];
    din_info& di = din0.dinfo;
    gravity_t& g = di.gravity;
    g.move (pd->sx, pd->y);
  } else cons << RED_PSD << eol;
}
