/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.dialog;

import java.awt.Component;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.dialog.OptionsDialog;
import net.sf.freecol.client.gui.panel.FreeColButton;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.io.FreeColDirectories;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.option.OptionGroup;

public final class DifficultyDialog
extends OptionsDialog
implements TreeSelectionListener {
    private static final Logger logger = Logger.getLogger(DifficultyDialog.class.getName());
    private OptionGroup selected;
    private final Specification specification;

    public DifficultyDialog(FreeColClient freeColClient, JFrame frame, Specification specification, OptionGroup level, boolean editable) {
        super(freeColClient, frame, editable, level, "difficultyDialog", "custom.xml", "model.difficulty.custom");
        this.specification = specification;
        this.selected = level;
        this.getOptionUI().getTree().addTreeSelectionListener(this);
        if (this.isEditable()) {
            FreeColButton resetButton = Utility.localizedButton("reset");
            this.addResetAction(resetButton);
            FreeColButton loadButton = Utility.localizedButton("load");
            this.addLoadAction(loadButton);
            FreeColButton saveButton = Utility.localizedButton("save");
            this.addSaveAction(saveButton);
            this.panel.add((Component)resetButton, "span, split 3");
            this.panel.add(loadButton);
            this.panel.add(saveButton);
        }
        this.initialize(frame, DifficultyDialog.choices());
    }

    @Override
    public Specification getSpecification() {
        return this.specification;
    }

    private void addResetAction(JButton button) {
        button.addActionListener(ae -> this.getOptionUI().reset());
    }

    private void addLoadAction(JButton button) {
        button.addActionListener(ae -> {
            File dir = FreeColDirectories.getOptionsDirectory();
            File file = this.getGUI().showLoadDialog(dir, "xml");
            if (file != null && !this.load(file)) {
                Object err = StringTemplate.template("error.couldNotLoadDifficulty").addName("%name%", file.getPath());
                this.getGUI().showErrorPanel((StringTemplate)err);
            }
        });
    }

    private void addSaveAction(JButton button) {
        button.addActionListener(ae -> {
            File dir = FreeColDirectories.getOptionsDirectory();
            File file = this.getGUI().showSaveDialog(dir, this.getDefaultFileName());
            if (file != null) {
                this.getOptionUI().updateOption();
                this.save(file);
            }
        });
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
        TreePath path = event.getPath();
        if (path.getPathCount() >= 2) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getPathComponent(1);
            this.selected = (OptionGroup)node.getUserObject();
        }
    }

    @Override
    public OptionGroup getResponse() {
        OptionGroup value = super.getResponse();
        return value == null ? null : this.getGroup();
    }
}

