/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.dialog;

import java.awt.Component;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.dialog.OptionsDialog;
import net.sf.freecol.client.gui.option.BooleanOptionUI;
import net.sf.freecol.client.gui.option.FileOptionUI;
import net.sf.freecol.client.gui.option.OptionGroupUI;
import net.sf.freecol.client.gui.option.OptionUI;
import net.sf.freecol.client.gui.panel.FreeColButton;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColDirectories;
import net.sf.freecol.common.io.FreeColSavegameFile;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.option.BooleanOption;
import net.sf.freecol.common.option.FileOption;
import net.sf.freecol.common.option.OptionGroup;

public final class MapGeneratorOptionsDialog
extends OptionsDialog {
    private static final Logger logger = Logger.getLogger(MapGeneratorOptionsDialog.class.getName());

    public MapGeneratorOptionsDialog(FreeColClient freeColClient, JFrame frame, boolean editable) {
        super(freeColClient, frame, editable, freeColClient.getGame().getMapGeneratorOptions(), "mapGeneratorOptions", "map_generator_options.xml", "mapGeneratorOptions");
        if (this.isEditable()) {
            this.loadDefaultOptions();
            List<File> mapFiles = FreeColDirectories.getMapFileList();
            JPanel mapPanel = new JPanel(new MigLayout("wrap 4, fill"));
            FreeColButton randomMap = new FreeColButton(Messages.message("mapGeneratorOptions.landGenerator.name"));
            randomMap.addActionListener(ae -> this.updateFile(null));
            mapPanel.add((Component)randomMap, "sizegroup button, grow");
            for (File f : mapFiles) {
                JButton mapButton = this.makeMapButton(f);
                if (mapButton == null) continue;
                mapButton.addActionListener(ae -> this.updateFile(f));
                mapPanel.add((Component)mapButton, "sizegroup button, grow");
            }
            JScrollPane scrollPane = new JScrollPane(mapPanel);
            scrollPane.getViewport().setOpaque(false);
            this.panel.add((Component)scrollPane, "height 80%, width 100%");
        }
        this.initialize(frame, MapGeneratorOptionsDialog.choices());
    }

    private void updateFile(File file) {
        OptionGroup mgo = this.getGroup();
        OptionGroupUI mgoUI = this.getOptionUI();
        GUI gui = this.freeColClient.getGUI();
        FileOptionUI foui = (FileOptionUI)mgoUI.getOptionUI("model.option.importFile");
        if (foui == null) {
            FileOption op = mgo.getOption("model.option.importFile", FileOption.class);
            foui = (FileOptionUI)OptionUI.getOptionUI(gui, op, true);
        }
        foui.setValue(file);
        BooleanOptionUI terrainUI = (BooleanOptionUI)mgoUI.getOptionUI("model.option.importTerrain");
        if (terrainUI == null) {
            BooleanOption op = mgo.getOption("model.option.importTerrain", BooleanOption.class);
            terrainUI = (BooleanOptionUI)OptionUI.getOptionUI(gui, op, true);
        }
        terrainUI.setValue(true);
        BooleanOptionUI bonusesUI = (BooleanOptionUI)mgoUI.getOptionUI("model.option.importBonuses");
        if (bonusesUI == null) {
            BooleanOption op = mgo.getOption("model.option.importBonuses", BooleanOption.class);
            bonusesUI = (BooleanOptionUI)OptionUI.getOptionUI(gui, op, true);
        }
        bonusesUI.setValue(false);
        BooleanOptionUI rumourUI = (BooleanOptionUI)mgoUI.getOptionUI("model.option.importRumours");
        if (rumourUI == null) {
            BooleanOption op = mgo.getOption("model.option.importRumours", BooleanOption.class);
            rumourUI = (BooleanOptionUI)OptionUI.getOptionUI(gui, op, true);
        }
        rumourUI.setValue(false);
        BooleanOptionUI settUI = (BooleanOptionUI)mgoUI.getOptionUI("model.option.importSettlements");
        if (settUI == null) {
            BooleanOption op = mgo.getOption("model.option.importSettlements", BooleanOption.class);
            settUI = (BooleanOptionUI)OptionUI.getOptionUI(gui, op, true);
        }
        settUI.setValue(false);
        if (file == null) {
            mgoUI.selectOption("mapGeneratorOptions.landGenerator");
        } else {
            mgoUI.selectOption("mapGeneratorOptions.import");
        }
    }

    private JButton makeMapButton(File file) {
        BufferedImage thumbnail;
        FreeColSavegameFile savegame;
        String mapName = file.getName();
        mapName = mapName.substring(0, mapName.lastIndexOf(46));
        FreeColButton mapButton = null;
        try {
            savegame = new FreeColSavegameFile(file);
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, "Failed to make save game for: " + mapName, ioe);
            return null;
        }
        try {
            thumbnail = ImageIO.read(savegame.getThumbnailInputStream());
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, "Failed to read thumbnail for: " + mapName, ioe);
            thumbnail = null;
        }
        if (thumbnail != null) {
            mapButton = new FreeColButton(Messages.message("freecol.map." + mapName));
            mapButton.setIcon(new ImageIcon(thumbnail));
            mapButton.setHorizontalTextPosition(0);
            mapButton.setVerticalTextPosition(3);
            try {
                Properties properties = savegame.getProperties();
                mapButton.setToolTipText(properties.getProperty("map.width") + "\u00d7" + properties.getProperty("map.height"));
            }
            catch (IOException ioe) {
                logger.log(Level.WARNING, "Failed to read properties for: " + mapName, ioe);
            }
        }
        return mapButton;
    }

    @Override
    protected boolean save(File file) {
        String EDGE = "model.option.maximumDistanceToEdge";
        boolean ok = false;
        try {
            int edge = this.getGroup().getInteger("model.option.maximumDistanceToEdge");
            int width = this.getGroup().getInteger("model.option.mapWidth");
            if (width < 4 * edge) {
                this.getGUI().showErrorPanel((StringTemplate)((StringTemplate)StringTemplate.template("mapGeneratorOptionsDialog.badWidth").addAmount("%width%", width)).addAmount("%edge%", edge));
                this.getGroup().setInteger("model.option.maximumDistanceToEdge", this.getGroup().getIntegerMinimum("model.option.maximumDistanceToEdge"));
                return false;
            }
            ok = true;
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Options in disarray", ex);
        }
        if (!ok) {
            this.getGUI().showErrorPanel(FreeCol.badFile("error.couldNotSave", file));
            return false;
        }
        return super.save(file);
    }

    @Override
    public OptionGroup getResponse() {
        OptionGroup value = super.getResponse();
        if (value != null && this.isEditable()) {
            this.saveDefaultOptions();
        }
        return value;
    }
}

