/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.InGameController;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.FreeColButton;
import net.sf.freecol.client.gui.panel.FreeColImageBorder;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;

public abstract class FreeColPanel
extends MigPanel
implements ActionListener {
    private static final Logger logger = Logger.getLogger(FreeColPanel.class.getName());
    protected static final String CANCEL = "CANCEL";
    protected static final String OK = "OK";
    protected static final String HELP = "HELP";
    protected static final String SPAN_SPLIT_2 = "span, split 2";
    protected static final String NL_SPAN_SPLIT_2 = "newline, span, split 2";
    protected static final int MARGIN = 3;
    private final FreeColClient freeColClient;
    protected boolean editable = true;
    protected JButton okButton = Utility.localizedButton("ok").withButtonStyle(FreeColButton.ButtonStyle.IMPORTANT);

    protected FreeColPanel(FreeColClient freeColClient) {
        this(freeColClient, null, new FlowLayout());
    }

    protected FreeColPanel(FreeColClient freeColClient, String uiClassId, LayoutManager layout) {
        super(uiClassId, layout);
        this.freeColClient = freeColClient;
        this.setBorder(FreeColImageBorder.panelBorder);
        this.okButton.setActionCommand(OK);
        this.okButton.addActionListener(this);
        this.setCancelComponent(this.okButton);
    }

    protected final FreeColClient getFreeColClient() {
        return this.freeColClient;
    }

    protected final boolean isEditable() {
        return this.editable;
    }

    protected final Game getGame() {
        return this.freeColClient.getGame();
    }

    protected final Map getMap() {
        Game game = this.getGame();
        return game == null ? null : game.getMap();
    }

    protected final GUI getGUI() {
        return this.freeColClient.getGUI();
    }

    protected final ImageLibrary getImageLibrary() {
        return this.getGUI().getFixedImageLibrary();
    }

    protected Specification getSpecification() {
        return this.freeColClient.getGame().getSpecification();
    }

    protected final Player getMyPlayer() {
        return this.freeColClient.getMyPlayer();
    }

    protected final ClientOptions getClientOptions() {
        return this.freeColClient == null ? null : this.freeColClient.getClientOptions();
    }

    public final InGameController igc() {
        return this.freeColClient.getInGameController();
    }

    public JButton createColonyButton(Colony colony) {
        JButton button = Utility.getLinkButton(colony.getName(), null, colony.getId());
        button.addActionListener(this);
        return button;
    }

    public final void setCancelComponent(AbstractButton cancelButton) {
        if (cancelButton == null) {
            throw new NullPointerException();
        }
        InputMap inputMap = this.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(27, 0, true), "release");
        Action cancelAction = cancelButton.getAction();
        this.getActionMap().put("release", cancelAction);
    }

    public FreeColPanel addClosingCallback(final Runnable runnable) {
        if (runnable != null) {
            this.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if ("closing".equals(e.getPropertyName())) {
                        runnable.run();
                        FreeColPanel.this.removePropertyChangeListener(this);
                    }
                }
            });
        }
        return this;
    }

    public BufferedImage getSmallAbstractUnitImage(AbstractUnit au) {
        Specification spec = this.getSpecification();
        return this.getImageLibrary().getSmallUnitTypeImage(au.getType(spec), au.getRoleId(), false);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (OK.equals(command)) {
            this.getGUI().removeComponent(this);
        } else {
            logger.warning("Bad event: " + command);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.okButton == null) {
            return;
        }
        this.setLayout(null);
        this.okButton.removeActionListener(this);
        this.okButton = null;
        for (MouseListener listener : this.getMouseListeners()) {
            this.removeMouseListener(listener);
        }
    }

    @Override
    public void requestFocus() {
        if (this.okButton != null) {
            this.okButton.requestFocus();
        }
    }
}

