/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.tools;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import net.sf.freecol.common.util.ImageUtils;

public class Texture2Tile {
    private static final int RESULT_WIDTH = 512;
    private static final int RESULT_HEIGHT = 256;

    public static void main(String[] args) throws Exception {
        File inputImageFile = new File(args[0]);
        File resultImagefile = new File("generated.png");
        BufferedImage inputImage = ImageIO.read(inputImageFile);
        int quarterTileWidth = 256;
        int quarterTileHeight = 128;
        inputImage = Texture2Tile.seamlessRescaleTextureIfNeeded(inputImage, 256, 128);
        BufferedImage imageA = Texture2Tile.extractQuarterTileA(inputImage, 256, 128);
        BufferedImage imageB = Texture2Tile.extractQuarterTileB(inputImage, 256, 128);
        BufferedImage resultImage = Texture2Tile.combineQuarterTiles(imageA, imageB);
        ImageIO.write((RenderedImage)resultImage, "png", resultImagefile);
        System.out.println("Image written to: " + resultImagefile.getAbsolutePath().toString());
    }

    private static BufferedImage seamlessRescaleTextureIfNeeded(BufferedImage inputImage, int quarterTileWidth, int quarterTileHeight) {
        if (inputImage.getWidth() == quarterTileWidth && inputImage.getHeight() == quarterTileHeight) {
            return inputImage;
        }
        if (Texture2Tile.closerToCorrectAspectWithoutDoublingHorizontally(inputImage)) {
            return Texture2Tile.seamlessRescaleTexture(inputImage, quarterTileWidth, quarterTileHeight);
        }
        BufferedImage tempImage = Texture2Tile.createImageWithTextureFill(inputImage, inputImage.getWidth() * 2, inputImage.getHeight());
        if (tempImage.getWidth() == quarterTileWidth && tempImage.getHeight() == quarterTileHeight) {
            return tempImage;
        }
        return Texture2Tile.seamlessRescaleTexture(tempImage, quarterTileWidth, quarterTileHeight);
    }

    private static boolean closerToCorrectAspectWithoutDoublingHorizontally(BufferedImage inputImage) {
        return Math.abs(1 - 2 * inputImage.getHeight() / inputImage.getWidth()) <= Math.abs(1 - inputImage.getHeight() / inputImage.getWidth());
    }

    private static BufferedImage combineQuarterTiles(BufferedImage imageA, BufferedImage imageB) {
        int quarterTileWidth = imageA.getWidth();
        int quarterTileHeight = imageA.getHeight();
        int resultWidth = quarterTileWidth * 2;
        int resultHeight = quarterTileHeight * 2;
        BufferedImage resultImage = new BufferedImage(resultWidth, resultHeight, 2);
        Graphics2D gResult = resultImage.createGraphics();
        int centerHorizontally = resultWidth / 2 - quarterTileWidth / 2;
        gResult.drawImage((Image)imageA, centerHorizontally, 0, null);
        gResult.drawImage((Image)imageA, centerHorizontally, resultHeight - quarterTileHeight, null);
        int centerVertically = resultHeight / 2 - quarterTileHeight / 2;
        gResult.drawImage((Image)imageB, resultWidth / 4 - quarterTileWidth / 2, centerVertically, null);
        gResult.drawImage((Image)imageB, 3 * resultWidth / 4 - quarterTileWidth / 2, centerVertically, null);
        gResult.dispose();
        return resultImage;
    }

    private static BufferedImage seamlessRescaleTexture(BufferedImage im, int width, int height) {
        BufferedImage tempImage = Texture2Tile.createImageWithTextureFill(im, im.getWidth() * 3, im.getHeight() * 3);
        BufferedImage tempImage2 = ImageUtils.createResizedImage(tempImage, width * 3, height * 3, true);
        return tempImage2.getSubimage(width, height, width, height);
    }

    private static BufferedImage createImageWithTextureFill(BufferedImage im, int width, int height) {
        BufferedImage resultImage = new BufferedImage(width, height, 2);
        Graphics2D g = resultImage.createGraphics();
        ImageUtils.fillTexture(g, im, 0, 0, resultImage.getWidth(), resultImage.getHeight());
        g.dispose();
        return resultImage;
    }

    private static BufferedImage extractQuarterTileA(BufferedImage inputImage, int quarterTileWidth, int quarterTileHeight) throws Exception {
        BufferedImage imN = Texture2Tile.imageWithMaskApplied(inputImage, "n");
        BufferedImage imS = Texture2Tile.imageWithMaskApplied(inputImage, "s");
        BufferedImage imageA = new BufferedImage(quarterTileWidth, quarterTileHeight, 2);
        Graphics2D gA = imageA.createGraphics();
        gA.drawImage((Image)imS.getSubimage(0, quarterTileHeight / 2, quarterTileWidth, quarterTileHeight / 2), 0, 0, null);
        gA.drawImage((Image)imN.getSubimage(0, 0, quarterTileWidth, quarterTileHeight / 2), 0, quarterTileHeight / 2, null);
        gA.dispose();
        return imageA;
    }

    private static BufferedImage extractQuarterTileB(BufferedImage inputImage, int quarterTileWidth, int quarterTileHeight) throws Exception {
        BufferedImage imE = Texture2Tile.imageWithMaskApplied(inputImage, "e");
        BufferedImage imW = Texture2Tile.imageWithMaskApplied(inputImage, "w");
        BufferedImage imageB = new BufferedImage(quarterTileWidth, quarterTileHeight, 2);
        Graphics2D gB = imageB.createGraphics();
        gB.drawImage((Image)imE.getSubimage(quarterTileWidth / 2, 0, quarterTileWidth / 2, quarterTileHeight), 0, 0, null);
        gB.drawImage((Image)imW.getSubimage(0, 0, quarterTileWidth / 2, quarterTileHeight), quarterTileWidth / 2, 0, null);
        gB.dispose();
        return imageB;
    }

    private static BufferedImage imageWithMaskApplied(BufferedImage image, String variation) throws Exception {
        String maskBaseName = "data/base/resources/images/masks/tools/mask-256x128-texture-";
        BufferedImage mask = ImageIO.read(new File("data/base/resources/images/masks/tools/mask-256x128-texture-" + variation + ".png"));
        return ImageUtils.imageWithAlphaFromMask(image, mask);
    }
}

