/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.banner.workspace;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.Workspace;
import org.gephi.project.api.WorkspaceInformation;
import org.gephi.project.api.WorkspaceListener;
import org.gephi.project.api.WorkspaceProvider;
import org.netbeans.swing.tabcontrol.DefaultTabDataModel;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDataModel;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.TabbedContainer;
import org.netbeans.swing.tabcontrol.WinsysInfoForTabbedContainer;
import org.netbeans.swing.tabcontrol.event.TabActionEvent;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class WorkspacePanel
extends JPanel
implements WorkspaceListener,
PropertyChangeListener {
    private final transient DefaultTabDataModel tabDataModel;
    private final transient TabbedContainer tabbedContainer;
    private final Icon workspaceIcon;

    public WorkspacePanel() {
        this.initComponents();
        this.workspaceIcon = ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"org/gephi/desktop/banner/workspace/resources/workspace.png"));
        this.tabDataModel = new DefaultTabDataModel();
        WinsysInfoForTabbedContainer ws = new WinsysInfoForTabbedContainer(){

            public Object getOrientation(Component cmpnt) {
                return TabDisplayer.ORIENTATION_CENTER;
            }

            public boolean inMaximizedMode(Component cmpnt) {
                return false;
            }

            public boolean isTopComponentMaximizationEnabled() {
                return false;
            }
        };
        this.tabbedContainer = new TabbedContainer((TabDataModel)this.tabDataModel, 1, ws);
        this.tabbedContainer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabActionEvent tabActionEvent = (TabActionEvent)e;
                if (tabActionEvent.getActionCommand().equals("close")) {
                    String message = NbBundle.getMessage(WorkspacePanel.class, (String)"WorkspacePanel_closeWorkspace_Question");
                    String title = NbBundle.getMessage(WorkspacePanel.class, (String)"WorkspacePanel_closeWorkspace_Title");
                    NotifyDescriptor dd = new NotifyDescriptor((Object)message, title, 0, 3, null, null);
                    Object retType = DialogDisplayer.getDefault().notify(dd);
                    if (retType == NotifyDescriptor.YES_OPTION) {
                        TabData tabData = WorkspacePanel.this.tabDataModel.getTab(tabActionEvent.getTabIndex());
                        ProjectController pc = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
                        pc.deleteWorkspace(((WorkspaceComponent)tabData.getUserObject()).workspace);
                    }
                    tabActionEvent.consume();
                } else if (tabActionEvent.getActionCommand().equals("select")) {
                    TabData tabData = WorkspacePanel.this.tabDataModel.getTab(tabActionEvent.getTabIndex());
                    ProjectController pc = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
                    pc.openWorkspace(((WorkspaceComponent)tabData.getUserObject()).workspace);
                    tabActionEvent.consume();
                }
            }
        });
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                ProjectController pc = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
                pc.addWorkspaceListener((WorkspaceListener)WorkspacePanel.this);
                WorkspacePanel.this.refreshModel();
            }
        });
    }

    private synchronized void refreshModel() {
        WorkspaceProvider workspaceProvider;
        Workspace[] workspaces;
        ProjectController pc = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
        if (pc.getCurrentProject() != null && (workspaces = (workspaceProvider = (WorkspaceProvider)pc.getCurrentProject().getLookup().lookup(WorkspaceProvider.class)).getWorkspaces()).length > 0) {
            for (Workspace workspace : workspaces) {
                int index = this.tabDataModel.size();
                WorkspaceInformation workspaceInformation = (WorkspaceInformation)workspace.getLookup().lookup(WorkspaceInformation.class);
                this.tabDataModel.addTab(index, new TabData((Object)new WorkspaceComponent(workspace), null, workspaceInformation.getName(), workspaceInformation.getSource()));
                if (workspaceProvider.getCurrentWorkspace() != workspace) continue;
                this.tabbedContainer.getSelectionModel().setSelectedIndex(index);
                ((WorkspaceInformation)workspace.getLookup().lookup(WorkspaceInformation.class)).addChangeListener((PropertyChangeListener)this);
            }
            this.add((Component)this.tabbedContainer, "Center");
            this.getParent().revalidate();
            return;
        }
        this.tabbedContainer.getSelectionModel().clearSelection();
        if (this.tabDataModel.size() > 0) {
            this.tabDataModel.removeTabs(0, this.tabDataModel.size() - 1);
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public void initialize(final Workspace workspace) {
        final WorkspaceInformation workspaceInformation = (WorkspaceInformation)workspace.getLookup().lookup(WorkspaceInformation.class);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WorkspacePanel.this.tabDataModel.addTab(WorkspacePanel.this.tabDataModel.size(), new TabData((Object)new WorkspaceComponent(workspace), WorkspacePanel.this.workspaceIcon, workspaceInformation.getName(), workspaceInformation.getSource()));
                if (WorkspacePanel.this.tabDataModel.size() == 1) {
                    WorkspacePanel.this.tabbedContainer.getSelectionModel().setSelectedIndex(0);
                    WorkspacePanel.this.add((Component)WorkspacePanel.this.tabbedContainer, "Center");
                    WorkspacePanel.this.getParent().revalidate();
                }
            }
        });
    }

    public void select(final Workspace workspace) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < WorkspacePanel.this.tabDataModel.size(); ++i) {
                    TabData tabData = WorkspacePanel.this.tabDataModel.getTab(i);
                    if (((WorkspaceComponent)tabData.getUserObject()).workspace != workspace) continue;
                    if (WorkspacePanel.this.tabbedContainer.getSelectionModel().getSelectedIndex() != i) {
                        WorkspacePanel.this.tabbedContainer.getSelectionModel().setSelectedIndex(i);
                    }
                    ((WorkspaceInformation)workspace.getLookup().lookup(WorkspaceInformation.class)).addChangeListener((PropertyChangeListener)WorkspacePanel.this);
                    break;
                }
            }
        });
    }

    public void unselect(Workspace workspace) {
        ((WorkspaceInformation)workspace.getLookup().lookup(WorkspaceInformation.class)).removeChangeListener((PropertyChangeListener)this);
    }

    public void close(final Workspace workspace) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < WorkspacePanel.this.tabDataModel.size(); ++i) {
                    TabData tabData = WorkspacePanel.this.tabDataModel.getTab(i);
                    if (((WorkspaceComponent)tabData.getUserObject()).workspace != workspace) continue;
                    WorkspacePanel.this.tabDataModel.removeTab(i);
                    break;
                }
                if (WorkspacePanel.this.tabDataModel.size() == 0) {
                    WorkspacePanel.this.tabbedContainer.getSelectionModel().clearSelection();
                    WorkspacePanel.this.remove((Component)WorkspacePanel.this.tabbedContainer);
                    WorkspacePanel.this.getParent().revalidate();
                }
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("rename")) {
            final WorkspaceInformation workspaceInformation = (WorkspaceInformation)evt.getSource();
            final int index = this.tabbedContainer.getSelectionModel().getSelectedIndex();
            if (!this.tabDataModel.getTab(index).getText().equals(workspaceInformation.getName())) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WorkspacePanel.this.tabbedContainer.setTitleAt(index, workspaceInformation.getName());
                    }
                });
            }
        } else if (evt.getPropertyName().equals("setSource")) {
            final WorkspaceInformation workspaceInformation = (WorkspaceInformation)evt.getSource();
            final int index = this.tabbedContainer.getSelectionModel().getSelectedIndex();
            if (this.tabDataModel.getTab(index).getTooltip() == null || !this.tabDataModel.getTab(index).getTooltip().equals(workspaceInformation.getSource())) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WorkspacePanel.this.tabbedContainer.setToolTipTextAt(index, workspaceInformation.getSource());
                    }
                });
            }
        }
    }

    private static class WorkspaceComponent
    extends JComponent {
        private final Workspace workspace;

        public WorkspaceComponent(Workspace workspace) {
            this.workspace = workspace;
        }
    }
}

