/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.filters.query;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Action;
import org.gephi.desktop.filters.library.FilterBuilderNode;
import org.gephi.desktop.filters.query.ParameterNode;
import org.gephi.desktop.filters.query.QueryNode;
import org.gephi.desktop.filters.query.SlotNode;
import org.gephi.filters.api.FilterController;
import org.gephi.filters.api.Query;
import org.gephi.filters.spi.FilterBuilder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.PasteType;

public class QueryChildren
extends Children.Array {
    private Query query;
    private Query[] topQuery;

    public QueryChildren(Query query) {
        this.query = query;
    }

    public QueryChildren(Query[] topQuery) {
        if (topQuery.length > 0) {
            this.topQuery = topQuery;
        }
    }

    protected Collection<Node> initCollection() {
        ArrayList<Node> nodesChildren = new ArrayList<Node>();
        if (this.query == null && this.topQuery == null) {
            nodesChildren.add((Node)new HelpNode());
        } else {
            int slots;
            Query[] children = this.topQuery != null ? this.topQuery : this.query.getChildren();
            boolean hasParameters = this.query != null && this.query.getPropertiesCount() > 0;
            int n = slots = this.topQuery != null ? this.topQuery.length : this.query.getChildrenSlotsCount();
            if (slots == Integer.MAX_VALUE) {
                int n2 = slots = children != null ? children.length + 1 : 1;
            }
            if (hasParameters) {
                nodesChildren.add((Node)new ParameterNode(this.query));
            }
            for (int i = 0; i < slots; ++i) {
                if (children != null && i < children.length) {
                    nodesChildren.add((Node)new QueryNode(children[i]));
                    continue;
                }
                nodesChildren.add((Node)new SlotNode(this.query));
            }
        }
        return nodesChildren;
    }

    private static class HelpNode
    extends AbstractNode {
        public HelpNode() {
            super(Children.LEAF);
            this.setIconBaseWithExtension("org/gephi/desktop/filters/query/resources/drop.png");
        }

        public String getHtmlDisplayName() {
            return NbBundle.getMessage(QueryChildren.class, (String)"HelpNode.name");
        }

        public PasteType getDropType(Transferable t, int action, int index) {
            if (t.isDataFlavorSupported(FilterBuilderNode.DATA_FLAVOR)) {
                try {
                    final FilterBuilder fb = (FilterBuilder)t.getTransferData(FilterBuilderNode.DATA_FLAVOR);
                    return new PasteType(){

                        public Transferable paste() throws IOException {
                            FilterController filterController = (FilterController)Lookup.getDefault().lookup(FilterController.class);
                            Query f = filterController.createQuery(fb);
                            filterController.add(f);
                            return null;
                        }
                    };
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return null;
        }

        public Action[] getActions(boolean context) {
            return new Action[0];
        }
    }
}

