/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.exporter.plugin;

import javax.swing.JPanel;
import org.gephi.io.exporter.plugin.ExporterGML;
import org.gephi.io.exporter.spi.Exporter;
import org.gephi.io.exporter.spi.ExporterUI;
import org.gephi.ui.exporter.plugin.AbstractExporterSettings;
import org.gephi.ui.exporter.plugin.UIExporterGEXF;
import org.gephi.ui.exporter.plugin.UIExporterGMLPanel;
import org.netbeans.validation.api.ui.ValidationPanel;
import org.openide.util.NbBundle;

public class UIExporterGML
implements ExporterUI {
    ValidationPanel validationPanel;
    UIExporterGMLPanel panel;
    ExporterGML exporter;
    ExporterGMLSettings settings = new ExporterGMLSettings();

    public JPanel getPanel() {
        this.panel = new UIExporterGMLPanel();
        this.validationPanel = UIExporterGMLPanel.createValidationPanel(this.panel);
        return this.validationPanel;
    }

    public void setup(Exporter exporter) {
        this.exporter = (ExporterGML)exporter;
        this.settings.load(this.exporter);
        this.panel.setup(this.exporter);
    }

    public void unsetup(boolean update) {
        if (update) {
            this.panel.unsetup(this.exporter);
            this.settings.save(this.exporter);
        }
        this.panel = null;
        this.exporter = null;
    }

    public boolean isUIForExporter(Exporter exporter) {
        return exporter instanceof ExporterGML;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(UIExporterGEXF.class, (String)"UIExporterGML.name");
    }

    private static class ExporterGMLSettings
    extends AbstractExporterSettings {
        private static final String EXPORT_LABEL = "GML_exportLabel";
        private static final String EXPORT_COORDINATES = "GML_exportCoordinates";
        private static final String EXPORT_NODE_SIZE = "GML_exportNodeSize";
        private static final String EXPORT_EDGE_SIZE = "GML_exportEdgeSize";
        private static final String EXPORT_COLOR = "GML_exportColor";
        private static final String EXPORT_UNKNOWNS = "GML_exportNotRecognizedElements";
        private static final String NORMALIZE = "GML_normalize";
        private static final String SPACES = "GML_spaces";
        private static final ExporterGML DEFAULT = new ExporterGML();

        private ExporterGMLSettings() {
        }

        private void load(ExporterGML exporter) {
            exporter.setExportColor(this.get(EXPORT_COLOR, DEFAULT.isExportColor()));
            exporter.setExportCoordinates(this.get(EXPORT_COORDINATES, DEFAULT.isExportCoordinates()));
            exporter.setExportEdgeSize(this.get(EXPORT_EDGE_SIZE, DEFAULT.isExportEdgeSize()));
            exporter.setExportLabel(this.get(EXPORT_LABEL, DEFAULT.isExportLabel()));
            exporter.setExportNodeSize(this.get(EXPORT_NODE_SIZE, DEFAULT.isExportNodeSize()));
            exporter.setExportNotRecognizedElements(this.get(EXPORT_UNKNOWNS, DEFAULT.isExportNotRecognizedElements()));
            exporter.setNormalize(this.get(NORMALIZE, DEFAULT.isNormalize()));
            exporter.setSpaces(this.get(SPACES, DEFAULT.getSpaces()));
        }

        private void save(ExporterGML exporter) {
            this.put(EXPORT_COLOR, exporter.isExportColor());
            this.put(EXPORT_COORDINATES, exporter.isExportCoordinates());
            this.put(EXPORT_EDGE_SIZE, exporter.isExportEdgeSize());
            this.put(EXPORT_LABEL, exporter.isExportLabel());
            this.put(EXPORT_NODE_SIZE, exporter.isExportNodeSize());
            this.put(EXPORT_UNKNOWNS, exporter.isExportNotRecognizedElements());
            this.put(NORMALIZE, exporter.isNormalize());
            this.put(SPACES, exporter.getSpaces());
        }
    }
}

