/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aop.chain;

import io.micronaut.aop.Adapter;
import io.micronaut.aop.ConstructorInterceptor;
import io.micronaut.aop.Interceptor;
import io.micronaut.aop.InterceptorBinding;
import io.micronaut.aop.InterceptorKind;
import io.micronaut.aop.InterceptorRegistry;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.chain.AdapterIntroduction;
import io.micronaut.aop.chain.InterceptorChain;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanRegistration;
import io.micronaut.context.EnvironmentConfigurable;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.beans.BeanConstructor;
import io.micronaut.core.naming.Described;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Executable;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.qualifiers.InterceptorBindingQualifier;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultInterceptorRegistry
implements InterceptorRegistry {
    protected static final Logger LOG = LoggerFactory.getLogger(InterceptorChain.class);
    private static final MethodInterceptor<?, ?>[] ZERO_METHOD_INTERCEPTORS = new MethodInterceptor[0];
    private final BeanContext beanContext;

    public DefaultInterceptorRegistry(BeanContext beanContext) {
        this.beanContext = beanContext;
    }

    @Override
    @NonNull
    public <T> Interceptor<T, ?>[] resolveInterceptors(@NonNull Executable<T, ?> method, @NonNull Collection<BeanRegistration<Interceptor<T, ?>>> interceptors, @NonNull InterceptorKind interceptorKind) {
        AnnotationMetadata annotationMetadata = method.getAnnotationMetadata();
        if (interceptors.isEmpty()) {
            if (interceptorKind == InterceptorKind.INTRODUCTION) {
                if (annotationMetadata.hasStereotype(Adapter.class)) {
                    return new MethodInterceptor[]{new AdapterIntroduction(this.beanContext, (ExecutableMethod)method)};
                }
                throw new IllegalStateException("At least one @Introduction method interceptor required, but missing. Check if your @Introduction stereotype annotation is marked with @Retention(RUNTIME) and @Type(..) with the interceptor type. Otherwise do not load @Introduction beans if their interceptor definitions are missing!");
            }
            return ZERO_METHOD_INTERCEPTORS;
        }
        DefaultInterceptorRegistry.instrumentAnnotationMetadata(this.beanContext, method);
        List applicableBindings = annotationMetadata.getAnnotationValuesByType(InterceptorBinding.class).stream().filter(ann -> ann.enumValue("kind", InterceptorKind.class).orElse(InterceptorKind.AROUND) == interceptorKind).collect(Collectors.toList());
        Interceptor[] resolvedInterceptors = (Interceptor[])interceptors.stream().filter(beanRegistration -> {
            List typeArgs = beanRegistration.getBeanDefinition().getTypeArguments(ConstructorInterceptor.class);
            if (typeArgs.isEmpty()) {
                return true;
            }
            Class applicableType = ((Argument)typeArgs.iterator().next()).getType();
            return applicableType.isAssignableFrom(method.getDeclaringType());
        }).filter(beanRegistration -> applicableBindings.stream().anyMatch(annotationValue -> {
            boolean isApplicableByType = annotationValue.classValue("interceptorType").map(t -> t.isInstance(beanRegistration.getBean())).orElse(false);
            boolean isApplicationByBinding = annotationValue.stringValue().map(annotationName -> InterceptorBindingQualifier.resolveInterceptorValues((AnnotationMetadata)beanRegistration.getBeanDefinition().getAnnotationMetadata(), (String)interceptorKind.name()).contains(annotationName)).orElse(false);
            return isApplicableByType || isApplicationByBinding;
        })).sorted(OrderUtil.COMPARATOR).map(BeanRegistration::getBean).filter(bean -> bean instanceof MethodInterceptor || !(bean instanceof ConstructorInterceptor)).toArray(Interceptor[]::new);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Resolved {} {} interceptors out of a possible {} for method: {} - {}", new Object[]{resolvedInterceptors.length, interceptorKind, interceptors.size(), method.getDeclaringType(), method instanceof Described ? ((Described)method).getDescription(true) : method.toString()});
            for (int i = 0; i < resolvedInterceptors.length; ++i) {
                Interceptor resolvedInterceptor = resolvedInterceptors[i];
                LOG.trace("Interceptor {} - {}", (Object)i, (Object)resolvedInterceptor);
            }
        }
        return resolvedInterceptors;
    }

    @Override
    @NonNull
    public <T> Interceptor<T, T>[] resolveConstructorInterceptors(@NonNull BeanConstructor<T> constructor, @NonNull Collection<BeanRegistration<Interceptor<T, T>>> interceptors) {
        DefaultInterceptorRegistry.instrumentAnnotationMetadata(this.beanContext, constructor);
        List applicableBindings = constructor.getAnnotationMetadata().getAnnotationValuesByType(InterceptorBinding.class).stream().filter(ann -> ann.enumValue("kind", InterceptorKind.class).orElse(InterceptorKind.AROUND) == InterceptorKind.AROUND_CONSTRUCT).collect(Collectors.toList());
        Interceptor[] resolvedInterceptors = (Interceptor[])interceptors.stream().filter(beanRegistration -> {
            List typeArgs = beanRegistration.getBeanDefinition().getTypeArguments(ConstructorInterceptor.class);
            if (typeArgs.isEmpty()) {
                return true;
            }
            Class applicableType = ((Argument)typeArgs.iterator().next()).getType();
            return applicableType.isAssignableFrom(constructor.getDeclaringBeanType());
        }).filter(beanRegistration -> applicableBindings.stream().anyMatch(annotationValue -> {
            boolean isApplicableByType = annotationValue.classValue("interceptorType").map(t -> t.isInstance(beanRegistration.getBean())).orElse(false);
            boolean isApplicationByBinding = annotationValue.stringValue().map(annotationName -> InterceptorBindingQualifier.resolveInterceptorValues((AnnotationMetadata)beanRegistration.getBeanDefinition().getAnnotationMetadata()).contains(annotationName)).orElse(false);
            return isApplicableByType || isApplicationByBinding;
        })).sorted(OrderUtil.COMPARATOR).map(BeanRegistration::getBean).filter(bean -> bean instanceof ConstructorInterceptor || !(bean instanceof MethodInterceptor)).toArray(Interceptor[]::new);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Resolved {} {} interceptors out of a possible {} for constructor: {} - {}", new Object[]{resolvedInterceptors.length, InterceptorKind.AROUND_CONSTRUCT, interceptors.size(), constructor.getDeclaringBeanType(), constructor.getDescription(true)});
            for (int i = 0; i < resolvedInterceptors.length; ++i) {
                Interceptor resolvedInterceptor = resolvedInterceptors[i];
                LOG.trace("Interceptor {} - {}", (Object)i, (Object)resolvedInterceptor);
            }
        }
        return resolvedInterceptors;
    }

    private static void instrumentAnnotationMetadata(BeanContext beanContext, Object method) {
        EnvironmentConfigurable m;
        if (beanContext instanceof ApplicationContext && method instanceof EnvironmentConfigurable && (m = (EnvironmentConfigurable)method).hasPropertyExpressions()) {
            m.configure(((ApplicationContext)beanContext).getEnvironment());
        }
    }
}

