/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jsonkiosk;

import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.jsonkiosk.JsonNioServer;

public interface JsonNioClient {
    public void nioClosed(JsonNioServer var1);

    public void processNioMessage(byte[] var1) throws Exception;

    public void serverCycle();

    public static class TouchHandler {
        public static final float swipeCutoff = 100.0f;
        public static final int swipeCount = 2;
        public static final float swipeDelayMs = 3000.0f;
        public static final float swipeFactor = 30.0f;
        public int nFast;
        public long previousMoveTime;
        public long swipeStartTime;
        public long latestMoveTime;
        public boolean wasSpinOn;
        public boolean isPaused;

        public void pauseScript(Viewer vwr, boolean isPause) {
            String script;
            if (isPause) {
                this.wasSpinOn = vwr.getBooleanProperty("spinOn");
                script = "pause; save orientation 'JsonNios-save'; spin off";
                this.isPaused = true;
            } else {
                script = "restore orientation 'JsonNios-save' 1; resume; spin " + this.wasSpinOn;
                this.wasSpinOn = false;
            }
            this.isPaused = isPause;
            vwr.evalString(script);
        }

        public void checkPaused(Viewer vwr) {
            long now = System.currentTimeMillis();
            if (this.isPaused && now - this.latestMoveTime > 5000L) {
                this.pauseScript(vwr, false);
            }
        }
    }
}

