/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import java.util.Arrays;
import javajs.util.AU;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.smiles.InvalidSmilesException;
import org.jmol.smiles.PolyhedronStereoSorter;
import org.jmol.smiles.SmilesAtom;
import org.jmol.smiles.SmilesBond;
import org.jmol.smiles.SmilesParser;
import org.jmol.smiles.SmilesSearch;
import org.jmol.smiles.VTemp;
import org.jmol.util.Edge;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Node;
import org.jmol.util.SimpleEdge;
import org.jmol.util.SimpleNode;

public class SmilesStereo {
    private int chiralClass = Integer.MIN_VALUE;
    int chiralOrder = Integer.MIN_VALUE;
    int atomCount;
    private String details;
    private SmilesSearch search;
    private Node[] jmolAtoms;
    public static final int DEFAULT = 0;
    public static final int POLYHEDRAL = 1;
    public static final int ALLENE = 2;
    public static final int TRIGONAL_PYRAMIDAL = 3;
    public static final int TETRAHEDRAL = 4;
    public static final int TRIGONAL_BIPYRAMIDAL = 5;
    public static final int OCTAHEDRAL = 6;
    public static final int SQUARE_PLANAR = 7;
    public static final int T_SHAPED = 8;
    public static final int SEESAW = 9;
    private static final int[] PERM_TB = new int[]{0, 1, 4, 0, -1, 4, 0, 1, 3, 0, -1, 3, 0, 1, 2, 0, -1, 2, 0, 1, 1, 0, -1, 1, 1, 1, 4, 1, 1, 3, 1, -1, 4, 1, -1, 3, 1, 1, 2, 1, -1, 2, 2, 1, 4, 2, 1, 3, 3, 1, 4, 3, -1, 4, 2, -1, 3, 2, -1, 4};
    private static final int[] PERM_OCT = new int[]{0, 1, 5, 0, -1, 5, 0, 1, 4, 0, 3, 5, 0, 3, 4, 0, 1, 3, 0, 3, 3, 0, 2, 5, 0, 2, 4, 0, -2, 5, 0, -2, 4, 0, 2, 3, 0, -2, 3, 0, -3, 5, 0, -3, 4, 0, -1, 4, 0, -3, 3, 0, -1, 3, 0, 1, 2, 0, 3, 2, 0, 2, 2, 0, -2, 2, 0, -3, 2, 0, -1, 2, 0, 1, 1, 0, 3, 1, 0, 2, 1, 0, -2, 1, 0, -3, 1, 0, -1, 1};
    private static final int[] PERM_SS = new int[]{0, 1, 3, 0, -1, 3, 0, 1, 2, 0, -1, 2, 0, 1, 1, 0, -1, 1, 1, 1, 3, 1, -1, 3, 1, 1, 2, 1, -1, 2, 2, 1, 3, 2, -1, 3};
    VTemp v;
    private int[][] polyhedralOrders;
    private boolean isNot;
    private PolyhedronStereoSorter sorter;

    private static int getChiralityClass(String xx) {
        return ("0;PH;AL;TP;TH;TB;OH;SP;TS;SS;".indexOf(xx) + 1) / 3;
    }

    public static SmilesStereo newStereo(SmilesSearch search) throws InvalidSmilesException {
        SmilesStereo stereo = new SmilesStereo(0, 0, 0, null, null);
        stereo.search = search;
        return stereo;
    }

    SmilesStereo(int chiralClass, int chiralOrder, int atomCount, String details, String directives) throws InvalidSmilesException {
        this.chiralClass = chiralClass;
        this.chiralOrder = chiralOrder;
        this.atomCount = atomCount;
        this.details = details;
        if (chiralClass == 1) {
            this.getPolyhedralOrders();
        }
    }

    public int getChiralClass(SmilesAtom sAtom) {
        if (this.chiralClass == 0) {
            this.setChiralClass(sAtom);
        }
        return this.chiralClass;
    }

    private int setChiralClass(SmilesAtom sAtom) {
        int nBonds = Math.max(sAtom.explicitHydrogenCount, 0) + sAtom.getBondCount();
        if (this.chiralClass == 0) {
            switch (nBonds) {
                case 2: {
                    this.chiralClass = 2;
                    break;
                }
                case 3: {
                    this.chiralClass = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    this.chiralClass = nBonds;
                }
            }
        }
        return nBonds;
    }

    void fixStereo(SmilesAtom sAtom) throws InvalidSmilesException {
        int nBonds = this.setChiralClass(sAtom);
        int nH = Math.max(sAtom.explicitHydrogenCount, 0);
        if (nH <= 1) {
            switch (this.chiralClass) {
                case 2: {
                    if (nBonds == 2) break;
                    sAtom.stereo = null;
                    break;
                }
                case 3: 
                case 8: {
                    if (nBonds == 3) break;
                    sAtom.stereo = null;
                    break;
                }
                case 4: 
                case 7: {
                    if (nBonds == 4) break;
                    sAtom.stereo = null;
                    break;
                }
                case 5: 
                case 6: 
                case 9: {
                    if (nBonds == (this.chiralClass == 9 ? 4 : this.chiralClass) && this.normalizeClass(sAtom)) break;
                    sAtom.stereo = null;
                    break;
                }
                case 1: {
                    if (nBonds == 0 || nBonds == this.atomCount) break;
                    sAtom.stereo = null;
                    break;
                }
                default: {
                    sAtom.stereo = null;
                }
            }
        }
        if (sAtom.stereo == null) {
            throw new InvalidSmilesException("Incorrect number of bonds for stereochemistry descriptor");
        }
    }

    private boolean normalizeClass(SmilesAtom atom) {
        try {
            int i;
            SmilesBond b;
            boolean isAtAt;
            int ilast;
            int[] perm;
            SmilesBond[] bonds = atom.bonds;
            if (this.chiralOrder < 3) {
                return true;
            }
            int pt = (this.chiralOrder - 1) * 3;
            switch (this.chiralClass) {
                case 9: {
                    perm = PERM_SS;
                    ilast = 3;
                    break;
                }
                case 5: {
                    perm = PERM_TB;
                    ilast = 4;
                    break;
                }
                case 6: {
                    perm = PERM_OCT;
                    ilast = 5;
                    break;
                }
                default: {
                    return true;
                }
            }
            if (this.chiralOrder > perm.length) {
                return false;
            }
            int a = perm[pt];
            int z = perm[pt + 2];
            int p = Math.abs(perm[pt + 1]);
            boolean bl = isAtAt = perm[pt + 1] < 0;
            if (a != 0) {
                b = bonds[a];
                for (i = a; i > 0; --i) {
                    bonds[i] = bonds[i - 1];
                }
                bonds[0] = b;
            }
            if (z != ilast) {
                b = bonds[z];
                for (i = z; i < ilast; ++i) {
                    bonds[i] = bonds[i + 1];
                }
                bonds[ilast] = b;
            }
            switch (p) {
                case 1: {
                    break;
                }
                default: {
                    b = bonds[p + 1];
                    bonds[p + 1] = bonds[p];
                    bonds[p] = b;
                }
            }
            this.chiralOrder = isAtAt ? 2 : 1;
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean setTopoCoordinates(SmilesAtom sAtom0, SmilesAtom pAtom, SmilesAtom sAtom2, Node[] cAtoms, boolean isNot) {
        int[] map;
        int chiralOrder = sAtom0.stereo == null ? 0 : sAtom0.stereo.chiralOrder;
        int chClass = sAtom0.stereo == null ? 1 : sAtom0.stereo.chiralClass;
        sAtom0.set(0.0f, 0.0f, 0.0f);
        if (this.jmolAtoms == null) {
            map = new int[]{0, 1, 2, 3};
        } else {
            sAtom0 = (SmilesAtom)this.jmolAtoms[pAtom.getMatchingAtomIndex()];
            sAtom0.set(0.0f, 0.0f, 0.0f);
            SmilesAtom a2 = (SmilesAtom)(chClass == 2 ? this.jmolAtoms[sAtom2.getMatchingAtomIndex()] : null);
            map = this.getMappedTopoAtoms(sAtom0, a2, cAtoms, chiralOrder == 0 ? new int[cAtoms.length] : null);
        }
        switch (chClass) {
            case 1: {
                sAtom0.set(0.0f, 0.0f, 0.2f);
                double a = Math.PI * 2 / (double)cAtoms.length;
                int i = cAtoms.length;
                while (--i >= 0) {
                    cAtoms[map[i]].set((float)Math.cos((double)i * a), (float)Math.sin((double)i * a), isNot ? 1.0f : -1.0f);
                }
                break;
            }
            case 2: 
            case 4: {
                if (chiralOrder == 2) {
                    int pt = map[0];
                    map[0] = map[1];
                    map[1] = pt;
                }
                cAtoms[map[0]].set(0.0f, 0.0f, 1.0f);
                cAtoms[map[1]].set(1.0f, 0.0f, -1.0f);
                cAtoms[map[2]].set(0.0f, 1.0f, -1.0f);
                cAtoms[map[3]].set(-1.0f, -1.0f, -1.0f);
                break;
            }
            case 7: {
                switch (chiralOrder) {
                    case 1: {
                        cAtoms[map[0]].set(1.0f, 0.0f, 0.0f);
                        cAtoms[map[1]].set(0.0f, 1.0f, 0.0f);
                        cAtoms[map[2]].set(-1.0f, 0.0f, 0.0f);
                        cAtoms[map[3]].set(0.0f, -1.0f, 0.0f);
                        break;
                    }
                    case 2: {
                        cAtoms[map[0]].set(1.0f, 0.0f, 0.0f);
                        cAtoms[map[1]].set(-1.0f, 0.0f, 0.0f);
                        cAtoms[map[2]].set(0.0f, 1.0f, 0.0f);
                        cAtoms[map[3]].set(0.0f, -1.0f, 0.0f);
                        break;
                    }
                    case 3: {
                        cAtoms[map[0]].set(1.0f, 0.0f, 0.0f);
                        cAtoms[map[1]].set(0.0f, 1.0f, 0.0f);
                        cAtoms[map[2]].set(0.0f, -1.0f, 0.0f);
                        cAtoms[map[3]].set(-1.0f, 0.0f, 0.0f);
                    }
                }
                break;
            }
            case 8: {
                switch (chiralOrder) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        int pt = map[2];
                        map[2] = map[1];
                        map[1] = pt;
                        break;
                    }
                    case 3: {
                        int pt = map[0];
                        map[0] = map[1];
                        map[1] = pt;
                    }
                }
                cAtoms[map[0]].set(0.0f, 0.0f, -1.0f);
                cAtoms[map[1]].set(0.0f, 1.0f, 0.0f);
                cAtoms[map[2]].set(0.0f, 0.0f, 1.0f);
                break;
            }
            case 9: {
                if (chiralOrder == 2) {
                    int pt = map[0];
                    map[0] = map[3];
                    map[3] = pt;
                }
                cAtoms[map[0]].set(0.0f, 0.0f, 1.0f);
                cAtoms[map[1]].set(0.0f, 1.0f, 0.0f);
                cAtoms[map[1]].set(1.0f, 1.0f, 0.0f);
                cAtoms[map[2]].set(0.0f, 0.0f, -1.0f);
                break;
            }
            case 5: 
            case 6: {
                int n = map.length;
                if (chiralOrder == 2) {
                    int pt = map[0];
                    map[0] = map[n - 1];
                    map[n - 1] = pt;
                }
                cAtoms[map[0]].set(0.0f, 0.0f, 1.0f);
                cAtoms[map[n - 1]].set(0.0f, 0.0f, -1.0f);
                cAtoms[map[1]].set(1.0f, 0.0f, 0.0f);
                cAtoms[map[2]].set(0.0f, 1.0f, 0.0f);
                cAtoms[map[3]].set(-1.0f, 0.0f, 0.0f);
                if (n != 6) break;
                cAtoms[map[4]].set(0.0f, -1.0f, 0.0f);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private int[] getMappedTopoAtoms(SmilesAtom atom, SmilesAtom a2, Node[] cAtoms, int[] map) {
        int i;
        if (map == null) {
            map = new int[cAtoms[4] == null ? 4 : (cAtoms[5] == null ? 5 : 6)];
        }
        for (int i2 = 0; i2 < map.length; ++i2) {
            map[i2] = cAtoms[i2] == null ? 10004 + i2 * 10000 : cAtoms[i2].getIndex();
        }
        SmilesBond[] bonds = atom.bonds;
        SmilesBond[] b2 = (SmilesBond[])(a2 == null ? null : a2.getEdges());
        for (i = 0; i < map.length; ++i) {
            SmilesAtom c = (SmilesAtom)cAtoms[i];
            if (SmilesStereo.getTopoMapPt(map, i, atom, c, bonds, 10000)) continue;
            SmilesStereo.getTopoMapPt(map, i, a2, c, b2, 30000);
        }
        Arrays.sort(map);
        for (i = 0; i < map.length; ++i) {
            map[i] = map[i] % 10;
        }
        return map;
    }

    private static boolean getTopoMapPt(int[] map, int i, SmilesAtom atom, SmilesAtom cAtom, SmilesBond[] bonds, int n000) {
        if (cAtom.index == Integer.MIN_VALUE) {
            map[i] = (bonds[0].isFromPreviousTo(atom) ? 100 : 0) + n000 + i;
            return true;
        }
        int n = bonds.length;
        for (int k = 0; k < n; ++k) {
            SmilesAtom bAtom = (SmilesAtom)bonds[k].getOtherNode(atom);
            if (bAtom != cAtom) continue;
            map[i] = (k + 1) * 10 + n000 + i;
            return true;
        }
        return false;
    }

    private Node getJmolAtom(int i) {
        return i < 0 || i >= this.jmolAtoms.length ? null : this.jmolAtoms[i];
    }

    void sortPolyBondsByStereo(SimpleNode atom, SimpleNode ref, T3 center, SimpleEdge[] bonds, V3 vTemp) {
        if (bonds.length < 2 || !(atom instanceof T3)) {
            return;
        }
        boolean checkAlign = ref != null;
        ref = bonds[0].getOtherNode(atom);
        Object[][] aTemp = new Object[bonds.length][0];
        if (this.sorter == null) {
            this.sorter = new PolyhedronStereoSorter();
        }
        vTemp.sub2((T3)((Object)ref), center);
        this.sorter.setRef(vTemp);
        int nb = bonds.length;
        float f0 = 0.0f;
        int i = nb;
        while (--i >= 0) {
            SimpleNode a = bonds[i].getOtherNode(atom);
            float f = f0 + (a == ref ? 0.0f : (checkAlign && this.sorter.isAligned((T3)((Object)a), center, (T3)((Object)ref)) ? -999.0f : Measure.computeTorsion((T3)((Object)ref), (T3)((Object)atom), center, (T3)((Object)a), true)));
            aTemp[i] = new Object[]{bonds[i], Float.valueOf(f), a};
        }
        Arrays.sort(aTemp, this.sorter);
        if (Logger.debugging) {
            Logger.info(Escape.e(aTemp));
        }
        i = bonds.length;
        while (--i >= 0) {
            bonds[i] = (Edge)aTemp[i][0];
        }
    }

    boolean checkStereoChemistry(SmilesSearch search, VTemp v) {
        this.v = v;
        this.search = search;
        this.jmolAtoms = search.targetAtoms;
        boolean haveTopo = search.haveTopo;
        boolean invertStereochemistry = search.invertStereochemistry;
        if (Logger.debugging) {
            Logger.debug("checking stereochemistry...");
        }
        block5: for (int i = 0; i < search.ac; ++i) {
            SmilesAtom pAtom = search.patternAtoms[i];
            if (pAtom.stereo == null && search.polyhedronStereo == null) continue;
            boolean isNot = pAtom.not != invertStereochemistry;
            switch (this.checkStereoForAtom(pAtom, isNot, haveTopo)) {
                case 0: {
                    continue block5;
                }
                case 1: {
                    return true;
                }
                case -1: {
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public int checkStereoForAtom(SmilesAtom pAtom, boolean isNot, boolean haveTopo) {
        atom1 = null;
        atom2 = null;
        atom3 = null;
        atom4 = null;
        atom5 = null;
        atom6 = null;
        sAtom0 = null;
        atom0 = pAtom.getMatchingAtom();
        if (haveTopo) {
            sAtom0 = (SmilesAtom)atom0;
        }
        nH = Math.max(pAtom.explicitHydrogenCount, 0);
        order = pAtom.stereo == null ? 0 : pAtom.stereo.chiralOrder;
        v0 = chiralClass = pAtom.stereo == null ? 1 : pAtom.stereo.chiralClass;
        if (haveTopo && this.chiralOrder != 0 && sAtom0.getChiralClass() != chiralClass) {
            return -1;
        }
        if (Logger.debugging) {
            Logger.debug("...type " + chiralClass + " for pattern atom \n " + pAtom + "\n " + atom0);
        }
        switch (chiralClass) {
            case 1: {
                if (pAtom.bondCount == 0) {
                    this.search.polyhedronStereo = pAtom.stereo;
                    return 0;
                }
                if (this.chiralOrder != 0) ** GOTO lbl36
                atoms12N = new Node[pAtom.bondCount];
                for (i = 0; i < atoms12N.length; ++i) {
                    atoms12N[i] = this.getJmolAtom(pAtom.getMatchingBondedAtom(i));
                }
                if (!haveTopo) ** GOTO lbl31
                v1 = this.search.polyhedronStereo.isNot ? !isNot : isNot;
                if (!this.setTopoCoordinates(sAtom0, pAtom, null, atoms12N, v1)) ** GOTO lbl-1000
lbl31:
                // 2 sources

                if (!this.checkPolyHedralWinding(pAtom.getMatchingAtom(), atoms12N)) lbl-1000:
                // 2 sources

                {
                    v2 = -1;
                } else {
                    v2 = 0;
                }
                return v2;
lbl36:
                // 1 sources

                if (nH > 1) {
                    return 0;
                }
                if (pAtom.stereo.isNot) {
                    v3 = isNot = isNot == false;
                }
                if (haveTopo) {
                    return 0;
                }
                bonds = pAtom.bonds;
                jHpt = -1;
                if (nH == 1) {
                    v4 = jHpt = pAtom.isFirst != false ? 0 : 1;
                    if (pAtom.getBondCount() != 3) {
                        return -1;
                    }
                    this.v.vA.set(0.0f, 0.0f, 0.0f);
                    for (j = 0; j < 3; ++j) {
                        this.v.vA.add((T3)bonds[j].getOtherAtom(sAtom0).getMatchingAtom());
                    }
                    this.v.vA.scale(0.3333f);
                    this.v.vA.sub2((T3)atom0, this.v.vA);
                    this.v.vA.add((T3)atom0);
                }
                po = pAtom.stereo.polyhedralOrders;
                j = po.length;
                while (--j >= 0) {
                    orders = po[j];
                    if (orders == null || orders.length < 2) continue;
                    pt = j > jHpt ? j - nH : j;
                    ta1 = j == jHpt ? this.v.vA : (T3)bonds[pt].getOtherAtom(pAtom).getMatchingAtom();
                    flast = isNot != false ? 3.4028235E38f : 0.0f;
                    ta2 = null;
                    for (k = 0; k < orders.length; ++k) {
                        pt = orders[k];
                        if (pt == jHpt) {
                            ta3 /* !! */  = this.v.vA;
                        } else {
                            if (pt > jHpt) {
                                --pt;
                            }
                            ta3 /* !! */  = (T3)bonds[pt].getOtherAtom(pAtom).getMatchingAtom();
                        }
                        if (k == 0) {
                            ta2 = ta3 /* !! */ ;
                            continue;
                        }
                        f = Measure.computeTorsion(ta3 /* !! */ , ta1, (T3)atom0, ta2, true);
                        if (Float.isNaN(f)) {
                            f = 180.0f;
                        }
                        if (orders.length == 2) {
                            return f < 0.0f != isNot ? 1 : -1;
                        }
                        if (f < 0.0f) {
                            f += 360.0f;
                        }
                        if (f < flast != isNot) {
                            return -1;
                        }
                        flast = f;
                    }
                }
                return 0;
            }
            case 2: {
                jn = this.getAlleneAtoms(haveTopo, sAtom0, pAtom, null);
                if (jn == null) {
                    return 0;
                }
                if (jn.length == 0) {
                    return -1;
                }
                if (!SmilesStereo.checkStereochemistryAll(isNot, atom0, chiralClass, order, jn[0], jn[1], jn[2], jn[3], null, null, this.v)) {
                    return -1;
                }
                return 0;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                atom1 = this.getJmolAtom(pAtom.getMatchingBondedAtom(0));
                switch (nH) {
                    case 0: {
                        atom2 = this.getJmolAtom(pAtom.getMatchingBondedAtom(1));
                        break;
                    }
                    case 1: {
                        atom2 = this.search.findImplicitHydrogen(pAtom.getMatchingAtom());
                        if (!pAtom.isFirst) break;
                        a = atom2;
                        atom2 = atom1;
                        atom1 = a;
                        break;
                    }
                    default: {
                        return 0;
                    }
                }
                atom3 = this.getJmolAtom(pAtom.getMatchingBondedAtom(2 - nH));
                atom4 = this.getJmolAtom(pAtom.getMatchingBondedAtom(3 - nH));
                atom5 = this.getJmolAtom(pAtom.getMatchingBondedAtom(4 - nH));
                atom6 = this.getJmolAtom(pAtom.getMatchingBondedAtom(5 - nH));
                if (haveTopo && !this.setTopoCoordinates(sAtom0, pAtom, null, new Node[]{atom1, atom2, atom3, atom4, atom5, atom6}, false)) {
                    return -1;
                }
                if (!SmilesStereo.checkStereochemistryAll(isNot, atom0, chiralClass, order, atom1, atom2, atom3, atom4, atom5, atom6, this.v)) {
                    return -1;
                }
                return 0;
            }
        }
        return 0;
    }

    private boolean checkPolyHedralWinding(Node a0, Node[] a) {
        for (int i = 0; i < a.length - 2; ++i) {
            if (SmilesStereo.getHandedness(a[i], a[i + 1], a[i + 2], a0, this.v) == 1) continue;
            return false;
        }
        return true;
    }

    public Node[] getAlleneAtoms(boolean haveTopo, SmilesAtom sAtom0, SmilesAtom pAtom, SmilesAtom pAtom1) {
        SmilesBond b;
        int k;
        SmilesAtom pAtom2;
        if (pAtom1 == null) {
            pAtom1 = pAtom.getBond(0).getOtherAtom(pAtom);
        }
        if ((pAtom2 = pAtom.getBond(1).getOtherAtom(pAtom)) == pAtom1) {
            pAtom2 = pAtom.getBond(0).getOtherAtom(pAtom);
        }
        if (pAtom1 == null || pAtom2 == null) {
            return null;
        }
        SmilesAtom pAtom1a = pAtom;
        SmilesAtom pAtom2a = pAtom;
        while (pAtom1.getBondCount() == 2 && pAtom2.getBondCount() == 2 && pAtom1.getValence() == 4 && pAtom2.getValence() == 4) {
            SmilesBond b2 = pAtom1.getBondNotTo(pAtom1a, true);
            pAtom1a = pAtom1;
            pAtom1 = b2.getOtherAtom(pAtom1);
            b2 = pAtom2.getBondNotTo(pAtom2a, true);
            pAtom2a = pAtom2;
            pAtom2 = b2.getOtherAtom(pAtom2);
        }
        pAtom = pAtom1;
        Node[] jn = new Node[6];
        jn[4] = new SmilesAtom().setIndex(60004);
        int nBonds = pAtom.getBondCount();
        if (nBonds != 2 && nBonds != 3) {
            return null;
        }
        int p = 0;
        for (k = 0; k < nBonds; ++k) {
            b = pAtom.bonds[k];
            pAtom1 = b.getOtherAtom(pAtom);
            if (b.getMatchingBond().getCovalentOrder() == 2) {
                if (pAtom2 != null) continue;
                pAtom2 = pAtom1;
                continue;
            }
            if (!(b.atom1 != pAtom1 || b.isConnection && pAtom1.index <= pAtom.index)) {
                p = 0;
            } else if (jn[1] == null) {
                p = 1;
            } else {
                p = 1;
                jn[0] = jn[1];
            }
            jn[p] = pAtom1.getMatchingAtom();
        }
        if (pAtom2 == null) {
            return null;
        }
        nBonds = pAtom2.getBondCount();
        if (nBonds != 2 && nBonds != 3) {
            return null;
        }
        int p2 = 0;
        for (int k2 = 0; k2 < nBonds; ++k2) {
            b = pAtom2.bonds[k2];
            pAtom1 = b.getOtherAtom(pAtom2);
            if (b.getMatchingBond().getCovalentOrder() == 2) continue;
            if (!(b.atom1 != pAtom1 || b.isConnection && pAtom1.index <= pAtom2.index)) {
                p2 = 2;
            } else if (jn[3] == null) {
                p2 = 3;
            } else {
                p2 = 3;
                jn[2] = jn[3];
            }
            jn[p2] = pAtom1.getMatchingAtom();
        }
        for (k = 0; k < 4; ++k) {
            if (jn[k] != null) continue;
            this.addAlleneLonePair(k < 2 ? pAtom : pAtom2, jn, k);
        }
        if (haveTopo && !this.setTopoCoordinates(sAtom0, pAtom, pAtom2, jn, false)) {
            return new Node[0];
        }
        return jn;
    }

    private void addAlleneLonePair(SmilesAtom pAtom, Node[] jn, int k) {
        Node atom = pAtom.getMatchingAtom();
        jn[k] = this.search.findImplicitHydrogen(atom);
        if (jn[k] != null) {
            return;
        }
        V3 v = new V3();
        for (int i = 0; i < 4; ++i) {
            if (jn[i] == null) continue;
            v.sub((P3)((Object)jn[i]));
        }
        if (v.length() == 0.0f) {
            v.setT((P3)((Object)jn[4]));
        } else {
            v.scaleAdd2(2.0f, (P3)((Object)pAtom.getMatchingAtom()), v);
        }
        jn[k] = new SmilesAtom().setIndex(Integer.MIN_VALUE);
        ((P3)((Object)jn[k])).setT(v);
    }

    static String getStereoFlag(SimpleNode atom0, SimpleNode[] atoms, int nAtoms, VTemp v, boolean is2D) {
        SimpleNode atom1 = atoms[0];
        SimpleNode atom2 = atoms[1];
        SimpleNode atom3 = atoms[2];
        SimpleNode atom4 = atoms[3];
        SimpleNode atom5 = atoms[4];
        SimpleNode atom6 = atoms[5];
        int chiralClass = 4;
        switch (nAtoms) {
            default: {
                return SmilesStereo.checkStereochemistryAll(false, atom0, chiralClass, 1, atom1, atom2, atom3, atom4, atom5, atom6, v) ? "@" : "@@";
            }
            case 2: 
            case 4: 
        }
        if (atom3 == null || atom4 == null) {
            return "";
        }
        float d = Measure.getNormalThroughPoints((P3)((Object)atom1), (P3)((Object)atom2), (P3)((Object)atom3), v.vTemp, v.vA);
        if (Math.abs(Measure.distanceToPlaneV(v.vTemp, d, (P3)((Object)atom4))) < 0.2f) {
            if (is2D) {
                return "";
            }
            chiralClass = 7;
            if (SmilesStereo.checkStereochemistryAll(false, atom0, chiralClass, 1, atom1, atom2, atom3, atom4, atom5, atom6, v)) {
                return "@SP1";
            }
            if (SmilesStereo.checkStereochemistryAll(false, atom0, chiralClass, 2, atom1, atom2, atom3, atom4, atom5, atom6, v)) {
                return "@SP2";
            }
            if (SmilesStereo.checkStereochemistryAll(false, atom0, chiralClass, 3, atom1, atom2, atom3, atom4, atom5, atom6, v)) {
                return "@SP3";
            }
        } else {
            return SmilesStereo.checkStereochemistryAll(false, atom0, chiralClass, 1, atom1, atom2, atom3, atom4, atom5, atom6, v) ? "@" : "@@";
        }
        return "";
    }

    private static boolean checkStereochemistryAll(boolean isNot, SimpleNode atom0, int chiralClass, int order, SimpleNode atom1, SimpleNode atom2, SimpleNode atom3, SimpleNode atom4, SimpleNode atom5, SimpleNode atom6, VTemp v) {
        switch (chiralClass) {
            default: {
                return true;
            }
            case 2: 
            case 4: {
                return isNot == (SmilesStereo.getHandedness(atom2, atom3, atom4, atom1, v) != order);
            }
            case 7: {
                SmilesStereo.getPlaneNormals((P3)((Object)atom1), (P3)((Object)atom2), (P3)((Object)atom3), (P3)((Object)atom4), v);
                return v.vNorm2.dot(v.vNorm3) < 0.0f ? isNot == (order != 3) : (v.vNorm3.dot(v.vNorm4) < 0.0f ? isNot == (order != 2) : isNot == (order != 1));
            }
            case 3: {
                return isNot == (SmilesStereo.getHandedness(atom1, atom2, atom3, atom0, v) != order);
            }
            case 5: {
                if (!SmilesStereo.isDiaxial(atom0, atom0, atom5, atom1, v, -0.95f)) {
                    return false;
                }
                return isNot == (SmilesStereo.getHandedness(atom2, atom3, atom4, atom1, v) != order);
            }
            case 8: {
                switch (order) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        atom3 = atom2;
                        break;
                    }
                    case 3: {
                        atom1 = atom2;
                    }
                }
                return isNot == !SmilesStereo.isDiaxial(atom0, atom0, atom1, atom3, v, -0.95f);
            }
            case 9: {
                if (!SmilesStereo.isDiaxial(atom0, atom0, atom4, atom1, v, -0.95f)) {
                    return false;
                }
                return isNot == (SmilesStereo.getHandedness(atom2, atom3, atom4, atom1, v) != order);
            }
            case 6: {
                if (!(SmilesStereo.isDiaxial(atom0, atom0, atom6, atom1, v, -0.95f) && SmilesStereo.isDiaxial(atom0, atom0, atom2, atom4, v, -0.95f) && SmilesStereo.isDiaxial(atom0, atom0, atom3, atom5, v, -0.95f))) {
                    return false;
                }
                SmilesStereo.getPlaneNormals((P3)((Object)atom2), (P3)((Object)atom3), (P3)((Object)atom4), (P3)((Object)atom5), v);
                if (v.vNorm2.dot(v.vNorm3) < 0.0f || v.vNorm3.dot(v.vNorm4) < 0.0f) {
                    return false;
                }
                v.vNorm3.sub2((P3)((Object)atom0), (P3)((Object)atom1));
                return isNot == ((v.vNorm2.dot(v.vNorm3) < 0.0f ? 2 : 1) == order);
            }
            case 1: 
        }
        return true;
    }

    static boolean isDiaxial(SimpleNode atomA, SimpleNode atomB, SimpleNode atom1, SimpleNode atom2, VTemp v, float f) {
        v.vA.sub2((P3)((Object)atomA), (P3)((Object)atom1));
        v.vB.sub2((P3)((Object)atomB), (P3)((Object)atom2));
        v.vA.normalize();
        v.vB.normalize();
        return v.vA.dot(v.vB) < f;
    }

    static int getHandedness(SimpleNode a, SimpleNode b, SimpleNode c, SimpleNode pt, VTemp v) {
        float d = Measure.getNormalThroughPoints((P3)((Object)a), (P3)((Object)b), (P3)((Object)c), v.vTemp, v.vA);
        return (d = Measure.distanceToPlaneV(v.vTemp, d, (P3)((Object)pt))) > 0.0f ? 1 : 2;
    }

    private static void getPlaneNormals(P3 atom1, P3 atom2, P3 atom3, P3 atom4, VTemp v) {
        Measure.getNormalThroughPoints(atom1, atom2, atom3, v.vNorm2, v.vTemp1);
        Measure.getNormalThroughPoints(atom2, atom3, atom4, v.vNorm3, v.vTemp1);
        Measure.getNormalThroughPoints(atom3, atom4, atom1, v.vNorm4, v.vTemp1);
    }

    static int checkChirality(SmilesSearch search, String pattern, int index, SmilesAtom newAtom) throws InvalidSmilesException {
        int stereoClass = 0;
        int order = Integer.MIN_VALUE;
        int len = pattern.length();
        String details = null;
        String directives = null;
        int atomCount = 0;
        stereoClass = 0;
        order = 1;
        boolean isPoly = false;
        if (++index < len) {
            char ch = pattern.charAt(index);
            switch (ch) {
                case '@': {
                    order = 2;
                    ++index;
                    break;
                }
                case '+': 
                case '-': 
                case 'H': {
                    break;
                }
                case 'P': {
                    isPoly = true;
                }
                case 'A': 
                case 'O': 
                case 'S': 
                case 'T': {
                    stereoClass = index + 1 < len ? SmilesStereo.getChiralityClass(pattern.substring(index, index + 2)) : -1;
                    index += 2;
                    break;
                }
                default: {
                    order = PT.isDigit(ch) ? 1 : -1;
                }
            }
            if (order == 1 || isPoly) {
                int pt;
                for (pt = index; pt < len && PT.isDigit(pattern.charAt(pt)); ++pt) {
                }
                if (pt > index) {
                    try {
                        int n = Integer.parseInt(pattern.substring(index, pt));
                        if (isPoly) {
                            atomCount = n;
                            if (pt < len && pattern.charAt(pt) == '(') {
                                details = SmilesParser.getSubPattern(pattern, pt, '(');
                                pt += details.length() + 2;
                            } else if (pt < len && pattern.charAt(pt) == '@') {
                                details = "@";
                                ++pt;
                            }
                            if (pt < len && pattern.charAt(pt) == '/') {
                                directives = SmilesParser.getSubPattern(pattern, pt, '/');
                                pt += directives.length() + 2;
                            }
                        } else {
                            order = n;
                        }
                    }
                    catch (NumberFormatException e) {
                        order = -1;
                    }
                    index = pt;
                }
            }
            if (order < 1 || stereoClass < 0) {
                throw new InvalidSmilesException("Invalid stereochemistry descriptor");
            }
        }
        newAtom.stereo = new SmilesStereo(stereoClass, order, atomCount, details, directives);
        if (stereoClass == 1) {
            search.polyAtom = newAtom;
            search.noAromatic = true;
        }
        newAtom.stereo.search = search;
        if (SmilesParser.getChar(pattern, index) == '?') {
            Logger.info("Ignoring '?' in stereochemistry");
            ++index;
        }
        return index;
    }

    private void getPolyhedralOrders() throws InvalidSmilesException {
        this.polyhedralOrders = AU.newInt2(this.atomCount);
        int[][] po = this.polyhedralOrders;
        if (this.details == null) {
            return;
        }
        if (this.details.length() > 0 && this.details.charAt(0) == '@') {
            this.details = "!" + this.details.substring(1);
        }
        if (this.details.length() == 0 || this.details.equals("!")) {
            for (int i = 2; i <= this.atomCount; ++i) {
                this.details = this.details + (i < 10 ? "" + i : "%" + i);
            }
        }
        int[] temp = new int[this.details.length()];
        int[] ret = new int[1];
        String msg = null;
        int pt = 0;
        String s = this.details + "/";
        int n = 0;
        int len = s.length();
        int index = 0;
        int atomPt = 0;
        do {
            char ch = s.charAt(index);
            switch (ch) {
                case '!': {
                    this.isNot = true;
                    ++index;
                    break;
                }
                case '.': 
                case '/': {
                    pt = atomPt;
                    if (pt >= this.atomCount) {
                        msg = "Too many descriptors";
                        break;
                    }
                    po[atomPt] = new int[n];
                    int[] a = po[atomPt];
                    while (--n >= 0) {
                        a[n] = temp[n];
                    }
                    n = 0;
                    if (Logger.debugging) {
                        Logger.info(PT.toJSON("@PH" + this.atomCount + "[" + atomPt + "]", a));
                    }
                    index = ch == '/' ? Integer.MAX_VALUE : ++index;
                    ++atomPt;
                    break;
                }
                default: {
                    index = SmilesParser.getRingNumber(s, index, ch, ret);
                    int n2 = n++;
                    int n3 = ret[0] - 1;
                    temp[n2] = n3;
                    pt = n3;
                    if (pt == atomPt) {
                        msg = "Atom cannot connect to itself";
                        break;
                    }
                    if (pt < 0 || pt >= this.atomCount) {
                        msg = "Connection number outside of range (1-" + this.atomCount + ")";
                        break;
                    }
                    if (n < this.atomCount) break;
                    msg = "Too many connections indicated";
                }
            }
            if (msg == null) continue;
            msg = msg + ": " + s.substring(0, index) + "<<";
            throw new InvalidSmilesException(msg);
        } while (index < len);
    }

    public static int getAtropicStereoFlag(Node[] nodes) {
        return Measure.computeTorsion((T3)((Object)nodes[0]), (T3)((Object)nodes[1]), (T3)((Object)nodes[2]), (T3)((Object)nodes[3]), true) < 0.0f ? 1 : -1;
    }
}

