/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.ic;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.backend.js.SerializedMapping;
import org.jetbrains.kotlin.ir.backend.js.SerializedMappings;
import org.jetbrains.kotlin.ir.backend.js.ic.SerializedIcData;
import org.jetbrains.kotlin.ir.backend.js.ic.SerializedIcDataForFile;
import org.jetbrains.kotlin.ir.backend.js.ic.SerializedOrder;
import org.jetbrains.kotlin.ir.serialization.SerializedCarriers;
import org.jetbrains.kotlin.library.SerializedIrFile;
import org.jetbrains.kotlin.library.impl.IrArrayMemoryReader;
import org.jetbrains.kotlin.library.impl.IrFileReadersKt;
import org.jetbrains.kotlin.library.impl.IrMemoryArrayWriter;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0007H\u0002\u001a\n\u0010\b\u001a\u00020\t*\u00020\u0001\u001a\n\u0010\n\u001a\u00020\u000b*\u00020\u0001\u001a\f\u0010\f\u001a\u00020\u0006*\u00020\u0007H\u0002\u001a\u0012\u0010\r\u001a\u00020\u000e*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u0012\u0010\u000f\u001a\u00020\u000e*\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0001\u00a8\u0006\u0011"}, d2={"newFile", "Ljava/io/File;", "fileDir", "name", "", "keyBytes", "", "Lorg/jetbrains/kotlin/ir/backend/js/SerializedMappings;", "readIcData", "Lorg/jetbrains/kotlin/ir/backend/js/ic/SerializedIcData;", "readIcDataBinary", "Lorg/jetbrains/kotlin/ir/backend/js/ic/SerializedIcDataForFile;", "valueBytes", "writeData", "", "writeTo", "dir", "ir.serialization.js"})
public final class DataKt {
    @NotNull
    public static final File newFile(@NotNull File fileDir, @NotNull String name) {
        Intrinsics.checkNotNullParameter(fileDir, "fileDir");
        Intrinsics.checkNotNullParameter(name, "name");
        File f = new File(fileDir, name);
        if (f.exists()) {
            f.delete();
        }
        return f;
    }

    public static final void writeData(@NotNull SerializedIcDataForFile $this$writeData, @NotNull File fileDir) {
        Intrinsics.checkNotNullParameter($this$writeData, "<this>");
        Intrinsics.checkNotNullParameter(fileDir, "fileDir");
        FilesKt.writeBytes(DataKt.newFile(fileDir, "file.fileData"), $this$writeData.getFile().getFileData());
        File file2 = DataKt.newFile(fileDir, "file.path");
        byte[] byArray = $this$writeData.getFile().getPath().getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "this as java.lang.String).getBytes(charset)");
        FilesKt.writeBytes(file2, byArray);
        FilesKt.writeBytes(DataKt.newFile(fileDir, "file.declarations"), $this$writeData.getFile().getDeclarations());
        FilesKt.writeBytes(DataKt.newFile(fileDir, "file.types"), $this$writeData.getFile().getTypes());
        FilesKt.writeBytes(DataKt.newFile(fileDir, "file.signatures"), $this$writeData.getFile().getSignatures());
        FilesKt.writeBytes(DataKt.newFile(fileDir, "file.strings"), $this$writeData.getFile().getStrings());
        FilesKt.writeBytes(DataKt.newFile(fileDir, "file.bodies"), $this$writeData.getFile().getBodies());
        FilesKt.writeBytes(DataKt.newFile(fileDir, "carriers.signatures"), $this$writeData.getCarriers().getSignatures());
        FilesKt.writeBytes(DataKt.newFile(fileDir, "carriers.declarationCarriers"), $this$writeData.getCarriers().getDeclarationCarriers());
        FilesKt.writeBytes(DataKt.newFile(fileDir, "carriers.bodyCarriers"), $this$writeData.getCarriers().getBodyCarriers());
        FilesKt.writeBytes(DataKt.newFile(fileDir, "carriers.removedOn"), $this$writeData.getCarriers().getRemovedOn());
        FilesKt.writeBytes(DataKt.newFile(fileDir, "mappings.keys"), DataKt.keyBytes($this$writeData.getMappings()));
        FilesKt.writeBytes(DataKt.newFile(fileDir, "mappings.values"), DataKt.valueBytes($this$writeData.getMappings()));
        FilesKt.writeBytes(DataKt.newFile(fileDir, "order.topLevelSignatures"), $this$writeData.getOrder().getTopLevelSignatures());
        FilesKt.writeBytes(DataKt.newFile(fileDir, "order.containerSignatures"), $this$writeData.getOrder().getContainerSignatures());
        FilesKt.writeBytes(DataKt.newFile(fileDir, "order.declarationSignatures"), $this$writeData.getOrder().getDeclarationSignatures());
    }

    public static final void writeTo(@NotNull SerializedIcData $this$writeTo, @NotNull File dir) {
        Intrinsics.checkNotNullParameter($this$writeTo, "<this>");
        Intrinsics.checkNotNullParameter(dir, "dir");
        if (!dir.exists()) {
            throw new IllegalStateException(("Directory doesn't exist: " + dir.getAbsolutePath()).toString());
        }
        if (!dir.isDirectory()) {
            throw new IllegalStateException(("Not a directory: " + dir.getAbsolutePath()).toString());
        }
        Iterable $this$forEach$iv = $this$writeTo.getFiles();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String fileId;
            SerializedIcDataForFile it = (SerializedIcDataForFile)element$iv;
            boolean bl = false;
            String fqnPath = it.getFile().getFqName();
            Intrinsics.checkNotNullExpressionValue(Integer.toString(it.getFile().getPath().hashCode(), CharsKt.checkRadix(36)), "toString(this, checkRadix(radix))");
            String irFileDirectory = "ic-" + fqnPath + '.' + fileId + ".file";
            File fileDir = new File(dir, irFileDirectory);
            if (!fileDir.exists() && !fileDir.mkdirs()) {
                throw new IllegalStateException(("Failed to create output dir for file " + fileDir.getAbsolutePath()).toString());
            }
            DataKt.writeData(it, fileDir);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final byte[] keyBytes(SerializedMappings $this$keyBytes) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$keyBytes.getMappings();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SerializedMapping serializedMapping = (SerializedMapping)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getKeys());
        }
        List list2 = (List)destination$iv$iv;
        return new IrMemoryArrayWriter(list2).writeIntoMemory();
    }

    /*
     * WARNING - void declaration
     */
    private static final byte[] valueBytes(SerializedMappings $this$valueBytes) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$valueBytes.getMappings();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SerializedMapping serializedMapping = (SerializedMapping)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getValues());
        }
        List list2 = (List)destination$iv$iv;
        return new IrMemoryArrayWriter(list2).writeIntoMemory();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SerializedIcDataForFile readIcDataBinary(@NotNull File $this$readIcDataBinary) {
        void $this$mapTo$iv$iv;
        boolean bl;
        Intrinsics.checkNotNullParameter($this$readIcDataBinary, "<this>");
        byte[] byArray = FilesKt.readBytes(new File($this$readIcDataBinary, "file.fileData"));
        String string2 = $this$readIcDataBinary.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "name");
        char[] cArray = new char[]{'.'};
        SerializedIrFile file2 = new SerializedIrFile(byArray, CollectionsKt.joinToString$default(CollectionsKt.dropLast(StringsKt.split$default((CharSequence)string2, cArray, false, 0, 6, null), 2), ".", null, null, 0, null, null, 62, null), new String(FilesKt.readBytes(new File($this$readIcDataBinary, "file.path")), Charsets.UTF_8), FilesKt.readBytes(new File($this$readIcDataBinary, "file.types")), FilesKt.readBytes(new File($this$readIcDataBinary, "file.signatures")), FilesKt.readBytes(new File($this$readIcDataBinary, "file.strings")), FilesKt.readBytes(new File($this$readIcDataBinary, "file.bodies")), FilesKt.readBytes(new File($this$readIcDataBinary, "file.declarations")), null);
        SerializedCarriers carriers = new SerializedCarriers(FilesKt.readBytes(new File($this$readIcDataBinary, "carriers.signatures")), FilesKt.readBytes(new File($this$readIcDataBinary, "carriers.declarationCarriers")), FilesKt.readBytes(new File($this$readIcDataBinary, "carriers.bodyCarriers")), FilesKt.readBytes(new File($this$readIcDataBinary, "carriers.removedOn")));
        byte[][] mappingKeys = IrFileReadersKt.toArray(new IrArrayMemoryReader(FilesKt.readBytes(new File($this$readIcDataBinary, "mappings.keys"))));
        byte[][] mappingValues = IrFileReadersKt.toArray(new IrArrayMemoryReader(FilesKt.readBytes(new File($this$readIcDataBinary, "mappings.values"))));
        boolean bl2 = bl = ((Object[])mappingKeys).length == ((Object[])mappingValues).length;
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        Iterable $this$map$iv = ArraysKt.zip((Object[])mappingKeys, (Object[])mappingValues);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            byte[] k = (byte[])pair.component1();
            byte[] v = (byte[])pair.component2();
            collection.add(new SerializedMapping(k, v));
        }
        List list2 = (List)destination$iv$iv;
        SerializedMappings mappings = new SerializedMappings(list2);
        SerializedOrder order2 = new SerializedOrder(FilesKt.readBytes(new File($this$readIcDataBinary, "order.topLevelSignatures")), FilesKt.readBytes(new File($this$readIcDataBinary, "order.containerSignatures")), FilesKt.readBytes(new File($this$readIcDataBinary, "order.declarationSignatures")));
        return new SerializedIcDataForFile(file2, carriers, mappings, order2);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final SerializedIcData readIcData(@NotNull File $this$readIcData) {
        Intrinsics.checkNotNullParameter($this$readIcData, "<this>");
        if (!$this$readIcData.isDirectory()) {
            throw new IllegalStateException(("Directory doesn't exist: " + $this$readIcData.getAbsolutePath()).toString());
        }
        v0 = $this$readIcData.listFiles();
        Intrinsics.checkNotNull(v0);
        $this$filter$iv = v0;
        $i$f$filter = false;
        var3_3 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (File element$iv$iv : $this$filterTo$iv$iv) {
            it = element$iv$iv;
            $i$a$-filter-DataKt$readIcData$1 = false;
            if (!it.isDirectory()) ** GOTO lbl-1000
            v1 = it.getName();
            Intrinsics.checkNotNullExpressionValue(v1, "it.name");
            if (StringsKt.startsWith$default(v1, "ic-", false, 2, null)) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            if (!v2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            element$iv$iv = (File)item$iv$iv;
            var11_14 = destination$iv$iv;
            $i$a$-map-DataKt$readIcData$2 = false;
            Intrinsics.checkNotNullExpressionValue(fileDir, "fileDir");
            var11_14.add(DataKt.readIcDataBinary((File)fileDir));
        }
        var12_15 = (List)destination$iv$iv;
        return new SerializedIcData(var12_15);
    }
}

