/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dependency.perceptron.parser;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.corpus.dependency.CoNll.CoNLLSentence;
import com.hankcs.hanlp.corpus.dependency.CoNll.CoNLLWord;
import com.hankcs.hanlp.dependency.AbstractDependencyParser;
import com.hankcs.hanlp.dependency.perceptron.accessories.Evaluator;
import com.hankcs.hanlp.dependency.perceptron.accessories.Options;
import com.hankcs.hanlp.dependency.perceptron.parser.Main;
import com.hankcs.hanlp.dependency.perceptron.transition.configuration.Configuration;
import com.hankcs.hanlp.dependency.perceptron.transition.parser.KBeamArcEagerParser;
import com.hankcs.hanlp.model.perceptron.PerceptronLexicalAnalyzer;
import com.hankcs.hanlp.seg.Segment;
import com.hankcs.hanlp.seg.common.Term;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutionException;

public class KBeamArcEagerDependencyParser
extends AbstractDependencyParser {
    KBeamArcEagerParser parser;

    public KBeamArcEagerDependencyParser() throws IOException, ClassNotFoundException {
        this(HanLP.Config.PerceptronParserModelPath);
    }

    public KBeamArcEagerDependencyParser(Segment segment, KBeamArcEagerParser parser) {
        super(segment);
        this.parser = parser;
    }

    public KBeamArcEagerDependencyParser(KBeamArcEagerParser parser) {
        this.parser = parser;
    }

    public KBeamArcEagerDependencyParser(String modelPath) throws IOException, ClassNotFoundException {
        this(modelPath, HanLP.Config.PerceptronCWSModelPath, HanLP.Config.PerceptronPOSModelPath.replaceFirst("data/model/.*?.bin", "data/model/perceptron/ctb/pos.bin"));
    }

    public KBeamArcEagerDependencyParser(String modelPath, String cwsModelPath, String posModelPath) throws IOException, ClassNotFoundException {
        this(new PerceptronLexicalAnalyzer(cwsModelPath, posModelPath).enableCustomDictionary(false), new KBeamArcEagerParser(modelPath));
    }

    public static KBeamArcEagerDependencyParser train(String trainCorpus, String devCorpus, String clusterPath, String modelPath) throws InterruptedException, ExecutionException, IOException, ClassNotFoundException {
        Options options = new Options();
        options.train = true;
        options.inputFile = trainCorpus;
        options.devPath = devCorpus;
        options.clusterFile = clusterPath;
        options.modelFile = modelPath;
        Main.train(options);
        return new KBeamArcEagerDependencyParser(modelPath);
    }

    public double[] evaluate(String testCorpus) throws IOException, ExecutionException, InterruptedException {
        Options options = this.parser.options;
        options.goldFile = testCorpus;
        File tmpTemplate = File.createTempFile("pred-" + new Date().getTime(), ".conll");
        tmpTemplate.deleteOnExit();
        options.outputFile = options.predFile = tmpTemplate.getAbsolutePath();
        File scoreFile = File.createTempFile("score-" + new Date().getTime(), ".txt");
        scoreFile.deleteOnExit();
        this.parser.parseConllFile(testCorpus, options.outputFile, options.rootFirst, options.beamWidth, true, options.lowercase, 1, false, scoreFile.getAbsolutePath());
        return Evaluator.evaluate(options.goldFile, options.predFile, options.punctuations);
    }

    @Override
    public CoNLLSentence parse(List<Term> termList) {
        return this.parse(termList, 64, 1);
    }

    public CoNLLSentence parse(List<Term> termList, int beamWidth, int numOfThreads) {
        int i;
        Configuration bestParse;
        String[] words = new String[termList.size()];
        String[] tags = new String[termList.size()];
        int k = 0;
        for (Term term : termList) {
            words[k] = term.word;
            tags[k] = term.nature.toString();
            ++k;
        }
        try {
            bestParse = this.parser.parse(words, tags, false, beamWidth, numOfThreads);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        CoNLLWord[] wordArray = new CoNLLWord[termList.size()];
        for (i = 0; i < words.length; ++i) {
            wordArray[i] = new CoNLLWord(i + 1, words[i], tags[i]);
        }
        for (i = 0; i < words.length; ++i) {
            wordArray[i].DEPREL = this.parser.idWord(bestParse.state.getDependent(i + 1));
            int index = bestParse.state.getHead(i + 1) - 1;
            wordArray[i].HEAD = index < 0 || index >= wordArray.length ? CoNLLWord.ROOT : wordArray[index];
        }
        return new CoNLLSentence(wordArray);
    }
}

