/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dictionary.ts;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.collection.AhoCorasick.AhoCorasickDoubleArrayTrie;
import com.hankcs.hanlp.dictionary.ts.BaseChineseDictionary;
import com.hankcs.hanlp.utility.Predefine;
import java.util.TreeMap;

public class TraditionalToTaiwanChineseDictionary
extends BaseChineseDictionary {
    static AhoCorasickDoubleArrayTrie<String> trie = new AhoCorasickDoubleArrayTrie();

    public static String convertToTaiwanChinese(String traditionalTaiwanChineseString) {
        return TraditionalToTaiwanChineseDictionary.segLongest(traditionalTaiwanChineseString.toCharArray(), trie);
    }

    public static String convertToTaiwanChinese(char[] traditionalTaiwanChineseString) {
        return TraditionalToTaiwanChineseDictionary.segLongest(traditionalTaiwanChineseString, trie);
    }

    static {
        long start = System.currentTimeMillis();
        String datPath = HanLP.Config.tcDictionaryRoot + "t2tw";
        if (!TraditionalToTaiwanChineseDictionary.loadDat(datPath, trie)) {
            TreeMap<String, String> t2tw = new TreeMap<String, String>();
            if (!TraditionalToTaiwanChineseDictionary.load(t2tw, false, HanLP.Config.tcDictionaryRoot + "t2tw.txt")) {
                throw new IllegalArgumentException("\u7e41\u4f53\u8f6c\u53f0\u6e7e\u7e41\u4f53\u52a0\u8f7d\u5931\u8d25");
            }
            trie.build(t2tw);
            TraditionalToTaiwanChineseDictionary.saveDat(datPath, trie, t2tw.entrySet());
        }
        Predefine.logger.info("\u7e41\u4f53\u8f6c\u53f0\u6e7e\u7e41\u4f53\u52a0\u8f7d\u6210\u529f\uff0c\u8017\u65f6" + (System.currentTimeMillis() - start) + "ms");
    }
}

