/*
 * Decompiled with CFR 0.152.
 */
package mediathek;

import com.google.common.base.Stopwatch;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Security;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.control.Alert;
import javafx.stage.Modality;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import jiconfont.icons.font_awesome.FontAwesome;
import jiconfont.swing.IconFontSwing;
import mediathek.SplashScreen;
import mediathek.config.Config;
import mediathek.config.Daten;
import mediathek.config.Konstanten;
import mediathek.config.MVConfig;
import mediathek.config.StandardLocations;
import mediathek.controller.history.SeenHistoryMigrator;
import mediathek.gui.dialog.DialogStarteinstellungen;
import mediathek.javafx.AustrianVlcCheck;
import mediathek.javafx.tool.JFXHiddenApplication;
import mediathek.javafx.tool.JavaFxUtils;
import mediathek.mac.MediathekGuiMac;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.DarkModeDetector;
import mediathek.tool.FileUtils;
import mediathek.tool.Functions;
import mediathek.tool.GuiFunktionenProgramme;
import mediathek.tool.Log4jShutdownCallbackRegistry;
import mediathek.tool.ReplaceList;
import mediathek.tool.RuntimeStatistics;
import mediathek.tool.SingleInstance;
import mediathek.tool.UIProgressState;
import mediathek.tool.affinity.Affinity;
import mediathek.tool.affinity.IAffinity;
import mediathek.tool.javafx.FXErrorDialog;
import mediathek.tool.migrator.SettingsMigrator;
import mediathek.tool.swing.SwingUIFontChanger;
import mediathek.tool.swing.ThreadCheckingRepaintManager;
import mediathek.windows.MediathekGuiWindows;
import mediathek.x11.MediathekGuiX11;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.AsyncAppender;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.filter.ThresholdFilter;
import org.apache.logging.log4j.core.layout.PatternLayout;
import picocli.CommandLine;

public class Main {
    private static final String MAC_SYSTEM_PROPERTY_APPLE_LAF_USE_SCREEN_MENU_BAR = "apple.laf.useScreenMenuBar";
    private static final Logger logger = LogManager.getLogger(Main.class);
    public static Optional<SplashScreen> splashScreen = Optional.empty();
    public static SingleInstance SINGLE_INSTANCE_WATCHER;

    private static void cleanupOsxFiles() {
        if (!Config.isPortableMode()) {
            try {
                Path oldFilmList = StandardLocations.getSettingsDirectory().resolve("filme.json");
                Files.deleteIfExists(oldFilmList);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void removeMediaDb() {
        try {
            Path mediaDbPath = StandardLocations.getSettingsDirectory().resolve("mediadb.txt");
            if (Files.exists(mediaDbPath, new LinkOption[0])) {
                logger.info("Moving old unsupported media database to trash.");
                FileUtils.moveToTrash(mediaDbPath);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void printJvmParameters() {
        logger.debug("=== JavaVM Parameter ===");
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        List<String> jvmArgs = runtimeMXBean.getInputArguments();
        for (String arg : jvmArgs) {
            logger.debug(arg);
        }
        logger.debug("========================");
    }

    private static void printArguments(String ... aArguments) {
        for (String argument : aArguments) {
            logger.info("Startparameter: {}", (Object)argument);
        }
    }

    private static void setupLogging() {
        LoggerContext loggerContext = (LoggerContext)LogManager.getContext(false);
        Configuration config = loggerContext.getConfiguration();
        String fileName = "/mediathekview.log";
        String path = !Config.isPortableMode() ? StandardLocations.getSettingsDirectory() + "/mediathekview.log" : Config.baseFilePath + "/mediathekview.log";
        PatternLayout consolePattern = Config.isEnhancedLoggingEnabled() || Config.isDebugModeEnabled() ? PatternLayout.newBuilder().withPattern("[%-5level] [%t] %c - %msg%n").build() : PatternLayout.newBuilder().withPattern(". %msg%n").build();
        ConsoleAppender consoleAppender = ConsoleAppender.createDefaultAppenderForLayout(consolePattern);
        if (!Config.isEnhancedLoggingEnabled() && !Config.isDebugModeEnabled()) {
            ThresholdFilter thresholdFilter = ThresholdFilter.createFilter(Level.INFO, Filter.Result.ACCEPT, Filter.Result.DENY);
            consoleAppender.addFilter(thresholdFilter);
        }
        consoleAppender.start();
        FileAppender.Builder fileAppenderBuilder = (FileAppender.Builder)((FileAppender.Builder)((AbstractAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((AbstractAppender.Builder)FileAppender.newBuilder()).setName("LogFile")).withAppend(false)).withFileName(path)).setLayout(PatternLayout.newBuilder().withPattern("%-5p %d  [%t] %C{2} (%F:%L) - %m%n").build())).setConfiguration(config);
        if (!Config.isEnhancedLoggingEnabled() && !Config.isDebugModeEnabled()) {
            ThresholdFilter thresholdFilter = ThresholdFilter.createFilter(Level.DEBUG, Filter.Result.ACCEPT, Filter.Result.DENY);
            fileAppenderBuilder.setFilter(thresholdFilter);
        }
        AsyncAppender asyncAppender = null;
        if (!Config.isFileLoggingDisabled()) {
            FileAppender fileAppender = fileAppenderBuilder.build();
            fileAppender.start();
            config.addAppender(fileAppender);
            asyncAppender = AsyncAppender.newBuilder().setName("Async").setAppenderRefs(new AppenderRef[]{AppenderRef.createAppenderRef(fileAppender.getName(), null, null)}).setConfiguration(config).setIncludeLocation(true).setBlocking(false).build();
            asyncAppender.start();
            config.addAppender(asyncAppender);
        }
        org.apache.logging.log4j.core.Logger rootLogger = loggerContext.getRootLogger();
        rootLogger.setLevel(Level.TRACE);
        rootLogger.addAppender(consoleAppender);
        if (!Config.isFileLoggingDisabled()) {
            rootLogger.addAppender(asyncAppender);
        }
        loggerContext.updateLoggers();
    }

    private static String queryNimbusLaFName() {
        String systemLaF = UIManager.getSystemLookAndFeelClassName();
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                systemLaF = info.getClassName();
                break;
            }
        }
        catch (Exception e) {
            systemLaF = UIManager.getSystemLookAndFeelClassName();
        }
        return systemLaF;
    }

    private static void setSystemLookAndFeel() {
        if (SystemUtils.IS_OS_MAC_OSX) {
            return;
        }
        String laf = System.getProperty("swing.defaultlaf");
        if (laf == null || laf.isEmpty()) {
            logger.trace("L&F property is empty, setting L&F");
            String systemLaF = UIManager.getSystemLookAndFeelClassName();
            if (SystemUtils.IS_OS_LINUX) {
                systemLaF = Main.queryNimbusLaFName();
            }
            try {
                UIManager.setLookAndFeel(systemLaF);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
                logger.error("L&F error: ", (Throwable)e);
            }
        }
    }

    private static void setupEnvironmentProperties() {
        System.setProperty("file.encoding", "UTF-8");
        Security.setProperty("crypto.policy", "unlimited");
    }

    private static void printVersionInformation() {
        logger.info("Programmstart: {}", (Object)DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(RuntimeStatistics.startZeit));
        logger.info("Version: {}", (Object)Konstanten.MVVERSION);
        logger.info("=== Java Information ===");
        logger.info("Vendor: {}", (Object)SystemUtils.JAVA_VENDOR);
        logger.info("VMname: {}", (Object)SystemUtils.JAVA_VM_NAME);
        logger.info("Version: {}", (Object)SystemUtils.JAVA_VERSION);
        logger.info("Runtime Version: {}", (Object)SystemUtils.JAVA_RUNTIME_VERSION);
        Runtime runtime = Runtime.getRuntime();
        logger.info("Maximum Memory: {} MB", (Object)(runtime.maxMemory() / 0x100000L));
        logger.info("Operating System: {}", (Object)SystemUtils.OS_NAME);
        logger.info("OS Version: {}", (Object)SystemUtils.OS_VERSION);
        logger.info("OS Arch: {}", (Object)SystemUtils.OS_ARCH);
        if (DarkModeDetector.hasDarkModeDetectionSupport()) {
            logger.info("OS Dark Mode enabled: {}", (Object)DarkModeDetector.isDarkMode());
        } else {
            logger.info("OS Dark Mode detection not supported");
        }
        logger.info("OS Available Processors: {}", (Object)runtime.availableProcessors());
    }

    private static void migrateOldConfigSettings() {
        String settingsDir = StandardLocations.getSettingsDirectory().toString();
        if (settingsDir != null && !settingsDir.isEmpty()) {
            Path pSettingsDir = Paths.get(settingsDir, new String[0]);
            if (Files.exists(pSettingsDir, new LinkOption[0])) {
                Path settingsFile = pSettingsDir.resolve("mediathek.xml");
                if (Files.exists(settingsFile, new LinkOption[0])) {
                    logger.trace("{} exists", (Object)"mediathek.xml");
                    logger.trace("migrating old config settings");
                    try {
                        SettingsMigrator migrator = new SettingsMigrator(settingsFile);
                        migrator.migrate();
                    }
                    catch (Exception e) {
                        logger.error("settings migration error", (Throwable)e);
                    }
                }
            } else {
                logger.trace("nothing to migrate");
            }
        }
    }

    private static void printPortableModeInfo() {
        if (Config.isPortableMode()) {
            logger.info("Configuring baseFilePath {} for portable mode", (Object)Config.baseFilePath);
        } else {
            logger.info("Configuring for non-portable mode");
        }
    }

    private static void setupCpuAffinity() {
        int numCpus = Config.getNumCpus();
        if (numCpus != 0) {
            IAffinity affinity = Affinity.getAffinityImpl();
            affinity.setDesiredCpuAffinity(numCpus);
        }
    }

    public static void main(String ... args2) {
        Main.setupEnvironmentProperties();
        if (GraphicsEnvironment.isHeadless()) {
            System.err.println("Diese Version von MediathekView unterst\u00fctzt keine Kommandozeilenausf\u00fchrung.");
            System.exit(1);
        }
        CommandLine cmd = new CommandLine(Config.class);
        try {
            CommandLine.ParseResult parseResult = cmd.parseArgs(args2);
            if (parseResult.isUsageHelpRequested()) {
                cmd.usage(System.out);
                System.exit(cmd.getCommandSpec().exitCodeOnUsageHelp());
            }
            Config.setPortableMode(parseResult.hasMatchedPositional(0));
            if (Config.isPortableMode()) {
                StandardLocations.INSTANCE.setPortableBaseDirectory(Config.baseFilePath);
            }
            Main.setupLogging();
            Main.printPortableModeInfo();
            Main.setupCpuAffinity();
            Main.initializeJavaFX();
            Main.removeMediaDb();
            JFXHiddenApplication.launchApplication();
            Main.checkMemoryRequirements();
            Main.installSingleInstanceHandler();
            Main.printVersionInformation();
            Main.printJvmParameters();
            Main.printArguments(args2);
        }
        catch (CommandLine.ParameterException ex) {
            try (PrintWriter err = cmd.getErr();){
                err.println(ex.getMessage());
                if (!CommandLine.UnmatchedArgumentException.printSuggestions(ex, err)) {
                    ex.getCommandLine().usage(err);
                }
                System.exit(cmd.getCommandSpec().exitCodeOnInvalidInput());
            }
        }
        catch (Exception ex) {
            logger.error("Command line parse error:", (Throwable)ex);
            System.exit(cmd.getCommandSpec().exitCodeOnExecutionException());
        }
        Main.printDirectoryPaths();
        Main.setSystemLookAndFeel();
        if (!Functions.isDebuggerAttached()) {
            splashScreen = Optional.of(new SplashScreen());
            splashScreen.ifPresent(SplashScreen::show);
        } else {
            logger.warn("Debugger detected -> Splash screen disabled...");
        }
        Main.migrateOldConfigSettings();
        IconFontSwing.register(FontAwesome.getIconFont());
        Main.loadConfigurationData();
        Main.migrateSeenHistory();
        Daten.getInstance().launchHistoryDataLoading();
        Daten.getInstance().loadBookMarkData();
        if (!SystemUtils.IS_OS_MAC_OSX) {
            Main.changeGlobalFontSize();
        }
        Main.startGuiMode();
    }

    private static void changeGlobalFontSize() {
        try {
            float size = ApplicationConfiguration.getConfiguration().getFloat("application.ui.font_size");
            logger.info("Custom font size found, changing global UI settings");
            SwingUIFontChanger fc = new SwingUIFontChanger();
            fc.changeFontSize(size);
        }
        catch (Exception e) {
            logger.info("No custom font size found.");
        }
    }

    private static void migrateSeenHistory() {
        try (SeenHistoryMigrator migrator = new SeenHistoryMigrator();){
            if (migrator.needsMigration()) {
                migrator.migrate();
            }
        }
        catch (Exception e) {
            logger.error("migrateSeenHistory", (Throwable)e);
            splashScreen.ifPresent(SplashScreen::close);
            FXErrorDialog.showErrorDialogWithoutParent("MediathekView", "Migration fehlgeschlagen", "Bei der Migration der Historie der Filme ist ein Fehler aufgetreten.\nDas Programm kann nicht fortfahren und wird beendet.\n\nBitte \u00fcberpr\u00fcfen Sie die Fehlermeldung und suchen Sie Hilfe im Forum.\n", e);
            System.exit(99);
        }
    }

    private static void initializeJavaFX() {
        Platform.setImplicitExit((boolean)false);
        JFXPanel dummy = new JFXPanel();
    }

    private static void loadConfigurationData() {
        Daten daten = Daten.getInstance();
        if (!daten.allesLaden()) {
            ReplaceList.init();
            splashScreen.ifPresent(SplashScreen::close);
            DialogStarteinstellungen dialog = new DialogStarteinstellungen(null);
            dialog.setVisible(true);
            if (dialog.getResultCode() == DialogStarteinstellungen.ResultCode.CANCELLED) {
                JavaFxUtils.invokeInFxThreadAndWait(() -> {
                    Alert alert = new Alert(Alert.AlertType.ERROR);
                    alert.setTitle("MediathekView");
                    alert.setHeaderText("Einrichtung des Programms abgebrochen");
                    alert.setContentText("Sie haben die Einrichtung des Programms abgebrochen.\nMediathekView muss deswegen beendet werden.");
                    alert.initModality(Modality.APPLICATION_MODAL);
                    alert.showAndWait();
                });
                try (Stream<Path> walk = Files.walk(StandardLocations.getSettingsDirectory(), new FileVisitOption[0]);){
                    walk.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                System.exit(1);
            }
            MVConfig.loadSystemParameter();
        }
    }

    private static void printDirectoryPaths() {
        logger.trace("Programmpfad: " + GuiFunktionenProgramme.getPathToApplicationJar());
        logger.info("Verzeichnis Einstellungen: " + StandardLocations.getSettingsDirectory());
    }

    private static void installSingleInstanceHandler() {
        SINGLE_INSTANCE_WATCHER = new SingleInstance();
        if (SINGLE_INSTANCE_WATCHER.isAppAlreadyActive()) {
            JavaFxUtils.invokeInFxThreadAndWait(() -> {
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("MediathekView");
                alert.setHeaderText("MediathekView wird bereits ausgef\u00fchrt");
                alert.setContentText("Es d\u00fcrfen nicht mehrere Programme gleichzeitig laufen.\nBitte beenden Sie die andere Instanz.");
                alert.initModality(Modality.APPLICATION_MODAL);
                alert.showAndWait();
            });
            System.exit(1);
        }
    }

    private static void checkForOfficialOSXAppUse() {
        String osxOfficialApp = System.getProperty("OSX_OFFICIAL_APP");
        if (osxOfficialApp == null || osxOfficialApp.isEmpty() || osxOfficialApp.equalsIgnoreCase("false")) {
            logger.warn("WARN: macOS app NOT launched from official launcher!");
        }
    }

    private static void checkMemoryRequirements() {
        long maxMem = Runtime.getRuntime().maxMemory();
        if (maxMem < 0x30000000L) {
            JavaFxUtils.invokeInFxThreadAndWait(() -> {
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("MediathekView");
                alert.setHeaderText("Nicht gen\u00fcgend Arbeitsspeicher");
                alert.setContentText("Es werden mindestens 768MB RAM f\u00fcr einen halbwegs vern\u00fcnftigen Betrieb ben\u00f6tigt.\n\nDas Programm wird nun beendet.");
                alert.showAndWait();
            });
            System.exit(3);
        }
    }

    private static void startGuiMode() {
        SwingUtilities.invokeLater(() -> {
            splashScreen.ifPresent(s2 -> s2.update(UIProgressState.INIT_FX));
            splashScreen.ifPresent(s2 -> s2.update(UIProgressState.FILE_CLEANUP));
            if (SystemUtils.IS_OS_MAC_OSX) {
                Main.checkForOfficialOSXAppUse();
                System.setProperty(MAC_SYSTEM_PROPERTY_APPLE_LAF_USE_SCREEN_MENU_BAR, Boolean.TRUE.toString());
                Main.cleanupOsxFiles();
            }
            if (Config.isDebugModeEnabled() || Config.isInstallThreadCheckingRepaintManager()) {
                RepaintManager.setCurrentManager(new ThreadCheckingRepaintManager());
                logger.info("Swing Thread checking repaint manager installed.");
            }
            splashScreen.ifPresent(s2 -> s2.update(UIProgressState.START_UI));
            MediathekGui window = Main.getPlatformWindow();
            splashScreen.ifPresent(SplashScreen::close);
            window.setVisible(true);
            if (SystemUtils.IS_OS_WINDOWS) {
                window.toFront();
                window.requestFocus();
            }
            AustrianVlcCheck vlcCheck = new AustrianVlcCheck();
            vlcCheck.perform();
        });
    }

    private static MediathekGui getPlatformWindow() {
        MediathekGui window;
        Stopwatch watch = Stopwatch.createStarted();
        if (SystemUtils.IS_OS_MAC_OSX) {
            window = new MediathekGuiMac();
        } else if (SystemUtils.IS_OS_WINDOWS) {
            window = new MediathekGuiWindows();
        } else if (SystemUtils.IS_OS_UNIX) {
            window = new MediathekGuiX11();
        } else {
            throw new IllegalStateException("Unknown operating system detected! Cannot create main window");
        }
        watch.stop();
        logger.trace("getPlatformWindow(): {}", (Object)watch);
        return window;
    }

    static {
        System.setProperty("log4j.shutdownCallbackRegistry", Log4jShutdownCallbackRegistry.class.getName());
    }
}

