/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.javafx;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.Modality;
import javafx.stage.Window;
import mediathek.javafx.tool.JFXHiddenApplication;
import mediathek.javafx.tool.JavaFxUtils;
import mediathek.mainwindow.MediathekGui;
import org.jetbrains.annotations.NotNull;

public class FXErrorDialog {
    private static GridPane createExceptionPanel(@NotNull Exception ex) throws IOException {
        GridPane expContent = new GridPane();
        try (StringWriter sw = new StringWriter();
             PrintWriter pw = new PrintWriter(sw);){
            ex.printStackTrace(pw);
            String exceptionText = sw.toString();
            Label label = new Label("Stacktrace:");
            TextArea textArea = new TextArea(exceptionText);
            textArea.setEditable(false);
            textArea.setWrapText(true);
            textArea.setMaxWidth(Double.MAX_VALUE);
            textArea.setMaxHeight(Double.MAX_VALUE);
            GridPane.setVgrow((Node)textArea, (Priority)Priority.ALWAYS);
            GridPane.setHgrow((Node)textArea, (Priority)Priority.ALWAYS);
            expContent.setMaxWidth(Double.MAX_VALUE);
            expContent.add((Node)label, 0, 0);
            expContent.add((Node)textArea, 0, 1);
        }
        return expContent;
    }

    private static Alert getBaseAlert(@NotNull String title, @NotNull String header, @NotNull String detailedErrorMessage) {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle(title);
        alert.setHeaderText(header);
        alert.setContentText(detailedErrorMessage);
        alert.initModality(Modality.APPLICATION_MODAL);
        return alert;
    }

    private static void createExceptionContent(@NotNull Alert alert, @NotNull Exception ex) {
        try {
            GridPane content = FXErrorDialog.createExceptionPanel(ex);
            alert.getDialogPane().setExpandableContent((Node)content);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void showErrorDialog(String title, String header, String detailedErrorMessage, @NotNull Exception ex) {
        Alert alert = FXErrorDialog.getBaseAlert(title, header, detailedErrorMessage);
        FXErrorDialog.createExceptionContent(alert, ex);
        alert.initOwner((Window)JFXHiddenApplication.getPrimaryStage());
        JFXHiddenApplication.showAlert(alert, MediathekGui.ui());
    }

    public static void showErrorDialogWithoutParent(String title, String header, String detailedErrorMessage, @NotNull Exception ex) {
        JavaFxUtils.invokeInFxThreadAndWait(() -> {
            Alert alert = FXErrorDialog.getBaseAlert(title, header, detailedErrorMessage);
            FXErrorDialog.createExceptionContent(alert, ex);
            alert.showAndWait();
        });
    }
}

