/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.tableview2.cell;

import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.ComboBoxTableCell;
import javafx.scene.input.KeyEvent;
import javafx.util.Callback;
import javafx.util.StringConverter;

public class ComboBox2TableCell<S, T>
extends ComboBoxTableCell<S, T> {
    private ComboBox<T> comboBox;
    private final EventHandler<KeyEvent> keyEventHandler = event -> {
        TableView.TableViewSelectionModel selectionModel = this.getTableView().getSelectionModel();
        if (this.comboBox == null || event.getCode() == null || selectionModel == null) {
            return;
        }
        switch (event.getCode()) {
            case ESCAPE: {
                this.comboBox.getEditor().setText(this.getConverter().toString(this.getItem()));
                this.cancelEdit();
                event.consume();
                break;
            }
            case TAB: {
                this.cancelEdit();
                event.consume();
                if (selectionModel.isCellSelectionEnabled()) {
                    int columnIndex = this.getTableView().getVisibleLeafIndex(this.getTableColumn());
                    if (event.isShiftDown()) {
                        if (columnIndex > 0) {
                            selectionModel.clearAndSelect(this.getIndex(), this.getTableView().getVisibleLeafColumn(columnIndex - 1));
                            break;
                        }
                        if (this.getIndex() <= 0) break;
                        selectionModel.clearAndSelect(this.getIndex() - 1, this.getTableView().getVisibleLeafColumn(this.getTableView().getVisibleLeafColumns().size() - 1));
                        break;
                    }
                    if (columnIndex + 1 < this.getTableView().getVisibleLeafColumns().size()) {
                        selectionModel.clearAndSelect(this.getIndex(), this.getTableView().getVisibleLeafColumn(columnIndex + 1));
                        break;
                    }
                    if (this.getIndex() >= this.getTableView().getItems().size() - 1) break;
                    selectionModel.clearAndSelect(this.getIndex() + 1, this.getTableView().getVisibleLeafColumn(0));
                    break;
                }
                selectionModel.clearAndSelect(event.isShiftDown() ? this.getIndex() - 1 : this.getIndex() + 1);
                break;
            }
            case UP: {
                this.cancelEdit();
                event.consume();
                selectionModel.clearAndSelect(this.getIndex() - 1, this.getTableColumn());
                break;
            }
            case DOWN: {
                this.cancelEdit();
                event.consume();
                selectionModel.clearAndSelect(this.getIndex() + 1, this.getTableColumn());
                break;
            }
        }
    };
    private final ChangeListener<Boolean> focusListener = (obs, ov, nv) -> {
        if (!nv.booleanValue() && this.comboBox != null && this.getConverter() != null) {
            String text = this.comboBox.getEditor().getText();
            Object t = this.getConverter().fromString(text);
            this.commitEdit(t);
        }
    };

    @SafeVarargs
    public static <S, T> Callback<TableColumn<S, T>, TableCell<S, T>> forTableColumn(T ... items) {
        return ComboBox2TableCell.forTableColumn(null, items);
    }

    @SafeVarargs
    public static <S, T> Callback<TableColumn<S, T>, TableCell<S, T>> forTableColumn(StringConverter<T> converter, T ... items) {
        return ComboBox2TableCell.forTableColumn(converter, FXCollections.observableArrayList((Object[])items));
    }

    public static <S, T> Callback<TableColumn<S, T>, TableCell<S, T>> forTableColumn(ObservableList<T> items) {
        return ComboBox2TableCell.forTableColumn(null, items);
    }

    public static <S, T> Callback<TableColumn<S, T>, TableCell<S, T>> forTableColumn(StringConverter<T> converter, ObservableList<T> items) {
        return list -> new ComboBox2TableCell(converter, items);
    }

    public ComboBox2TableCell() {
        this(FXCollections.observableArrayList());
    }

    @SafeVarargs
    public ComboBox2TableCell(T ... items) {
        this(FXCollections.observableArrayList((Object[])items));
    }

    @SafeVarargs
    public ComboBox2TableCell(StringConverter<T> converter, T ... items) {
        this(converter, FXCollections.observableArrayList((Object[])items));
    }

    public ComboBox2TableCell(ObservableList<T> items) {
        this((StringConverter<T>)null, items);
    }

    public ComboBox2TableCell(StringConverter<T> converter, ObservableList<T> items) {
        super(converter, items);
        this.setComboBoxEditable(true);
        this.graphicProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable observable2) {
                if (ComboBox2TableCell.this.getGraphic() != null && ComboBox2TableCell.this.getGraphic() instanceof ComboBox) {
                    ComboBox2TableCell.this.comboBox = (ComboBox)ComboBox2TableCell.this.getGraphic();
                    ComboBox2TableCell.this.comboBox.editableProperty().addListener((obs, ov, nv) -> ComboBox2TableCell.this.updateListeners((boolean)nv));
                    ComboBox2TableCell.this.updateListeners(ComboBox2TableCell.this.comboBox.isEditable());
                    ComboBox2TableCell.this.graphicProperty().removeListener((InvalidationListener)this);
                }
            }
        });
    }

    public void commitEdit(T item) {
        TableView table;
        if (!this.isEditing() && !item.equals(this.getItem()) && (table = this.getTableView()) != null) {
            TableColumn column = this.getTableColumn();
            TableColumn.CellEditEvent event = new TableColumn.CellEditEvent(table, new TablePosition(table, this.getIndex(), column), TableColumn.editCommitEvent(), item);
            Event.fireEvent((EventTarget)column, (Event)event);
        }
        super.commitEdit(item);
    }

    private void updateListeners(boolean editable) {
        if (editable) {
            this.comboBox.getEditor().focusedProperty().addListener(this.focusListener);
            this.comboBox.addEventFilter(KeyEvent.KEY_PRESSED, this.keyEventHandler);
        } else {
            this.comboBox.getEditor().focusedProperty().removeListener(this.focusListener);
            this.comboBox.removeEventFilter(KeyEvent.KEY_PRESSED, this.keyEventHandler);
        }
    }
}

