/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.cucadiagram.BodyFactory;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.InnerStrategy;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.SvekNode;
import net.sourceforge.plantuml.svek.image.EntityImageNote;
import net.sourceforge.plantuml.svek.image.Opale;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class EntityImageTips
extends AbstractEntityImage {
    private final Rose rose = new Rose();
    private final ISkinParam skinParam;
    private final HColor noteBackgroundColor;
    private final HColor borderColor;
    private final Bibliotekon bibliotekon;
    private final Style style;
    private final double ySpacing = 10.0;

    public EntityImageTips(ILeaf entity, ISkinParam skinParam, Bibliotekon bibliotekon, UmlDiagramType type) {
        super(entity, EntityImageNote.getSkin(skinParam, entity));
        this.skinParam = skinParam;
        this.bibliotekon = bibliotekon;
        if (UseStyle.useBetaStyle()) {
            this.style = this.getDefaultStyleDefinition(type.getStyleName()).getMergedStyle(skinParam.getCurrentStyleBuilder());
            this.noteBackgroundColor = entity.getColors().getColor(ColorType.BACK) == null ? this.style.value(PName.BackGroundColor).asColor(skinParam.getThemeStyle(), skinParam.getIHtmlColorSet()) : entity.getColors().getColor(ColorType.BACK);
            this.borderColor = this.style.value(PName.LineColor).asColor(skinParam.getThemeStyle(), skinParam.getIHtmlColorSet());
        } else {
            this.style = null;
            this.noteBackgroundColor = entity.getColors().getColor(ColorType.BACK) == null ? this.rose.getHtmlColor(skinParam, ColorParam.noteBackground) : entity.getColors().getColor(ColorType.BACK);
            this.borderColor = this.rose.getHtmlColor(skinParam, ColorParam.noteBorder);
        }
    }

    private StyleSignatureBasic getDefaultStyleDefinition(SName sname) {
        return StyleSignatureBasic.of(SName.root, SName.element, sname, SName.note);
    }

    private Position getPosition() {
        if (this.getEntity().getCodeGetName().endsWith(Position.RIGHT.name())) {
            return Position.RIGHT;
        }
        return Position.LEFT;
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        double width = 0.0;
        double height = 0.0;
        for (Map.Entry<String, Display> ent : this.getEntity().getTips().entrySet()) {
            Display display = ent.getValue();
            Dimension2D dim = this.getOpale(display).calculateDimension(stringBounder);
            height += dim.getHeight();
            height += 10.0;
            width = Math.max(width, dim.getWidth());
        }
        return new Dimension2DDouble(width, height);
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        IEntity other = this.bibliotekon.getOnlyOther(this.getEntity());
        SvekNode nodeMe = this.bibliotekon.getNode(this.getEntity());
        SvekNode nodeOther = this.bibliotekon.getNode(other);
        Point2D positionMe = nodeMe.getPosition();
        if (nodeOther == null) {
            System.err.println("Error in EntityImageTips");
            return;
        }
        Point2D positionOther = nodeOther.getPosition();
        this.bibliotekon.getNode(this.getEntity());
        Position position = this.getPosition();
        Direction direction = position.reverseDirection();
        double height = 0.0;
        for (Map.Entry<String, Display> ent : this.getEntity().getTips().entrySet()) {
            Display display = ent.getValue();
            Rectangle2D memberPosition = nodeOther.getImage().getInnerPosition(ent.getKey(), stringBounder, InnerStrategy.STRICT);
            if (memberPosition == null) {
                return;
            }
            Opale opale = this.getOpale(display);
            Dimension2D dim = opale.calculateDimension(stringBounder);
            Point2D.Double pp1 = new Point2D.Double(0.0, dim.getHeight() / 2.0);
            double x = positionOther.getX() - positionMe.getX();
            if (direction == Direction.RIGHT && x < 0.0) {
                direction = direction.getInv();
            }
            x = direction == Direction.LEFT ? (x += memberPosition.getMaxX()) : (x += 4.0);
            double y = positionOther.getY() - positionMe.getY() - height + memberPosition.getCenterY();
            Point2D.Double pp2 = new Point2D.Double(x, y);
            opale.setOpale(direction, pp1, pp2);
            opale.drawU(ug);
            ug = ug.apply(UTranslate.dy(dim.getHeight() + 10.0));
            height += dim.getHeight();
            height += 10.0;
        }
    }

    private Opale getOpale(Display display) {
        FontConfiguration fc;
        double shadowing;
        UStroke stroke = new UStroke();
        if (UseStyle.useBetaStyle()) {
            shadowing = this.style.value(PName.Shadowing).asDouble();
            fc = this.style.getFontConfiguration(this.skinParam.getThemeStyle(), this.skinParam.getIHtmlColorSet());
            stroke = this.style.getStroke();
        } else {
            shadowing = this.skinParam.shadowing(this.getEntity().getStereotype()) ? 4.0 : 0.0;
            fc = FontConfiguration.create(this.skinParam, FontParam.NOTE, null);
        }
        TextBlock textBlock = BodyFactory.create3(display, FontParam.NOTE, this.skinParam, HorizontalAlignment.LEFT, fc, LineBreakStrategy.NONE, this.style);
        return new Opale(shadowing, this.borderColor, this.noteBackgroundColor, textBlock, true, stroke);
    }
}

