/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ugraphic.AbstractShadowable;
import net.sourceforge.plantuml.ugraphic.UShapeSized;

public class UEllipse
extends AbstractShadowable
implements UShapeSized {
    private final double width;
    private final double height;
    private final double start;
    private final double extend;

    public UEllipse(double width, double height) {
        this(width, height, 0.0, 0.0);
    }

    public UEllipse(double width, double height, double start, double extend) {
        this.width = width;
        this.height = height;
        this.start = start;
        this.extend = extend;
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    public final double getStart() {
        return this.start;
    }

    public final double getExtend() {
        return this.extend;
    }

    public Dimension2D getDimension() {
        return new Dimension2DDouble(this.width, this.height);
    }

    public UEllipse bigger(double more) {
        UEllipse result = new UEllipse(this.width + more, this.height + more);
        result.setDeltaShadow(this.getDeltaShadow());
        return result;
    }

    public UEllipse scale(double factor) {
        UEllipse result = new UEllipse(this.width * factor, this.height * factor);
        result.setDeltaShadow(this.getDeltaShadow());
        return result;
    }

    public double getStartingX(double y) {
        y = y / this.height * 2.0;
        double x = 1.0 - Math.sqrt(1.0 - (y - 1.0) * (y - 1.0));
        return x * this.width / 2.0;
    }

    public double getEndingX(double y) {
        y = y / this.height * 2.0;
        double x = 1.0 + Math.sqrt(1.0 - (y - 1.0) * (y - 1.0));
        return x * this.width / 2.0;
    }

    public Point2D getPointAtAngle(double alpha) {
        double x = this.width / 2.0 + this.width / 2.0 * Math.cos(alpha);
        double y = this.height / 2.0 + this.height / 2.0 * Math.sin(alpha);
        return new Point2D.Double(x, y);
    }
}

