/*
 * Decompiled with CFR 0.152.
 */
package org.protege.xmlcatalog.swing;

import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.tree.TreeNode;
import org.protege.xmlcatalog.XMLCatalog;
import org.protege.xmlcatalog.entry.Entry;
import org.protege.xmlcatalog.entry.NextCatalogEntry;
import org.protege.xmlcatalog.swing.EntryEditor;
import org.protege.xmlcatalog.swing.EntryTreeNode;

public class CatalogTreeNode
implements TreeNode {
    private TreeNode parent;
    private XMLCatalog catalog;
    private List<EntryEditor> editors;

    public CatalogTreeNode(XMLCatalog catalog, List<EntryEditor> editors) {
        this(null, catalog, editors);
    }

    public CatalogTreeNode(TreeNode parent, XMLCatalog catalog, List<EntryEditor> editors) {
        this.parent = parent;
        this.catalog = catalog;
        this.editors = editors;
    }

    public XMLCatalog getCatalog() {
        return this.catalog;
    }

    public List<EntryEditor> getEditors() {
        return this.editors;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        Entry e = this.catalog.getEntries().get(childIndex);
        return new EntryTreeNode(this, e, this.editors);
    }

    @Override
    public int getChildCount() {
        return this.catalog.getEntries().size();
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public int getIndex(TreeNode node) {
        if (this.parent instanceof EntryTreeNode && ((EntryTreeNode)this.parent).getEditor() instanceof NextCatalogEntry && this.parent.getChildAt(0) == this.catalog) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return this.catalog.getEntries().size() == 0;
    }

    public Enumeration<TreeNode> children() {
        return new Enumeration<TreeNode>(){
            int currentIndex = 0;

            @Override
            public boolean hasMoreElements() {
                return this.currentIndex < CatalogTreeNode.this.getChildCount();
            }

            @Override
            public TreeNode nextElement() throws NoSuchElementException {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException("No such element");
                }
                try {
                    TreeNode treeNode = CatalogTreeNode.this.getChildAt(this.currentIndex);
                    return treeNode;
                }
                finally {
                    ++this.currentIndex;
                }
            }
        };
    }
}

