# pyOCD debugger
# Copyright (c) 2021 Chris Reed
# SPDX-License-Identifier: Apache-2.0
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from ...core.memory_map import (FlashRegion, RamRegion, MemoryMap)
from ..family.target_nRF52 import NRF52
from ...debug.svd.loader import SVDFile

# Note: generated from nrf52xxx.flm from NordicSemiconductor.nRF_DeviceFamilyPack.8.38.0.pack
FLASH_ALGO_FLASH = {
    'load_address' : 0x20000000,

    # Flash algorithm as a hex string
    'instructions': [
    0xe00abe00,
    0x4614b5b0, 0x0504f240, 0x0500f2c0, 0xf8492000, 0xeb090005, 0xe9c10105, 0x60c80001, 0xf000b2d0,
    0x2800fa55, 0xeb09bf1e, 0xe9c10105, 0xbdb00402, 0x0005eb09, 0x60412101, 0xfa1ef000, 0xbdb02000,
    0x4604b510, 0xf0002000, 0xb138fa41, 0x0104f240, 0x0100f2c0, 0xe9c14449, 0xbd100402, 0x0004f240,
    0x0000f2c0, 0x0100eb09, 0x29006889, 0x2000bf04, 0xf244bd10, 0xf2c20100, 0x22010100, 0xf859600a,
    0x604a2000, 0x68424448, 0x6882608a, 0x68c060ca, 0x20006108, 0xbf00bd10, 0x0004f240, 0x0000f2c0,
    0xf8492101, 0x44481000, 0xe9c02100, 0x60c11101, 0xba4cf000, 0x4604b5b0, 0x0504f240, 0x0500f2c0,
    0xf8492002, 0xeb090005, 0x21000005, 0x1101e9c0, 0xf00060c1, 0xfbb4f99f, 0xfb01f1f0, 0xb1304010,
    0x0005eb09, 0xe9c02103, 0x20651402, 0xeb09bdb0, 0x21010005, 0xf0006041, 0x42a0f9a3, 0xf000d813,
    0x42a0f9a1, 0xeb09d90f, 0x21020005, 0x46206041, 0xf9c8f000, 0xbf1c2803, 0xbdb02067, 0xf0004620,
    0x2000f9ff, 0xeb09bdb0, 0x21040005, 0x1402e9c0, 0xbdb02066, 0x41f0e92d, 0x460e4615, 0xf2404604,
    0xf2c00704, 0x20030700, 0x0007f849, 0x0107eb09, 0xe9c12200, 0x60ca2201, 0xd00607a1, 0x0107eb09,
    0x0402e9c1, 0xe8bd2065, 0xeb0981f0, 0x21010007, 0xf0006041, 0x42a0f965, 0xf000d815, 0x42a0f963,
    0xeb09d911, 0x21030007, 0xeb066041, 0xf0000804, 0x4580f959, 0xeb09d90f, 0x21040007, 0x1802e9c0,
    0xe8bd2066, 0xeb0981f0, 0x21040007, 0x1402e9c0, 0xe8bd2066, 0xeb0981f0, 0x21040007, 0xf0006041,
    0xb130f96f, 0x0007eb09, 0x60812102, 0xe8bd2067, 0xeb0981f0, 0x21050007, 0x46206041, 0xf962f000,
    0xd2072802, 0x0007eb09, 0xe9c02102, 0x20671402, 0x81f0e8bd, 0x4620d10f, 0x22ff4631, 0xf834f000,
    0x2003b148, 0x0007f849, 0x0007eb09, 0x60412105, 0xe8bd2067, 0x200381f0, 0x0007f849, 0x0007eb09,
    0x60412106, 0xebb02000, 0xbf080f96, 0x81f0e8bd, 0x0896ea4f, 0xf8542600, 0x30010026, 0xf855d10b,
    0xf8440026, 0xf0000026, 0x3601f95b, 0x45462000, 0xe8bdd3f1, 0xeb0981f0, 0x19a10007, 0xe9c02205,
    0x20682102, 0x81f0e8bd, 0x41f0e92d, 0x460d4616, 0xf2404604, 0xf2c00704, 0x20050700, 0x0007f849,
    0x0007eb09, 0xe9c02100, 0x60c11101, 0xd00707a8, 0x0007eb09, 0xe9c02103, 0x20651502, 0x81f0e8bd,
    0x0007eb09, 0x60412102, 0xf8caf000, 0xd81542a0, 0xf8c8f000, 0xd91142a0, 0x0007eb09, 0x60412103,
    0x0804eb05, 0xf8bef000, 0xd90f4580, 0x0007eb09, 0xe9c02104, 0x20661802, 0x81f0e8bd, 0x0007eb09,
    0xe9c02104, 0x20661402, 0x81f0e8bd, 0x0007eb09, 0x60412104, 0xbf042d00, 0xe8bd2000, 0x210081f0,
    0xbf00e006, 0x20003101, 0xbf2842a9, 0x81f0e8bd, 0x42b05c60, 0xeb09d0f6, 0x44210007, 0xe9c02205,
    0x20012102, 0x81f0e8bd, 0x41f0e92d, 0x460f4690, 0xf2404604, 0xf2c00504, 0x20040500, 0x0005f849,
    0x0005eb09, 0xe9c02100, 0x60c11101, 0xd00807a0, 0x0005eb09, 0xe9c02103, 0x26651402, 0xe8bd4630,
    0xeb0981f0, 0x21010005, 0xf0006041, 0x42a0f869, 0xf000d812, 0x42a0f867, 0xeb09d90e, 0x21030005,
    0x193e6041, 0xf85ef000, 0xd90e4286, 0x0005eb09, 0xe9c02104, 0xe0041602, 0x0005eb09, 0xe9c02104,
    0x26661402, 0xe8bd4630, 0xeb0981f0, 0x21040005, 0x20006041, 0x0f97ebb0, 0x08b8d00b, 0xbf002100,
    0x2021f858, 0x42936823, 0x3101d10a, 0x42813404, 0xeb09d3f6, 0x21050005, 0x46306041, 0x81f0e8bd,
    0x0005eb09, 0xe9c02106, 0x46201402, 0x81f0e8bd, 0x1030f240, 0x0000f2c1, 0x31016801, 0x6800bf1c,
    0xf6404770, 0xf2cf70e0, 0x68410000, 0xf3617800, 0x4770200b, 0xf2c12010, 0x68010000, 0xbf143101,
    0xf44f6800, 0x47705080, 0xf2c12014, 0x68010000, 0xbf143101, 0xf44f6800, 0x47707000, 0x47702000,
    0x47702000, 0xf7ffb510, 0x4604ffe5, 0xffecf7ff, 0xbd104360, 0x42814401, 0x2001bf9c, 0xe0034770,
    0xbf244288, 0x47702001, 0x2b04f850, 0xbf1c3201, 0x47702000, 0xbf00e7f4, 0xf7ffb580, 0x280fffb9,
    0xbd80bf88, 0xfa012101, 0xf24cf000, 0x42104240, 0xf240bf1e, 0xf2c46008, 0x60010000, 0xbf00bd80,
    0x47702000, 0x0104f243, 0xf24e6809, 0xf2c552db, 0x429112b1, 0x2003bf1c, 0xf2434770, 0x680a0108,
    0x42822103, 0x2102bf88, 0x47704608, 0xbf842803, 0x47702069, 0xb240b580, 0xf851a105, 0xf24e0020,
    0xf2c45104, 0x60080101, 0xf80af000, 0xbd802000, 0x00000000, 0x00000002, 0x00000001, 0x00000000,
    0x4000f24e, 0x0001f2c4, 0x29006801, 0x4770d0fc, 0x500cf24e, 0x0001f2c4, 0x60012101, 0xbf00e7f0,
    0x9000b081, 0xf24e9800, 0xf2c45108, 0x60080101, 0xe7e5b001, 0xf24eb580, 0xf2c45014, 0x21010001,
    0xf7ff6001, 0x2000ffdd, 0xbf00bd80, 0xf7ffb570, 0x4604ff79, 0x20002500, 0xffa4f7ff, 0xd0052802,
    0x2601b938, 0x42a52500, 0xe00dd306, 0x0008f243, 0x26006805, 0xd20742a5, 0xf7ff4628, 0xf7ffffd1,
    0x4405ff49, 0xd3f742a5, 0xbf182e00, 0xffd2f7ff, 0xbd702000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000
    ],

    # Relative function addresses
    'pc_init': 0x20000005,
    'pc_unInit': 0x20000045,
    'pc_program_page': 0x20000139,
    'pc_erase_sector': 0x200000b9,
    'pc_eraseAll': 0x2000009d,

    'static_base' : 0x20000000 + 0x00000004 + 0x00000594,
    'begin_stack' : 0x200007a0,
    'begin_data' : 0x20000000 + 0x1000,
    'page_size' : 0x1000,
    'analyzer_supported' : False,
    'analyzer_address' : 0x00000000,
    'page_buffers' : [0x20001000, 0x20002000],   # Enable double buffering
    'min_program_length' : 0x1000,

    # Relative region addresses and sizes
    'ro_start': 0x0,
    'ro_size': 0x594,
    'rw_start': 0x594,
    'rw_size': 0x4,
    'zi_start': 0x598,
    'zi_size': 0x10,

    # Flash information
    'flash_start': 0x0,
    'flash_size': 0x200000,
    'sector_sizes': (
        (0x0, 0x1000),
    )
}

# Note: generated from nrf52xxx_uicr.flm from NordicSemiconductor.nRF_DeviceFamilyPack.8.38.0.pack
FLASH_ALGO_UICR = {
    'load_address' : 0x20000000,

    # Flash algorithm as a hex string
    'instructions': [
    0xe00abe00,
    0x4614b570, 0x0604f240, 0x0600f2c0, 0xf8492500, 0xeb095006, 0xe9c00006, 0x60c55501, 0xf000b2d0,
    0x2800f9fb, 0xeb09bf1e, 0xe9c10106, 0x46050402, 0xbd704628, 0x4604b510, 0xf0002000, 0xf240f9ed,
    0xf2c00104, 0x44490100, 0xe9c1b110, 0xe0030402, 0x29006889, 0xbd10bf08, 0x0100f244, 0x0100f2c2,
    0x600a2201, 0x0204f240, 0x0200f2c0, 0x3002f859, 0x444a604b, 0x608b6853, 0x60cb6893, 0x610a68d2,
    0xbf00bd10, 0x0004f240, 0x0000f2c0, 0xf8492101, 0x44481000, 0xe9c02100, 0x60c11101, 0xb9f0f000,
    0xf240b510, 0xf2c00004, 0x21020000, 0x1000f849, 0x24004448, 0x4401e9c0, 0xf00060c4, 0x4601f951,
    0x2010f04f, 0xf00022ff, 0xb138f80f, 0xf9d8f000, 0x28694604, 0x2c00d004, 0x2400bf08, 0xbd104620,
    0x46202400, 0xbf00bd10, 0xf240b5b0, 0xf2c00c04, 0x23050c00, 0x300cf849, 0x030ceb09, 0x0e00f04f,
    0xee01e9c3, 0xe00cf8c3, 0xd0050783, 0x010ceb09, 0xe9c12203, 0xe00b2002, 0x0e0ceb09, 0xf8ce2301,
    0x078b3004, 0xeb09d008, 0x2203000c, 0x2102e9c0, 0x0e65f04f, 0xbdb04670, 0x0e0ceb09, 0xf8ce2302,
    0xf6413004, 0xf2c175ff, 0x42a80500, 0xeb09d905, 0x2204010c, 0x2002e9c1, 0xeb09e00d, 0x2403030c,
    0xeb01605c, 0x1c6b0e00, 0xd908459e, 0x000ceb09, 0xe9c02104, 0xf04f1e02, 0x46700e66, 0xb151bdb0,
    0xf04f2300, 0xbf000e00, 0x42955cc5, 0x3301d107, 0xd3f9428b, 0xf04fe00b, 0x46700e00, 0xeb09bdb0,
    0x4418010c, 0xe9c12205, 0xf04f2002, 0x46700e01, 0xbf00bdb0, 0x41f0e92d, 0x46044615, 0x0604f240,
    0x0600f2c0, 0xf8492003, 0xeb090006, 0x23000206, 0x3301e9c2, 0x078a60d3, 0xeb09d006, 0xe9c20206,
    0x20650102, 0x81f0e8bd, 0x0006eb09, 0x60422202, 0x72fff641, 0x0200f2c1, 0xd9074294, 0x0006eb09,
    0xe9c02104, 0x20661402, 0x81f0e8bd, 0x0006eb09, 0x60432303, 0x32011908, 0xd9074290, 0x0106eb09,
    0xe9c12204, 0x20662002, 0x81f0e8bd, 0xebb02000, 0xd01a0f91, 0x0891ea4f, 0xe00b2700, 0x0027f855,
    0x0027f844, 0xf902f000, 0x20003701, 0xbf284547, 0x81f0e8bd, 0x0027f854, 0xd0ef3001, 0x0006eb09,
    0x220519e1, 0x2102e9c0, 0xe8bd2068, 0xbf0081f0, 0xf240b5b0, 0xf2c00504, 0x23040500, 0x3005f849,
    0x0305eb09, 0xe9c32400, 0x60dc4401, 0xd0060783, 0x0105eb09, 0xe9c12203, 0x20652002, 0xeb09bdb0,
    0x24010305, 0x078b605c, 0xeb09d006, 0x22030005, 0x2102e9c0, 0xbdb02065, 0x0305eb09, 0x605c2402,
    0x7efff641, 0x0e00f2c1, 0xd9064570, 0x0105eb09, 0xe9c12204, 0x20662002, 0xeb09bdb0, 0x24030305,
    0xeb01605c, 0xf10e0c00, 0x459c0301, 0xeb09d906, 0x21040005, 0x1c02e9c0, 0xbdb02066, 0x0305eb09,
    0x605c2404, 0xebb32300, 0xbf040f91, 0xbdb04660, 0x0e91ea4f, 0xe0052100, 0x30043101, 0xbf244571,
    0xbdb04660, 0x3021f852, 0x429c6804, 0xeb09d0f4, 0x22060105, 0x2002e9c1, 0x0000bdb0, 0x1030f240,
    0x0000f2c1, 0x31016801, 0x6800bf1c, 0xf6404770, 0xf2cf70e0, 0x68410000, 0xf3617800, 0x4770200b,
    0xf2c12010, 0x68010000, 0xbf143101, 0xf44f6800, 0x47705080, 0xf2c12014, 0x68010000, 0xbf143101,
    0xf44f6800, 0x47707000, 0x47702000, 0x47702000, 0xf7ffb510, 0x4604ffe5, 0xffecf7ff, 0xbd104360,
    0x42814401, 0x2001bf9c, 0xe0034770, 0xbf244288, 0x47702001, 0x2b04f850, 0xbf1c3201, 0x47702000,
    0xbf00e7f4, 0xf7ffb580, 0x280fffb9, 0xbd80bf88, 0xfa012101, 0xf24cf000, 0x42104240, 0xf240bf1e,
    0xf2c46008, 0x60010000, 0xbf00bd80, 0x47702000, 0x0104f243, 0xf24e6809, 0xf2c552db, 0x429112b1,
    0x2003bf1c, 0xf2434770, 0x680a0108, 0x42822103, 0x2102bf88, 0x47704608, 0xbf842803, 0x47702069,
    0xb240b580, 0xf851a105, 0xf24e0020, 0xf2c45104, 0x60080101, 0xf80af000, 0xbd802000, 0x00000000,
    0x00000002, 0x00000001, 0x00000000, 0x4000f24e, 0x0001f2c4, 0x29006801, 0x4770d0fc, 0x500cf24e,
    0x0001f2c4, 0x60012101, 0xbf00e7f0, 0x9000b081, 0xf24e9800, 0xf2c45108, 0x60080101, 0xe7e5b001,
    0xf24eb580, 0xf2c45014, 0x21010001, 0xf7ff6001, 0x2000ffdd, 0xbf00bd80, 0xf7ffb570, 0x4604ff79,
    0x20002500, 0xffa4f7ff, 0xd0052802, 0x2601b938, 0x42a52500, 0xe00dd306, 0x0008f243, 0x26006805,
    0xd20742a5, 0xf7ff4628, 0xf7ffffd1, 0x4405ff49, 0xd3f742a5, 0xbf182e00, 0xffd2f7ff, 0xbd702000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000
    ],

    # Relative function addresses
    'pc_init': 0x20000005,
    'pc_unInit': 0x20000039,
    'pc_program_page': 0x200001b9,
    'pc_erase_sector': 0x200000a5,
    'pc_eraseAll': 0x20000089,

    'static_base' : 0x20000000 + 0x00000004 + 0x000004e0,
    'begin_stack' : 0x200006e8,
    'begin_data' : 0x20000000 + 0x1000,
    'page_size' : 0x1000,
    'analyzer_supported' : False,
    'analyzer_address' : 0x00000000,
    'page_buffers' : [0x20001000, 0x20002000],   # Enable double buffering
    'min_program_length' : 0x1000,

    # Relative region addresses and sizes
    'ro_start': 0x0,
    'ro_size': 0x4e0,
    'rw_start': 0x4e0,
    'rw_size': 0x4,
    'zi_start': 0x4e4,
    'zi_size': 0x10,

    # Flash information
    'flash_start': 0x10001000,
    'flash_size': 0x1000,
    'sector_sizes': (
        (0x0, 0x1000),
    )
}

class NRF52833(NRF52):

    MEMORY_MAP = MemoryMap(
        FlashRegion(name="flash",   start=0x0,          length=0x80000,     blocksize=0x1000,
                is_boot_memory=True,
                algo=FLASH_ALGO_FLASH),
        # User Information Configation Registers (UICR) as a flash region
        FlashRegion(name="uicr",    start=0x10001000,   length=0x1000,      blocksize=0x400,
                is_testable=False,
                algo=FLASH_ALGO_UICR),
        RamRegion(name="code_ram",  start=0x00800000,   length=0x20000,
                alias="ram"),
        RamRegion(name="ram",       start=0x20000000,   length=0x20000)
        )

    def __init__(self, session):
        super().__init__(session, self.MEMORY_MAP)
        self._svd_location = SVDFile.from_builtin("nrf52833.svd")
