/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.loader.attributes.model;

import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import schemacrawler.loader.attributes.model.AlternateKeyAttributes;
import schemacrawler.loader.attributes.model.ObjectAttributes;
import schemacrawler.loader.attributes.model.TableAttributes;
import schemacrawler.loader.attributes.model.WeakAssociationAttributes;

public final class CatalogAttributes
extends ObjectAttributes {
    private static final long serialVersionUID = 1436642683972751860L;
    private final Set<TableAttributes> tables;
    private final Set<WeakAssociationAttributes> weakAssociations;
    private final Set<AlternateKeyAttributes> alternateKeys;

    @ConstructorProperties(value={"name", "remarks", "attributes", "tables", "weak-associations", "alternate-keys"})
    public CatalogAttributes(String name, List<String> remarks, Map<String, String> attributes, Set<TableAttributes> tables, Set<WeakAssociationAttributes> weakAssociations, Set<AlternateKeyAttributes> alternateKeys) {
        super(name, remarks, attributes);
        this.tables = tables == null ? Collections.emptySet() : new TreeSet<TableAttributes>(tables);
        this.weakAssociations = weakAssociations == null ? Collections.emptySet() : Collections.unmodifiableSet(weakAssociations);
        this.alternateKeys = alternateKeys == null ? Collections.emptySet() : Collections.unmodifiableSet(alternateKeys);
    }

    public Set<AlternateKeyAttributes> getAlternateKeys() {
        return this.alternateKeys;
    }

    public Set<TableAttributes> getTables() {
        return this.tables;
    }

    public Set<WeakAssociationAttributes> getWeakAssociations() {
        return this.weakAssociations;
    }
}

