/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import java.sql.SQLException;
import java.util.Objects;
import org.firebirdsql.gds.ng.FbDatabase;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.OperationCloseHandle;
import org.firebirdsql.gds.ng.OperationMonitor;
import org.firebirdsql.gds.ng.monitor.Operation;

final class FbDatabaseOperation
implements Operation,
OperationCloseHandle {
    private final Operation.Type type;
    private volatile FbDatabase fbDatabase;
    private volatile boolean cancelled;

    private FbDatabaseOperation(Operation.Type type, FbDatabase fbDatabase) {
        this.type = Objects.requireNonNull(type, "type");
        this.fbDatabase = Objects.requireNonNull(fbDatabase, "fbDatabase");
    }

    @Override
    public Operation.Type getType() {
        return this.type;
    }

    @Override
    public void cancel() throws SQLException {
        FbDatabase current = this.fbDatabase;
        if (current == null) {
            throw FbExceptionBuilder.forException(337248298).messageParameter("cancel").toFlatSQLException();
        }
        this.cancelled = true;
        current.cancelOperation(3);
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void close() {
        FbDatabase previous = this.fbDatabase;
        this.fbDatabase = null;
        if (previous != null) {
            OperationMonitor.endOperation(this);
        }
    }

    static OperationCloseHandle signalExecute(FbDatabase fbDatabase) {
        return FbDatabaseOperation.signalOperation(fbDatabase, Operation.Type.STATEMENT_EXECUTE);
    }

    static OperationCloseHandle signalFetch(FbDatabase fbDatabase) {
        return FbDatabaseOperation.signalOperation(fbDatabase, Operation.Type.STATEMENT_FETCH);
    }

    private static OperationCloseHandle signalOperation(FbDatabase fbDatabase, Operation.Type statementExecute) {
        FbDatabaseOperation fbDatabaseOperation = new FbDatabaseOperation(statementExecute, fbDatabase);
        OperationMonitor.startOperation(fbDatabaseOperation);
        return fbDatabaseOperation;
    }
}

