/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Executable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.locks.Condition;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.RESULT_FETCH, Feature.PARAMETER_SET})
abstract class BlockSource {
    private static final int BLOCK_SIZE = 32768;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;

    BlockSource() {
        boolean bl = (0x280L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, BlockSource.class, $$$methodRef$$$2, null, new Object[0]);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, BlockSource.class, $$$methodRef$$$2, null);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, BlockSource.class, $$$methodRef$$$2, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, BlockSource.class, $$$methodRef$$$2, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    static final BlockSource createBlockSource(boolean bl, Implementation implementation) {
        boolean bl2 = (0x280L & TraceControllerImpl.feature) != 0L;
        try {
            void impl;
            boolean useThreadLocal;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, BlockSource.class, $$$methodRef$$$0, null, new Object[]{bl, implementation});
            }
            if (useThreadLocal) {
                BlockSource blockSource = ThreadLocalBlockSource.createBlockSource((Implementation)impl);
                if (bl2) {
                    ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, BlockSource.class, $$$methodRef$$$0, null, blockSource);
                    ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, BlockSource.class, $$$methodRef$$$0, null, null);
                }
                return blockSource;
            }
            BlockSource blockSource = BlockSource.createBlockSource((Implementation)impl);
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, BlockSource.class, $$$methodRef$$$0, null, blockSource);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, BlockSource.class, $$$methodRef$$$0, null, null);
            }
            return blockSource;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, BlockSource.class, $$$methodRef$$$0, null, throwable2);
            }
            throw throwable;
        }
    }

    static BlockSource createBlockSource(Implementation implementation) {
        boolean bl = (0x280L & TraceControllerImpl.feature) != 0L;
        try {
            Implementation impl;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, BlockSource.class, $$$methodRef$$$1, null, new Object[]{implementation});
            }
            switch (impl) {
                case DUMB: {
                    BlockSource blockSource = DumbBlockSource.createBlockSource();
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, BlockSource.class, $$$methodRef$$$1, null, blockSource);
                        ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, BlockSource.class, $$$methodRef$$$1, null, null);
                    }
                    return blockSource;
                }
                case SIMPLE: {
                    BlockSource blockSource = SimpleCachingBlockSource.createBlockSource();
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, BlockSource.class, $$$methodRef$$$1, null, blockSource);
                        ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, BlockSource.class, $$$methodRef$$$1, null, null);
                    }
                    return blockSource;
                }
                case SOFT: {
                    BlockSource blockSource = SoftCachingBlockSource.access$000();
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, BlockSource.class, $$$methodRef$$$1, null, blockSource);
                        ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, BlockSource.class, $$$methodRef$$$1, null, null);
                    }
                    return blockSource;
                }
                case THREADED: {
                    BlockSource blockSource = ThreadedCachingBlockSource.createBlockSource();
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, BlockSource.class, $$$methodRef$$$1, null, blockSource);
                        ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, BlockSource.class, $$$methodRef$$$1, null, null);
                    }
                    return blockSource;
                }
            }
            BlockSource blockSource = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, BlockSource.class, $$$methodRef$$$1, null, blockSource);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, BlockSource.class, $$$methodRef$$$1, null, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, BlockSource.class, $$$methodRef$$$1, null, throwable2);
            }
            throw throwable;
        }
    }

    abstract int getBlockSize();

    abstract byte[] get();

    abstract void put(byte[] var1);

    static {
        try {
            $$$methodRef$$$2 = BlockSource.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = BlockSource.class.getDeclaredMethod("createBlockSource", Implementation.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = BlockSource.class.getDeclaredMethod("createBlockSource", Boolean.TYPE, Implementation.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }

    @DefaultLogger(value="oracle.jdbc")
    @Supports(value={Feature.RESULT_FETCH, Feature.PARAMETER_SET})
    private static final class ThreadLocalBlockSource
    extends BlockSource {
        private static Implementation IMPL;
        private static final ThreadLocal<BlockSource> REF;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;

        static BlockSource createBlockSource(Implementation implementation) {
            boolean bl = (0x280L & TraceControllerImpl.feature) != 0L;
            try {
                Implementation impl;
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, ThreadLocalBlockSource.class, $$$methodRef$$$0, null, new Object[]{implementation});
                }
                if (!$assertionsDisabled && IMPL != null && IMPL != impl) {
                    AssertionError assertionError = new AssertionError((Object)("IMPL: " + (Object)((Object)IMPL) + " impl: " + (Object)((Object)impl)));
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, ThreadLocalBlockSource.class, $$$methodRef$$$0, null, (Throwable)((Object)assertionError));
                    }
                    throw assertionError;
                }
                IMPL = impl;
                ThreadLocalBlockSource threadLocalBlockSource = new ThreadLocalBlockSource();
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, ThreadLocalBlockSource.class, $$$methodRef$$$0, null, threadLocalBlockSource);
                    ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, ThreadLocalBlockSource.class, $$$methodRef$$$0, null, null);
                }
                return threadLocalBlockSource;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (bl) {
                    ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, ThreadLocalBlockSource.class, $$$methodRef$$$0, null, throwable2);
                }
                throw throwable;
            }
        }

        private ThreadLocalBlockSource() {
            boolean bl = (0x280L & TraceControllerImpl.feature) != 0L;
            try {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, ThreadLocalBlockSource.class, $$$methodRef$$$5, null, new Object[0]);
                }
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, ThreadLocalBlockSource.class, $$$methodRef$$$5, null);
                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, ThreadLocalBlockSource.class, $$$methodRef$$$5, null, null);
                }
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (bl) {
                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, ThreadLocalBlockSource.class, $$$methodRef$$$5, null, throwable2);
                }
                throw throwable;
            }
        }

        @Override
        int getBlockSize() {
            boolean bl = (0x280L & TraceControllerImpl.feature) != 0L;
            try {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, ThreadLocalBlockSource.class, $$$methodRef$$$1, this, new Object[0]);
                }
                int n2 = REF.get().getBlockSize();
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, ThreadLocalBlockSource.class, $$$methodRef$$$1, this, n2);
                    ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, ThreadLocalBlockSource.class, $$$methodRef$$$1, this, null);
                }
                return n2;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (bl) {
                    ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, ThreadLocalBlockSource.class, $$$methodRef$$$1, this, throwable2);
                }
                throw throwable;
            }
        }

        @Override
        byte[] get() {
            boolean bl = (0x280L & TraceControllerImpl.feature) != 0L;
            try {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, ThreadLocalBlockSource.class, $$$methodRef$$$2, this, new Object[0]);
                }
                BlockSource s2 = REF.get();
                byte[] byArray = s2.get();
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, ThreadLocalBlockSource.class, $$$methodRef$$$2, this, byArray);
                    ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, ThreadLocalBlockSource.class, $$$methodRef$$$2, this, null);
                }
                return byArray;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (bl) {
                    ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, ThreadLocalBlockSource.class, $$$methodRef$$$2, this, throwable2);
                }
                throw throwable;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        void put(byte[] byArray) {
            boolean bl = (0x280L & TraceControllerImpl.feature) != 0L;
            try {
                void block;
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, ThreadLocalBlockSource.class, $$$methodRef$$$3, this, new Object[]{byArray});
                }
                BlockSource s2 = REF.get();
                s2.put((byte[])block);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, ThreadLocalBlockSource.class, $$$methodRef$$$3, this);
                    ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, ThreadLocalBlockSource.class, $$$methodRef$$$3, this, null);
                }
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (bl) {
                    ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, ThreadLocalBlockSource.class, $$$methodRef$$$3, this, throwable2);
                }
                throw throwable;
            }
        }

        static /* synthetic */ Implementation access$500() {
            boolean bl = (0x280L & TraceControllerImpl.feature) != 0L;
            try {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, ThreadLocalBlockSource.class, $$$methodRef$$$4, null, new Object[0]);
                }
                Implementation implementation = IMPL;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, ThreadLocalBlockSource.class, $$$methodRef$$$4, null, (Object)implementation);
                    ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, ThreadLocalBlockSource.class, $$$methodRef$$$4, null, null);
                }
                return implementation;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (bl) {
                    ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, ThreadLocalBlockSource.class, $$$methodRef$$$4, null, throwable2);
                }
                throw throwable;
            }
        }

        static {
            try {
                $$$methodRef$$$5 = ThreadLocalBlockSource.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = ThreadLocalBlockSource.class.getDeclaredMethod("access$500", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = ThreadLocalBlockSource.class.getDeclaredMethod("put", byte[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = ThreadLocalBlockSource.class.getDeclaredMethod("get", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = ThreadLocalBlockSource.class.getDeclaredMethod("getBlockSize", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = ThreadLocalBlockSource.class.getDeclaredMethod("createBlockSource", Implementation.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            IMPL = null;
            REF = new ThreadLocal<BlockSource>(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;
                private static Executable $$$methodRef$$$2;
                private static Logger $$$loggerRef$$$2;

                @Override
                protected BlockSource initialValue() {
                    return BlockSource.createBlockSource(ThreadLocalBlockSource.access$500());
                }

                static {
                    try {
                        $$$methodRef$$$2 = 1.class.getDeclaredConstructor(new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$1 = 1.class.getDeclaredMethod("initialValue", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 1.class.getDeclaredMethod("initialValue", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            };
        }
    }

    @DefaultLogger(value="oracle.jdbc")
    @Supports(value={Feature.RESULT_FETCH, Feature.PARAMETER_SET})
    private static final class SoftCachingBlockSource
    extends BlockSource {
        private static final int CACHE_SIZE = 1024;
        private final SoftReference<byte[]>[] blocks;
        private int top;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;

        private static BlockSource createBlockSource() {
            boolean bl = (0x280L & TraceControllerImpl.feature) != 0L;
            try {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, SoftCachingBlockSource.class, $$$methodRef$$$0, null, new Object[0]);
                }
                SoftCachingBlockSource softCachingBlockSource = new SoftCachingBlockSource();
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, SoftCachingBlockSource.class, $$$methodRef$$$0, null, softCachingBlockSource);
                    ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, SoftCachingBlockSource.class, $$$methodRef$$$0, null, null);
                }
                return softCachingBlockSource;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (bl) {
                    ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, SoftCachingBlockSource.class, $$$methodRef$$$0, null, throwable2);
                }
                throw throwable;
            }
        }

        private SoftCachingBlockSource() {
            boolean bl = (0x280L & TraceControllerImpl.feature) != 0L;
            try {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, SoftCachingBlockSource.class, $$$methodRef$$$5, null, new Object[0]);
                }
                this.blocks = new SoftReference[1024];
                this.top = 0;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, SoftCachingBlockSource.class, $$$methodRef$$$5, null);
                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, SoftCachingBlockSource.class, $$$methodRef$$$5, null, null);
                }
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (bl) {
                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, SoftCachingBlockSource.class, $$$methodRef$$$5, null, throwable2);
                }
                throw throwable;
            }
        }

        @Override
        int getBlockSize() {
            boolean bl = (0x280L & TraceControllerImpl.feature) != 0L;
            try {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, SoftCachingBlockSource.class, $$$methodRef$$$1, this, new Object[0]);
                }
                int n2 = 32768;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, SoftCachingBlockSource.class, $$$methodRef$$$1, this, n2);
                    ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, SoftCachingBlockSource.class, $$$methodRef$$$1, this, null);
                }
                return 32768;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (bl) {
                    ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, SoftCachingBlockSource.class, $$$methodRef$$$1, this, throwable2);
                }
                throw throwable;
            }
        }

        @Override
        byte[] get() {
            boolean bl = (0x280L & TraceControllerImpl.feature) != 0L;
            try {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, SoftCachingBlockSource.class, $$$methodRef$$$2, this, new Object[0]);
                }
                while (this.top > 0) {
                    SoftReference<byte[]> ref = this.blocks[--this.top];
                    this.blocks[this.top] = null;
                    byte[] blk = ref.get();
                    if (blk == null) continue;
                    byte[] byArray = blk;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, SoftCachingBlockSource.class, $$$methodRef$$$2, this, byArray);
                        ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, SoftCachingBlockSource.class, $$$methodRef$$$2, this, null);
                    }
                    return blk;
                }
                byte[] byArray = new byte[32768];
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, SoftCachingBlockSource.class, $$$methodRef$$$2, this, byArray);
                    ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, SoftCachingBlockSource.class, $$$methodRef$$$2, this, null);
                }
                return byArray;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (bl) {
                    ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, SoftCachingBlockSource.class, $$$methodRef$$$2, this, throwable2);
                }
                throw throwable;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        void put(byte[] byArray) {
            boolean bl = (0x280L & TraceControllerImpl.feature) != 0L;
            try {
                void block;
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, SoftCachingBlockSource.class, $$$methodRef$$$3, this, new Object[]{byArray});
                }
                if (!$assertionsDisabled && block == null) {
                    AssertionError assertionError = new AssertionError((Object)"block is null");
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, SoftCachingBlockSource.class, $$$methodRef$$$3, this, (Throwable)((Object)assertionError));
                    }
                    throw assertionError;
                }
                if (!$assertionsDisabled && ((void)block).length != 32768) {
                    AssertionError assertionError = new AssertionError((Object)("block.length: " + ((void)block).length));
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, SoftCachingBlockSource.class, $$$methodRef$$$3, this, (Throwable)((Object)assertionError));
                    }
                    throw assertionError;
                }
                if (this.top < this.blocks.length) {
                    this.blocks[this.top++] = new SoftReference<void>(block);
                } else {
                    int i2 = this.top;
                    while (i2 > 0) {
                        if (this.blocks[--i2].get() != null) continue;
                        this.blocks[i2] = new SoftReference<void>(block);
                        if (bl) {
                            ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, SoftCachingBlockSource.class, $$$methodRef$$$3, this);
                            ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, SoftCachingBlockSource.class, $$$methodRef$$$3, this, null);
                        }
                        return;
                    }
                }
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, SoftCachingBlockSource.class, $$$methodRef$$$3, this);
                    ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, SoftCachingBlockSource.class, $$$methodRef$$$3, this, null);
                }
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (bl) {
                    ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, SoftCachingBlockSource.class, $$$methodRef$$$3, this, throwable2);
                }
                throw throwable;
            }
        }

        static /* synthetic */ BlockSource access$000() {
            boolean bl = (0x280L & TraceControllerImpl.feature) != 0L;
            try {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, SoftCachingBlockSource.class, $$$methodRef$$$4, null, new Object[0]);
                }
                BlockSource blockSource = SoftCachingBlockSource.createBlockSource();
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, SoftCachingBlockSource.class, $$$methodRef$$$4, null, blockSource);
                    ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, SoftCachingBlockSource.class, $$$methodRef$$$4, null, null);
                }
                return blockSource;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (bl) {
                    ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, SoftCachingBlockSource.class, $$$methodRef$$$4, null, throwable2);
                }
                throw throwable;
            }
        }

        static {
            try {
                $$$methodRef$$$5 = SoftCachingBlockSource.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = SoftCachingBlockSource.class.getDeclaredMethod("access$000", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = SoftCachingBlockSource.class.getDeclaredMethod("put", byte[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = SoftCachingBlockSource.class.getDeclaredMethod("get", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = SoftCachingBlockSource.class.getDeclaredMethod("getBlockSize", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = SoftCachingBlockSource.class.getDeclaredMethod("createBlockSource", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    @DefaultLogger(value="oracle.jdbc")
    @Supports(value={Feature.RESULT_FETCH, Feature.PARAMETER_SET})
    static final class ThreadedCachingBlockSource
    extends BlockSource
    implements Monitor {
        private static final BlockReleaser RELEASER;
        private static final BlockReleaserListener LISTENER;
        private static final Collection<WeakReference<ThreadedCachingBlockSource>> ALL_INSTANCES;
        private static final Monitor ALL_INSTANCES_MONITOR;
        private static volatile long LAST_MEMORY_EVENT_MILLIS;
        private static final int INITIAL_CACHE_SIZE = 32;
        private int top;
        private byte[][] stack;
        private int lowWaterMark;
        private int recentLowWaterMark;
        private final Monitor.CloseableLock monitorLock;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;
        private static Executable $$$methodRef$$$9;
        private static Logger $$$loggerRef$$$9;
        private static Executable $$$methodRef$$$10;
        private static Logger $$$loggerRef$$$10;
        private static Executable $$$methodRef$$$11;
        private static Logger $$$loggerRef$$$11;

        static void stopBlockReleaserThread() {
            boolean bl = (0x280L & TraceControllerImpl.feature) != 0L;
            try {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, ThreadedCachingBlockSource.class, $$$methodRef$$$0, null, new Object[0]);
                }
                BlockReleaser.access$100().interrupt();
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, ThreadedCachingBlockSource.class, $$$methodRef$$$0, null);
                    ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, ThreadedCachingBlockSource.class, $$$methodRef$$$0, null, null);
                }
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (bl) {
                    ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, ThreadedCachingBlockSource.class, $$$methodRef$$$0, null, throwable2);
                }
                throw throwable;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static void releaseFromAllSources() {
            boolean bl = (0x280L & TraceControllerImpl.feature) != 0L;
            try {
                block20: {
                    Monitor.CloseableLock lock;
                    block21: {
                        if (bl) {
                            ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, ThreadedCachingBlockSource.class, $$$methodRef$$$1, null, new Object[0]);
                        }
                        lock = ALL_INSTANCES_MONITOR.acquireCloseableLock();
                        Throwable throwable = null;
                        try {
                            Iterator<WeakReference<ThreadedCachingBlockSource>> i2 = ALL_INSTANCES.iterator();
                            while (i2.hasNext()) {
                                ThreadedCachingBlockSource b2 = (ThreadedCachingBlockSource)i2.next().get();
                                if (b2 == null) {
                                    i2.remove();
                                    continue;
                                }
                                b2.releaseUnusedBlocks();
                            }
                            if (lock == null) break block20;
                            if (throwable == null) break block21;
                        }
                        catch (Throwable throwable3) {
                            try {
                                throwable = throwable3;
                                Throwable throwable4 = throwable3;
                                if (bl) {
                                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, ThreadedCachingBlockSource.class, $$$methodRef$$$1, null, throwable4);
                                }
                                throw throwable4;
                            }
                            catch (Throwable throwable5) {
                                if (lock != null) {
                                    if (throwable != null) {
                                        try {
                                            lock.close();
                                        }
                                        catch (Throwable throwable6) {
                                            throwable.addSuppressed(throwable6);
                                        }
                                    } else {
                                        lock.close();
                                    }
                                }
                                Throwable throwable7 = throwable5;
                                if (bl) {
                                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, ThreadedCachingBlockSource.class, $$$methodRef$$$1, null, throwable7);
                                }
                                throw throwable7;
                            }
                        }
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block20;
                    }
                    lock.close();
                }
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, ThreadedCachingBlockSource.class, $$$methodRef$$$1, null);
                    ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, ThreadedCachingBlockSource.class, $$$methodRef$$$1, null, null);
                }
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable8 = throwable;
                if (bl) {
                    ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, ThreadedCachingBlockSource.class, $$$methodRef$$$1, null, throwable8);
                }
                throw throwable;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static BlockSource createBlockSource() {
            boolean bl = (0x280L & TraceControllerImpl.feature) != 0L;
            try {
                ThreadedCachingBlockSource threadedCachingBlockSource;
                block22: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, ThreadedCachingBlockSource.class, $$$methodRef$$$2, null, new Object[0]);
                    }
                    try {
                        ThreadedCachingBlockSource b2;
                        block20: {
                            Monitor.CloseableLock lock;
                            block21: {
                                b2 = new ThreadedCachingBlockSource();
                                WeakReference<ThreadedCachingBlockSource> r2 = new WeakReference<ThreadedCachingBlockSource>(b2);
                                lock = ALL_INSTANCES_MONITOR.acquireCloseableLock();
                                Throwable throwable = null;
                                try {
                                    ALL_INSTANCES.add(r2);
                                    if (lock == null) break block20;
                                    if (throwable == null) break block21;
                                }
                                catch (Throwable throwable3) {
                                    try {
                                        throwable = throwable3;
                                        Throwable throwable4 = throwable3;
                                        if (bl) {
                                            ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, ThreadedCachingBlockSource.class, $$$methodRef$$$2, null, throwable4);
                                        }
                                        throw throwable4;
                                    }
                                    catch (Throwable throwable5) {
                                        if (lock != null) {
                                            if (throwable != null) {
                                                try {
                                                    lock.close();
                                                }
                                                catch (Throwable throwable6) {
                                                    throwable.addSuppressed(throwable6);
                                                }
                                            } else {
                                                lock.close();
                                            }
                                        }
                                        Throwable throwable7 = throwable5;
                                        if (bl) {
                                            ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, ThreadedCachingBlockSource.class, $$$methodRef$$$2, null, throwable7);
                                        }
                                        throw throwable7;
                                    }
                                }
                                try {
                                    lock.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                break block20;
                            }
                            lock.close();
                        }
                        threadedCachingBlockSource = b2;
                        if (!bl) break block22;
                    }
                    catch (OutOfMemoryError ex) {
                        LAST_MEMORY_EVENT_MILLIS = System.currentTimeMillis();
                        OutOfMemoryError outOfMemoryError = ex;
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, ThreadedCachingBlockSource.class, $$$methodRef$$$2, null, outOfMemoryError);
                        }
                        throw outOfMemoryError;
                    }
                    ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, ThreadedCachingBlockSource.class, $$$methodRef$$$2, null, threadedCachingBlockSource);
                    ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, ThreadedCachingBlockSource.class, $$$methodRef$$$2, null, null);
                }
                return threadedCachingBlockSource;
            }
            catch (Throwable throwable) {
                Throwable throwable8 = throwable;
                if (bl) {
                    ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, ThreadedCachingBlockSource.class, $$$methodRef$$$2, null, throwable8);
                }
                throw throwable;
            }
        }

        private ThreadedCachingBlockSource() {
            boolean bl = (0x280L & TraceControllerImpl.feature) != 0L;
            try {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, ThreadedCachingBlockSource.class, $$$methodRef$$$11, null, new Object[0]);
                }
                this.top = 0;
                this.stack = new byte[32][];
                this.lowWaterMark = 0;
                this.recentLowWaterMark = 0;
                this.monitorLock = this.newDefaultLock();
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, ThreadedCachingBlockSource.class, $$$methodRef$$$11, null);
                    ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, ThreadedCachingBlockSource.class, $$$methodRef$$$11, null, null);
                }
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (bl) {
                    ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, ThreadedCachingBlockSource.class, $$$methodRef$$$11, null, throwable2);
                }
                throw throwable;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        final void releaseUnusedBlocks() {
            boolean bl = (0x280L & TraceControllerImpl.feature) != 0L;
            try {
                block22: {
                    Monitor.CloseableLock lock;
                    block23: {
                        if (bl) {
                            ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, ThreadedCachingBlockSource.class, $$$methodRef$$$3, this, new Object[0]);
                        }
                        lock = this.acquireCloseableLock();
                        Throwable throwable = null;
                        try {
                            if (!$assertionsDisabled && this.top < this.recentLowWaterMark) {
                                AssertionError assertionError = new AssertionError();
                                if (bl) {
                                    ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, ThreadedCachingBlockSource.class, $$$methodRef$$$3, this, (Throwable)((Object)assertionError));
                                }
                                throw assertionError;
                            }
                            this.lowWaterMark = System.currentTimeMillis() - LAST_MEMORY_EVENT_MILLIS < 300000L ? this.recentLowWaterMark : Math.min((this.lowWaterMark + this.recentLowWaterMark) / 2, this.recentLowWaterMark);
                            int newTop = this.top - this.lowWaterMark;
                            if (bl) {
                                OracleLog.debug($$$loggerRef$$$3, Level.FINEST, this.getClass(), $$$methodRef$$$3, "releasing " + this.lowWaterMark + "\tnewTop " + newTop);
                            }
                            while (this.top > newTop) {
                                this.stack[--this.top] = null;
                            }
                            this.recentLowWaterMark = this.top;
                            if (lock == null) break block22;
                            if (throwable == null) break block23;
                        }
                        catch (Throwable throwable3) {
                            try {
                                throwable = throwable3;
                                Throwable throwable4 = throwable3;
                                if (bl) {
                                    ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, ThreadedCachingBlockSource.class, $$$methodRef$$$3, this, throwable4);
                                }
                                throw throwable4;
                            }
                            catch (Throwable throwable5) {
                                if (lock != null) {
                                    if (throwable != null) {
                                        try {
                                            lock.close();
                                        }
                                        catch (Throwable throwable6) {
                                            throwable.addSuppressed(throwable6);
                                        }
                                    } else {
                                        lock.close();
                                    }
                                }
                                Throwable throwable7 = throwable5;
                                if (bl) {
                                    ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, ThreadedCachingBlockSource.class, $$$methodRef$$$3, this, throwable7);
                                }
                                throw throwable7;
                            }
                        }
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block22;
                    }
                    lock.close();
                }
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, ThreadedCachingBlockSource.class, $$$methodRef$$$3, this);
                    ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, ThreadedCachingBlockSource.class, $$$methodRef$$$3, this, null);
                }
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable8 = throwable;
                if (bl) {
                    ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, ThreadedCachingBlockSource.class, $$$methodRef$$$3, this, throwable8);
                }
                throw throwable;
            }
        }

        private final void checkLowWater() {
            boolean bl = (0x280L & TraceControllerImpl.feature) != 0L;
            try {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, ThreadedCachingBlockSource.class, $$$methodRef$$$4, this, new Object[0]);
                }
                this.recentLowWaterMark = Math.min(this.recentLowWaterMark, this.top);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, ThreadedCachingBlockSource.class, $$$methodRef$$$4, this);
                    ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, ThreadedCachingBlockSource.class, $$$methodRef$$$4, this, null);
                }
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (bl) {
                    ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, ThreadedCachingBlockSource.class, $$$methodRef$$$4, this, throwable2);
                }
                throw throwable;
            }
        }

        @Override
        final int getBlockSize() {
            boolean bl = (0x280L & TraceControllerImpl.feature) != 0L;
            try {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, ThreadedCachingBlockSource.class, $$$methodRef$$$5, this, new Object[0]);
                }
                int n2 = 32768;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, ThreadedCachingBlockSource.class, $$$methodRef$$$5, this, n2);
                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, ThreadedCachingBlockSource.class, $$$methodRef$$$5, this, null);
                }
                return 32768;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (bl) {
                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, ThreadedCachingBlockSource.class, $$$methodRef$$$5, this, throwable2);
                }
                throw throwable;
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        final byte[] get() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK], 1[TRYBLOCK]], but top level block is 4[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Unable to fully structure code
         */
        @Override
        final void put(byte[] var1_1) {
            var7_2 = (640L & TraceControllerImpl.feature) != 0L;
            try {
                block32: {
                    block33: {
                        block31: {
                            block28: {
                                block29: {
                                    block30: {
                                        if (var7_2) {
                                            ClioSupport.entering(ThreadedCachingBlockSource.$$$loggerRef$$$7, Level.FINEST, ThreadedCachingBlockSource.class, ThreadedCachingBlockSource.$$$methodRef$$$7, this, new Object[]{var1_1});
                                        }
                                        lock = this.acquireCloseableLock();
                                        var3_4 = null;
                                        if (!ThreadedCachingBlockSource.$assertionsDisabled && ((void)block).length != 32768) {
                                            var8_5 = new AssertionError((Object)("block.length: " + ((void)block).length));
                                            if (var7_2) {
                                                ClioSupport.throwing(ThreadedCachingBlockSource.$$$loggerRef$$$7, Level.FINEST, ThreadedCachingBlockSource.class, ThreadedCachingBlockSource.$$$methodRef$$$7, this, (Throwable)var8_5);
                                            }
                                            throw var8_5;
                                        }
                                        if (this.top != this.stack.length) ** GOTO lbl40
                                        if (System.currentTimeMillis() - ThreadedCachingBlockSource.LAST_MEMORY_EVENT_MILLIS >= 300000L) break block28;
                                        if (var7_2) {
                                            OracleLog.log(ThreadedCachingBlockSource.$$$loggerRef$$$7, Level.INFO, this.getClass(), ThreadedCachingBlockSource.$$$methodRef$$$7, "would grow cache but recent memory event");
                                        }
                                        if (lock == null) break block29;
                                        if (var3_4 == null) break block30;
                                        try {
                                            lock.close();
                                        }
                                        catch (Throwable var4_9) {
                                            var3_4.addSuppressed(var4_9);
                                        }
                                        break block29;
                                    }
                                    lock.close();
                                }
                                if (var7_2) {
                                    ClioSupport.returning(ThreadedCachingBlockSource.$$$loggerRef$$$7, Level.FINEST, ThreadedCachingBlockSource.class, ThreadedCachingBlockSource.$$$methodRef$$$7, this);
                                    ClioSupport.exiting(ThreadedCachingBlockSource.$$$loggerRef$$$7, Level.FINEST, ThreadedCachingBlockSource.class, ThreadedCachingBlockSource.$$$methodRef$$$7, this, null);
                                }
                                return;
                            }
                            try {
                                if (var7_2) {
                                    OracleLog.log(ThreadedCachingBlockSource.$$$loggerRef$$$7, Level.INFO, this.getClass(), ThreadedCachingBlockSource.$$$methodRef$$$7, "grow cache -- new cache size: " + this.stack.length * 4);
                                }
                                s = new byte[this.stack.length * 4][];
                                System.arraycopy(this.stack, 0, s, 0, this.stack.length);
                                this.stack = s;
lbl40:
                                // 2 sources

                                this.stack[this.top++] = block;
                            }
                            catch (OutOfMemoryError ex) {
                                ThreadedCachingBlockSource.LAST_MEMORY_EVENT_MILLIS = System.currentTimeMillis();
                                if (!var7_2) break block31;
                                OracleLog.log(ThreadedCachingBlockSource.$$$loggerRef$$$7, Level.WARNING, this.getClass(), ThreadedCachingBlockSource.$$$methodRef$$$7, "OutOfMemoryException on grow cache\n" + ex.getMessage() + "\n", ex);
                            }
                        }
                        if (lock == null) break block32;
                        if (var3_4 == null) break block33;
                        try {
                            lock.close();
                        }
                        catch (Throwable var4_12) {
                            var3_4.addSuppressed(var4_12);
                        }
                        break block32;
                    }
                    lock.close();
                    break block32;
                    catch (Throwable var4_13) {
                        try {
                            var3_4 = var4_13;
                            var8_6 = var4_13;
                            if (var7_2) {
                                ClioSupport.throwing(ThreadedCachingBlockSource.$$$loggerRef$$$7, Level.FINEST, ThreadedCachingBlockSource.class, ThreadedCachingBlockSource.$$$methodRef$$$7, this, var8_6);
                            }
                            throw var8_6;
                        }
                        catch (Throwable var5_14) {
                            if (lock != null) {
                                if (var3_4 != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable var6_15) {
                                        var3_4.addSuppressed(var6_15);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            var8_7 = var5_14;
                            if (var7_2) {
                                ClioSupport.throwing(ThreadedCachingBlockSource.$$$loggerRef$$$7, Level.FINEST, ThreadedCachingBlockSource.class, ThreadedCachingBlockSource.$$$methodRef$$$7, this, var8_7);
                            }
                            throw var8_7;
                        }
                    }
                }
                if (var7_2) {
                    ClioSupport.returning(ThreadedCachingBlockSource.$$$loggerRef$$$7, Level.FINEST, ThreadedCachingBlockSource.class, ThreadedCachingBlockSource.$$$methodRef$$$7, this);
                    ClioSupport.exiting(ThreadedCachingBlockSource.$$$loggerRef$$$7, Level.FINEST, ThreadedCachingBlockSource.class, ThreadedCachingBlockSource.$$$methodRef$$$7, this, null);
                }
                return;
            }
            catch (Throwable v0) {
                var8_8 = v0;
                if (var7_2) {
                    ClioSupport.exiting(ThreadedCachingBlockSource.$$$loggerRef$$$7, Level.FINEST, ThreadedCachingBlockSource.class, ThreadedCachingBlockSource.$$$methodRef$$$7, this, var8_8);
                }
                throw v0;
            }
        }

        @Override
        public final Monitor.CloseableLock getMonitorLock() {
            boolean bl = (0x280L & TraceControllerImpl.feature) != 0L;
            try {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, ThreadedCachingBlockSource.class, $$$methodRef$$$8, this, new Object[0]);
                }
                Monitor.CloseableLock closeableLock = this.monitorLock;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, ThreadedCachingBlockSource.class, $$$methodRef$$$8, this, closeableLock);
                    ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, ThreadedCachingBlockSource.class, $$$methodRef$$$8, this, null);
                }
                return closeableLock;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (bl) {
                    ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, ThreadedCachingBlockSource.class, $$$methodRef$$$8, this, throwable2);
                }
                throw throwable;
            }
        }

        static /* synthetic */ void access$200() {
            boolean bl = (0x280L & TraceControllerImpl.feature) != 0L;
            try {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, ThreadedCachingBlockSource.class, $$$methodRef$$$9, null, new Object[0]);
                }
                ThreadedCachingBlockSource.releaseFromAllSources();
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, ThreadedCachingBlockSource.class, $$$methodRef$$$9, null);
                    ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, ThreadedCachingBlockSource.class, $$$methodRef$$$9, null, null);
                }
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (bl) {
                    ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, ThreadedCachingBlockSource.class, $$$methodRef$$$9, null, throwable2);
                }
                throw throwable;
            }
        }

        static /* synthetic */ long access$402(long l2) {
            boolean bl = (0x280L & TraceControllerImpl.feature) != 0L;
            try {
                long x0;
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, ThreadedCachingBlockSource.class, $$$methodRef$$$10, null, l2);
                }
                long l3 = LAST_MEMORY_EVENT_MILLIS = x0;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, ThreadedCachingBlockSource.class, $$$methodRef$$$10, null, l3);
                    ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, ThreadedCachingBlockSource.class, $$$methodRef$$$10, null, null);
                }
                return LAST_MEMORY_EVENT_MILLIS;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (bl) {
                    ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, ThreadedCachingBlockSource.class, $$$methodRef$$$10, null, throwable2);
                }
                throw throwable;
            }
        }

        static {
            try {
                $$$methodRef$$$11 = ThreadedCachingBlockSource.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$10 = ThreadedCachingBlockSource.class.getDeclaredMethod("access$402", Long.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$9 = ThreadedCachingBlockSource.class.getDeclaredMethod("access$200", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$8 = ThreadedCachingBlockSource.class.getDeclaredMethod("getMonitorLock", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$7 = ThreadedCachingBlockSource.class.getDeclaredMethod("put", byte[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$6 = ThreadedCachingBlockSource.class.getDeclaredMethod("get", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$5 = ThreadedCachingBlockSource.class.getDeclaredMethod("getBlockSize", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = ThreadedCachingBlockSource.class.getDeclaredMethod("checkLowWater", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = ThreadedCachingBlockSource.class.getDeclaredMethod("releaseUnusedBlocks", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = ThreadedCachingBlockSource.class.getDeclaredMethod("createBlockSource", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = ThreadedCachingBlockSource.class.getDeclaredMethod("releaseFromAllSources", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = ThreadedCachingBlockSource.class.getDeclaredMethod("stopBlockReleaserThread", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            RELEASER = BlockReleaser.access$100();
            LISTENER = BlockReleaserListener.access$300();
            ALL_INSTANCES = new LinkedList<WeakReference<ThreadedCachingBlockSource>>();
            ALL_INSTANCES_MONITOR = Monitor.newInstance();
            LAST_MEMORY_EVENT_MILLIS = 0L;
        }

        @DefaultLogger(value="oracle.jdbc")
        @Supports(value={Feature.RESULT_FETCH, Feature.PARAMETER_SET})
        private static final class BlockReleaserListener
        implements NotificationListener {
            private static final BlockReleaserListener SOLE_INSTANCE;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            private BlockReleaserListener() {
                boolean bl = (0x280L & TraceControllerImpl.feature) != 0L;
                try {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, BlockReleaserListener.class, $$$methodRef$$$3, null, new Object[0]);
                    }
                    MemoryMXBean mbean = ManagementFactory.getMemoryMXBean();
                    NotificationEmitter emitter = (NotificationEmitter)((Object)mbean);
                    emitter.addNotificationListener(this, null, null);
                    Pattern old = Pattern.compile(".*Old.*");
                    for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
                        if (pool.getType() != MemoryType.HEAP || !pool.isCollectionUsageThresholdSupported() || !old.matcher(pool.getName()).matches() || pool.getCollectionUsageThreshold() != 0L) continue;
                        MemoryUsage usage = pool.getUsage();
                        final long threshold = (long)(usage.getMax() == -1L ? (double)Runtime.getRuntime().maxMemory() * 0.9 : (double)usage.getMax() * 0.9);
                        final MemoryPoolMXBean memoryPool = pool;
                        if (bl) {
                            OracleLog.log($$$loggerRef$$$3, Level.INFO, this.getClass(), $$$methodRef$$$3, "setCollectionUsageThreshold<" + pool.getName() + ">(" + threshold + ")");
                        }
                        AccessController.doPrivileged(new PrivilegedAction<Object>(){
                            private static Executable $$$methodRef$$$0;
                            private static Logger $$$loggerRef$$$0;
                            private static Executable $$$methodRef$$$1;
                            private static Logger $$$loggerRef$$$1;

                            @Override
                            public Object run() {
                                memoryPool.setCollectionUsageThreshold(threshold);
                                return null;
                            }

                            static {
                                try {
                                    $$$methodRef$$$1 = 1.class.getDeclaredConstructor(BlockReleaserListener.class, MemoryPoolMXBean.class, Long.TYPE);
                                }
                                catch (Throwable throwable) {}
                                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                                try {
                                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                                }
                                catch (Throwable throwable) {}
                                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                            }
                        });
                    }
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, BlockReleaserListener.class, $$$methodRef$$$3, null);
                        ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, BlockReleaserListener.class, $$$methodRef$$$3, null, null);
                    }
                    return;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, BlockReleaserListener.class, $$$methodRef$$$3, null, throwable2);
                    }
                    throw throwable;
                }
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void handleNotification(Notification notification, Object object) {
                boolean bl = (0x280L & TraceControllerImpl.feature) != 0L;
                try {
                    void notification2;
                    String notifType;
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, BlockReleaserListener.class, $$$methodRef$$$0, this, notification, object);
                    }
                    if ((notifType = notification2.getType()).equals("java.management.memory.collection.threshold.exceeded")) {
                        if (bl) {
                            OracleLog.log($$$loggerRef$$$0, Level.INFO, this.getClass(), $$$methodRef$$$0, "MEMORY_COLLECTION_THRESHOLD_EXCEEDED");
                        }
                        ThreadedCachingBlockSource.access$402(System.currentTimeMillis());
                        BlockReleaser.releaseAllUnusedBlocks();
                    }
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, BlockReleaserListener.class, $$$methodRef$$$0, this);
                        ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, BlockReleaserListener.class, $$$methodRef$$$0, this, null);
                    }
                    return;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, BlockReleaserListener.class, $$$methodRef$$$0, this, throwable2);
                    }
                    throw throwable;
                }
            }

            public void unregister() {
                boolean bl = (0x280L & TraceControllerImpl.feature) != 0L;
                try {
                    block8: {
                        if (bl) {
                            ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, BlockReleaserListener.class, $$$methodRef$$$1, this, new Object[0]);
                        }
                        MemoryMXBean mbean = ManagementFactory.getMemoryMXBean();
                        NotificationEmitter emitter = (NotificationEmitter)((Object)mbean);
                        if (bl) {
                            OracleLog.debug($$$loggerRef$$$1, Level.FINEST, this.getClass(), $$$methodRef$$$1, "removeNotificationListener");
                        }
                        try {
                            emitter.removeNotificationListener(this, null, null);
                        }
                        catch (ListenerNotFoundException e2) {
                            if (!bl) break block8;
                            OracleLog.log($$$loggerRef$$$1, Level.WARNING, this.getClass(), $$$methodRef$$$1, e2.getMessage() + "\n", e2);
                        }
                    }
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, BlockReleaserListener.class, $$$methodRef$$$1, this);
                        ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, BlockReleaserListener.class, $$$methodRef$$$1, this, null);
                    }
                    return;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, BlockReleaserListener.class, $$$methodRef$$$1, this, throwable2);
                    }
                    throw throwable;
                }
            }

            static /* synthetic */ BlockReleaserListener access$300() {
                boolean bl = (0x280L & TraceControllerImpl.feature) != 0L;
                try {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, BlockReleaserListener.class, $$$methodRef$$$2, null, new Object[0]);
                    }
                    BlockReleaserListener blockReleaserListener = SOLE_INSTANCE;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, BlockReleaserListener.class, $$$methodRef$$$2, null, blockReleaserListener);
                        ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, BlockReleaserListener.class, $$$methodRef$$$2, null, null);
                    }
                    return blockReleaserListener;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, BlockReleaserListener.class, $$$methodRef$$$2, null, throwable2);
                    }
                    throw throwable;
                }
            }

            static {
                try {
                    $$$methodRef$$$3 = BlockReleaserListener.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$2 = BlockReleaserListener.class.getDeclaredMethod("access$300", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = BlockReleaserListener.class.getDeclaredMethod("unregister", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = BlockReleaserListener.class.getDeclaredMethod("handleNotification", Notification.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                SOLE_INSTANCE = new BlockReleaserListener();
            }
        }

        @DefaultLogger(value="oracle.jdbc")
        @Supports(value={Feature.RESULT_FETCH, Feature.PARAMETER_SET})
        private static final class BlockReleaser
        extends Thread
        implements Monitor.WaitableMonitor {
            private static final String BLOCK_RELEASER_THREAD_NAME = "oracle.jdbc.driver.BlockSource.ThreadedCachingBlockSource.BlockReleaser";
            private static final int DELAY_MILLIS = 300000;
            private static final BlockReleaser SOLE_INSTANCE;
            private final Monitor.CloseableLock monitorLock;
            private final Condition monitorCondition;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;
            private static Executable $$$methodRef$$$4;
            private static Logger $$$loggerRef$$$4;
            private static Executable $$$methodRef$$$5;
            private static Logger $$$loggerRef$$$5;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            static void releaseAllUnusedBlocks() {
                boolean bl = (0x280L & TraceControllerImpl.feature) != 0L;
                try {
                    block18: {
                        Monitor.CloseableLock lock;
                        block19: {
                            if (bl) {
                                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, BlockReleaser.class, $$$methodRef$$$0, null, new Object[0]);
                            }
                            lock = SOLE_INSTANCE.acquireCloseableLock();
                            Throwable throwable = null;
                            try {
                                SOLE_INSTANCE.monitorNotifyAll();
                                if (lock == null) break block18;
                                if (throwable == null) break block19;
                            }
                            catch (Throwable throwable3) {
                                try {
                                    throwable = throwable3;
                                    Throwable throwable4 = throwable3;
                                    if (bl) {
                                        ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, BlockReleaser.class, $$$methodRef$$$0, null, throwable4);
                                    }
                                    throw throwable4;
                                }
                                catch (Throwable throwable5) {
                                    if (lock != null) {
                                        if (throwable != null) {
                                            try {
                                                lock.close();
                                            }
                                            catch (Throwable throwable6) {
                                                throwable.addSuppressed(throwable6);
                                            }
                                        } else {
                                            lock.close();
                                        }
                                    }
                                    Throwable throwable7 = throwable5;
                                    if (bl) {
                                        ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, BlockReleaser.class, $$$methodRef$$$0, null, throwable7);
                                    }
                                    throw throwable7;
                                }
                            }
                            try {
                                lock.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            break block18;
                        }
                        lock.close();
                    }
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, BlockReleaser.class, $$$methodRef$$$0, null);
                        ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, BlockReleaser.class, $$$methodRef$$$0, null, null);
                    }
                    return;
                }
                catch (Throwable throwable) {
                    Throwable throwable8 = throwable;
                    if (bl) {
                        ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, BlockReleaser.class, $$$methodRef$$$0, null, throwable8);
                    }
                    throw throwable;
                }
            }

            private BlockReleaser() {
                super(BLOCK_RELEASER_THREAD_NAME);
                boolean bl = (0x280L & TraceControllerImpl.feature) != 0L;
                try {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, BlockReleaser.class, $$$methodRef$$$5, null, new Object[0]);
                    }
                    this.monitorLock = this.newDefaultLock();
                    this.monitorCondition = this.newMonitorCondition();
                    this.setDaemon(true);
                    this.setPriority(4);
                    this.start();
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, BlockReleaser.class, $$$methodRef$$$5, null);
                        ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, BlockReleaser.class, $$$methodRef$$$5, null, null);
                    }
                    return;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, BlockReleaser.class, $$$methodRef$$$5, null, throwable2);
                    }
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                boolean bl = (0x280L & TraceControllerImpl.feature) != 0L;
                try {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, BlockReleaser.class, $$$methodRef$$$1, this, new Object[0]);
                    }
                    while (true) {
                        try {
                            while (true) {
                                block28: {
                                    Monitor.CloseableLock lock;
                                    block29: {
                                        lock = SOLE_INSTANCE.acquireCloseableLock();
                                        Throwable throwable = null;
                                        try {
                                            SOLE_INSTANCE.monitorWait(300000L);
                                            if (lock == null) break block28;
                                            if (throwable == null) break block29;
                                        }
                                        catch (Throwable throwable3) {
                                            try {
                                                throwable = throwable3;
                                                Throwable throwable4 = throwable3;
                                                if (bl) {
                                                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, BlockReleaser.class, $$$methodRef$$$1, this, throwable4);
                                                }
                                                throw throwable4;
                                            }
                                            catch (Throwable throwable5) {
                                                if (lock != null) {
                                                    if (throwable != null) {
                                                        try {
                                                            lock.close();
                                                        }
                                                        catch (Throwable throwable6) {
                                                            throwable.addSuppressed(throwable6);
                                                        }
                                                    } else {
                                                        lock.close();
                                                    }
                                                }
                                                Throwable throwable7 = throwable5;
                                                if (bl) {
                                                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, BlockReleaser.class, $$$methodRef$$$1, this, throwable7);
                                                }
                                                throw throwable7;
                                            }
                                        }
                                        try {
                                            lock.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                        break block28;
                                    }
                                    lock.close();
                                }
                                if (bl) {
                                    OracleLog.log($$$loggerRef$$$1, Level.FINER, this.getClass(), $$$methodRef$$$1, "wait terminated");
                                }
                                ThreadedCachingBlockSource.access$200();
                            }
                        }
                        catch (InterruptedException ex) {
                            BlockReleaserListener.access$300().unregister();
                            if (bl) {
                                OracleLog.log($$$loggerRef$$$1, Level.WARNING, this.getClass(), $$$methodRef$$$1, "Interrupted. Listener unregistered");
                            }
                            if (bl) {
                                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, BlockReleaser.class, $$$methodRef$$$1, this);
                                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, BlockReleaser.class, $$$methodRef$$$1, this, null);
                            }
                            return;
                        }
                        catch (ThreadDeath ex) {
                            BlockReleaserListener.access$300().unregister();
                            if (bl) {
                                OracleLog.log($$$loggerRef$$$1, Level.SEVERE, this.getClass(), $$$methodRef$$$1, ex.getMessage() + "\n", ex);
                            }
                            ThreadDeath threadDeath = ex;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, BlockReleaser.class, $$$methodRef$$$1, this, threadDeath);
                            }
                            throw threadDeath;
                        }
                        catch (Throwable ex) {
                            if (!bl) continue;
                            OracleLog.log($$$loggerRef$$$1, Level.WARNING, this.getClass(), $$$methodRef$$$1, ex.getMessage() + "\n", ex);
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable8 = throwable;
                    if (bl) {
                        ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, BlockReleaser.class, $$$methodRef$$$1, this, throwable8);
                    }
                    throw throwable;
                }
            }

            @Override
            public final Monitor.CloseableLock getMonitorLock() {
                boolean bl = (0x280L & TraceControllerImpl.feature) != 0L;
                try {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, BlockReleaser.class, $$$methodRef$$$2, this, new Object[0]);
                    }
                    Monitor.CloseableLock closeableLock = this.monitorLock;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, BlockReleaser.class, $$$methodRef$$$2, this, closeableLock);
                        ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, BlockReleaser.class, $$$methodRef$$$2, this, null);
                    }
                    return closeableLock;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, BlockReleaser.class, $$$methodRef$$$2, this, throwable2);
                    }
                    throw throwable;
                }
            }

            @Override
            public Condition getMonitorCondition() {
                boolean bl = (0x280L & TraceControllerImpl.feature) != 0L;
                try {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, BlockReleaser.class, $$$methodRef$$$3, this, new Object[0]);
                    }
                    Condition condition = this.monitorCondition;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, BlockReleaser.class, $$$methodRef$$$3, this, condition);
                        ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, BlockReleaser.class, $$$methodRef$$$3, this, null);
                    }
                    return condition;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, BlockReleaser.class, $$$methodRef$$$3, this, throwable2);
                    }
                    throw throwable;
                }
            }

            static /* synthetic */ BlockReleaser access$100() {
                boolean bl = (0x280L & TraceControllerImpl.feature) != 0L;
                try {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, BlockReleaser.class, $$$methodRef$$$4, null, new Object[0]);
                    }
                    BlockReleaser blockReleaser = SOLE_INSTANCE;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, BlockReleaser.class, $$$methodRef$$$4, null, blockReleaser);
                        ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, BlockReleaser.class, $$$methodRef$$$4, null, null);
                    }
                    return blockReleaser;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, BlockReleaser.class, $$$methodRef$$$4, null, throwable2);
                    }
                    throw throwable;
                }
            }

            static {
                try {
                    $$$methodRef$$$5 = BlockReleaser.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$4 = BlockReleaser.class.getDeclaredMethod("access$100", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$3 = BlockReleaser.class.getDeclaredMethod("getMonitorCondition", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$2 = BlockReleaser.class.getDeclaredMethod("getMonitorLock", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = BlockReleaser.class.getDeclaredMethod("run", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = BlockReleaser.class.getDeclaredMethod("releaseAllUnusedBlocks", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                SOLE_INSTANCE = new BlockReleaser();
            }
        }
    }

    @DefaultLogger(value="oracle.jdbc")
    @Supports(value={Feature.RESULT_FETCH, Feature.PARAMETER_SET})
    static final class SimpleCachingBlockSource
    extends BlockSource {
        private static final int INITIAL_CACHE_SIZE = 32;
        private static final long RELEASE_NANOS = 300000000L;
        private int top;
        private byte[][] stack;
        private int lowWaterMark;
        private int recentLowWaterMark;
        private long nextReleaseNanos;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;

        static BlockSource createBlockSource() {
            boolean bl = (0x280L & TraceControllerImpl.feature) != 0L;
            try {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, SimpleCachingBlockSource.class, $$$methodRef$$$0, null, new Object[0]);
                }
                SimpleCachingBlockSource simpleCachingBlockSource = new SimpleCachingBlockSource();
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, SimpleCachingBlockSource.class, $$$methodRef$$$0, null, simpleCachingBlockSource);
                    ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, SimpleCachingBlockSource.class, $$$methodRef$$$0, null, null);
                }
                return simpleCachingBlockSource;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (bl) {
                    ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, SimpleCachingBlockSource.class, $$$methodRef$$$0, null, throwable2);
                }
                throw throwable;
            }
        }

        private SimpleCachingBlockSource() {
            boolean bl = (0x280L & TraceControllerImpl.feature) != 0L;
            try {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, SimpleCachingBlockSource.class, $$$methodRef$$$6, null, new Object[0]);
                }
                this.top = 0;
                this.stack = new byte[32][];
                this.lowWaterMark = 0;
                this.recentLowWaterMark = 0;
                this.nextReleaseNanos = System.nanoTime() + 300000000L;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, SimpleCachingBlockSource.class, $$$methodRef$$$6, null);
                    ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, SimpleCachingBlockSource.class, $$$methodRef$$$6, null, null);
                }
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (bl) {
                    ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, SimpleCachingBlockSource.class, $$$methodRef$$$6, null, throwable2);
                }
                throw throwable;
            }
        }

        final void releaseUnusedBlocks() {
            boolean bl = (0x280L & TraceControllerImpl.feature) != 0L;
            try {
                long t2;
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, SimpleCachingBlockSource.class, $$$methodRef$$$1, this, new Object[0]);
                }
                if ((t2 = System.nanoTime()) < this.nextReleaseNanos) {
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, SimpleCachingBlockSource.class, $$$methodRef$$$1, this);
                        ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, SimpleCachingBlockSource.class, $$$methodRef$$$1, this, null);
                    }
                    return;
                }
                this.nextReleaseNanos = t2 + 300000000L;
                if (!$assertionsDisabled && this.top < this.recentLowWaterMark) {
                    AssertionError assertionError = new AssertionError();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, SimpleCachingBlockSource.class, $$$methodRef$$$1, this, (Throwable)((Object)assertionError));
                    }
                    throw assertionError;
                }
                this.lowWaterMark = Math.min((this.lowWaterMark + this.recentLowWaterMark) / 2, this.recentLowWaterMark);
                int newTop = this.top - this.lowWaterMark;
                if (bl) {
                    OracleLog.debug($$$loggerRef$$$1, Level.FINEST, this.getClass(), $$$methodRef$$$1, "releasing " + this.lowWaterMark + "\tnewTop " + newTop);
                }
                while (this.top > newTop) {
                    this.stack[--this.top] = null;
                }
                this.recentLowWaterMark = this.top;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, SimpleCachingBlockSource.class, $$$methodRef$$$1, this);
                    ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, SimpleCachingBlockSource.class, $$$methodRef$$$1, this, null);
                }
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (bl) {
                    ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, SimpleCachingBlockSource.class, $$$methodRef$$$1, this, throwable2);
                }
                throw throwable;
            }
        }

        private final void checkLowWater() {
            boolean bl = (0x280L & TraceControllerImpl.feature) != 0L;
            try {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, SimpleCachingBlockSource.class, $$$methodRef$$$2, this, new Object[0]);
                }
                this.recentLowWaterMark = Math.min(this.recentLowWaterMark, this.top);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, SimpleCachingBlockSource.class, $$$methodRef$$$2, this);
                    ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, SimpleCachingBlockSource.class, $$$methodRef$$$2, this, null);
                }
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (bl) {
                    ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, SimpleCachingBlockSource.class, $$$methodRef$$$2, this, throwable2);
                }
                throw throwable;
            }
        }

        @Override
        final int getBlockSize() {
            boolean bl = (0x280L & TraceControllerImpl.feature) != 0L;
            try {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, SimpleCachingBlockSource.class, $$$methodRef$$$3, this, new Object[0]);
                }
                int n2 = 32768;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, SimpleCachingBlockSource.class, $$$methodRef$$$3, this, n2);
                    ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, SimpleCachingBlockSource.class, $$$methodRef$$$3, this, null);
                }
                return 32768;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (bl) {
                    ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, SimpleCachingBlockSource.class, $$$methodRef$$$3, this, throwable2);
                }
                throw throwable;
            }
        }

        @Override
        final byte[] get() {
            boolean bl = (0x280L & TraceControllerImpl.feature) != 0L;
            try {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, SimpleCachingBlockSource.class, $$$methodRef$$$4, this, new Object[0]);
                }
                if (this.top == 0) {
                    byte[] byArray = new byte[32768];
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, SimpleCachingBlockSource.class, $$$methodRef$$$4, this, byArray);
                        ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, SimpleCachingBlockSource.class, $$$methodRef$$$4, this, null);
                    }
                    return byArray;
                }
                byte[] result = this.stack[--this.top];
                this.checkLowWater();
                byte[] byArray = result;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, SimpleCachingBlockSource.class, $$$methodRef$$$4, this, byArray);
                    ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, SimpleCachingBlockSource.class, $$$methodRef$$$4, this, null);
                }
                return result;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (bl) {
                    ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, SimpleCachingBlockSource.class, $$$methodRef$$$4, this, throwable2);
                }
                throw throwable;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void put(byte[] byArray) {
            boolean bl = (0x280L & TraceControllerImpl.feature) != 0L;
            try {
                void block;
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, SimpleCachingBlockSource.class, $$$methodRef$$$5, this, new Object[]{byArray});
                }
                if (!$assertionsDisabled && ((void)block).length != 32768) {
                    AssertionError assertionError = new AssertionError((Object)("block.length: " + ((void)block).length));
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, SimpleCachingBlockSource.class, $$$methodRef$$$5, this, (Throwable)((Object)assertionError));
                    }
                    throw assertionError;
                }
                if (this.top == this.stack.length) {
                    if (bl) {
                        OracleLog.log($$$loggerRef$$$5, Level.FINER, this.getClass(), $$$methodRef$$$5, "grow cache--old stack.length: " + this.stack.length + "\tnew stack.length: " + this.stack.length * 4);
                    }
                    byte[][] s2 = new byte[this.stack.length * 4][];
                    System.arraycopy(this.stack, 0, s2, 0, this.stack.length);
                    this.stack = s2;
                }
                this.stack[this.top++] = block;
                this.releaseUnusedBlocks();
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, SimpleCachingBlockSource.class, $$$methodRef$$$5, this);
                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, SimpleCachingBlockSource.class, $$$methodRef$$$5, this, null);
                }
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (bl) {
                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, SimpleCachingBlockSource.class, $$$methodRef$$$5, this, throwable2);
                }
                throw throwable;
            }
        }

        static {
            try {
                $$$methodRef$$$6 = SimpleCachingBlockSource.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$5 = SimpleCachingBlockSource.class.getDeclaredMethod("put", byte[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = SimpleCachingBlockSource.class.getDeclaredMethod("get", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = SimpleCachingBlockSource.class.getDeclaredMethod("getBlockSize", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = SimpleCachingBlockSource.class.getDeclaredMethod("checkLowWater", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = SimpleCachingBlockSource.class.getDeclaredMethod("releaseUnusedBlocks", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = SimpleCachingBlockSource.class.getDeclaredMethod("createBlockSource", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    @DefaultLogger(value="oracle.jdbc")
    @Supports(value={Feature.RESULT_FETCH, Feature.PARAMETER_SET})
    static class DumbBlockSource
    extends BlockSource {
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;

        static final BlockSource createBlockSource() {
            boolean bl = (0x280L & TraceControllerImpl.feature) != 0L;
            try {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, DumbBlockSource.class, $$$methodRef$$$0, null, new Object[0]);
                }
                DumbBlockSource dumbBlockSource = new DumbBlockSource();
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, DumbBlockSource.class, $$$methodRef$$$0, null, dumbBlockSource);
                    ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, DumbBlockSource.class, $$$methodRef$$$0, null, null);
                }
                return dumbBlockSource;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (bl) {
                    ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, DumbBlockSource.class, $$$methodRef$$$0, null, throwable2);
                }
                throw throwable;
            }
        }

        DumbBlockSource() {
            boolean bl = (0x280L & TraceControllerImpl.feature) != 0L;
            try {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, DumbBlockSource.class, $$$methodRef$$$4, null, new Object[0]);
                }
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, DumbBlockSource.class, $$$methodRef$$$4, null);
                    ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, DumbBlockSource.class, $$$methodRef$$$4, null, null);
                }
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (bl) {
                    ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, DumbBlockSource.class, $$$methodRef$$$4, null, throwable2);
                }
                throw throwable;
            }
        }

        @Override
        final int getBlockSize() {
            boolean bl = (0x280L & TraceControllerImpl.feature) != 0L;
            try {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, DumbBlockSource.class, $$$methodRef$$$1, this, new Object[0]);
                }
                int n2 = 32768;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, DumbBlockSource.class, $$$methodRef$$$1, this, n2);
                    ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, DumbBlockSource.class, $$$methodRef$$$1, this, null);
                }
                return 32768;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (bl) {
                    ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, DumbBlockSource.class, $$$methodRef$$$1, this, throwable2);
                }
                throw throwable;
            }
        }

        @Override
        final byte[] get() {
            boolean bl = (0x280L & TraceControllerImpl.feature) != 0L;
            try {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, DumbBlockSource.class, $$$methodRef$$$2, this, new Object[0]);
                }
                byte[] byArray = new byte[32768];
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, DumbBlockSource.class, $$$methodRef$$$2, this, byArray);
                    ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, DumbBlockSource.class, $$$methodRef$$$2, this, null);
                }
                return byArray;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (bl) {
                    ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, DumbBlockSource.class, $$$methodRef$$$2, this, throwable2);
                }
                throw throwable;
            }
        }

        @Override
        final void put(byte[] byArray) {
            boolean bl = (0x280L & TraceControllerImpl.feature) != 0L;
            try {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, DumbBlockSource.class, $$$methodRef$$$3, this, new Object[]{byArray});
                }
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, DumbBlockSource.class, $$$methodRef$$$3, this);
                    ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, DumbBlockSource.class, $$$methodRef$$$3, this, null);
                }
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (bl) {
                    ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, DumbBlockSource.class, $$$methodRef$$$3, this, throwable2);
                }
                throw throwable;
            }
        }

        static {
            try {
                $$$methodRef$$$4 = DumbBlockSource.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = DumbBlockSource.class.getDeclaredMethod("put", byte[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = DumbBlockSource.class.getDeclaredMethod("get", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = DumbBlockSource.class.getDeclaredMethod("getBlockSize", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = DumbBlockSource.class.getDeclaredMethod("createBlockSource", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    static final class Implementation
    extends Enum<Implementation> {
        public static final /* enum */ Implementation DUMB;
        public static final /* enum */ Implementation SIMPLE;
        public static final /* enum */ Implementation SOFT;
        public static final /* enum */ Implementation THREADED;
        private static final /* synthetic */ Implementation[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        public static Implementation[] values() {
            return (Implementation[])$VALUES.clone();
        }

        public static Implementation valueOf(String name) {
            return Enum.valueOf(Implementation.class, name);
        }

        static {
            try {
                $$$methodRef$$$2 = Implementation.class.getDeclaredConstructor(String.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = Implementation.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = Implementation.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            DUMB = new Implementation();
            SIMPLE = new Implementation();
            SOFT = new Implementation();
            THREADED = new Implementation();
            $VALUES = new Implementation[]{DUMB, SIMPLE, SOFT, THREADED};
        }
    }
}

