/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.lang.reflect.Executable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.StandardMBean;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.replay.ReplayStatistics;
import oracle.jdbc.replay.ReplayStatisticsMXBean;
import oracle.jdbc.replay.driver.ReplayStatisticsImpl;
import oracle.jdbc.replay.driver.StatisticsTracker;

@DefaultLogger(value="oracle.jdbc.internal.replay")
@Supports(value={Feature.APPLICATION_CONTINUITY})
public class ReplayStatisticsMBeanImpl
extends StandardMBean
implements ReplayStatisticsMXBean {
    public static final ReplayStatisticsMBeanImpl SOLE_INSTANCE;
    private static final Set<StatisticsTracker> trackerSet;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;

    private ReplayStatisticsMBeanImpl() {
        super(ReplayStatisticsMXBean.class, true);
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, ReplayStatisticsMBeanImpl.class, $$$methodRef$$$6, null, new Object[0]);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, ReplayStatisticsMBeanImpl.class, $$$methodRef$$$6, null);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, ReplayStatisticsMBeanImpl.class, $$$methodRef$$$6, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, ReplayStatisticsMBeanImpl.class, $$$methodRef$$$6, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addTrackerForDS(StatisticsTracker statisticsTracker) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void tracker;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, ReplayStatisticsMBeanImpl.class, $$$methodRef$$$0, this, statisticsTracker);
            }
            trackerSet.add((StatisticsTracker)tracker);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, ReplayStatisticsMBeanImpl.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, ReplayStatisticsMBeanImpl.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, ReplayStatisticsMBeanImpl.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public String allStatistics() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, ReplayStatisticsMBeanImpl.class, $$$methodRef$$$1, this, new Object[0]);
            }
            long totalRequests = 0L;
            long totalCompletedRequests = 0L;
            long totalCalls = 0L;
            long totalProtectedCalls = 0L;
            long totalCallsAffectedByOutages = 0L;
            long totalCallsTriggeringReplay = 0L;
            long totalCallsAffectedByOutagesDuringReplay = 0L;
            long successfulReplayCount = 0L;
            long failedReplayCount = 0L;
            long replayDisablingCount = 0L;
            long totalReplayAttempts = 0L;
            int[] histogram = new int[31];
            for (StatisticsTracker tracker : trackerSet) {
                ReplayStatistics stats = tracker.getReplayStatistics();
                totalRequests += stats.getTotalRequests();
                totalCompletedRequests += stats.getTotalCompletedRequests();
                totalCalls += stats.getTotalCalls();
                totalProtectedCalls += stats.getTotalProtectedCalls();
                totalCallsAffectedByOutages += stats.getTotalCallsAffectedByOutages();
                totalCallsTriggeringReplay += stats.getTotalCallsTriggeringReplay();
                totalCallsAffectedByOutagesDuringReplay += stats.getTotalCallsAffectedByOutagesDuringReplay();
                successfulReplayCount += stats.getSuccessfulReplayCount();
                failedReplayCount += stats.getFailedReplayCount();
                replayDisablingCount += stats.getReplayDisablingCount();
                totalReplayAttempts += stats.getTotalReplayAttempts();
                int[] h2 = stats.getRequestSizeHistogram();
                if (h2 == null || h2.length <= 0) continue;
                for (int i2 = 0; i2 < h2.length; ++i2) {
                    int n2 = i2;
                    histogram[n2] = histogram[n2] + h2[i2];
                }
            }
            ReplayStatisticsImpl globalStats = new ReplayStatisticsImpl(totalRequests, totalCompletedRequests, totalCalls, totalProtectedCalls, totalCallsAffectedByOutages, totalCallsTriggeringReplay, totalCallsAffectedByOutagesDuringReplay, successfulReplayCount, failedReplayCount, replayDisablingCount, totalReplayAttempts, 0);
            globalStats.setRequestSizeHistogram(histogram);
            String string = globalStats.toString();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, ReplayStatisticsMBeanImpl.class, $$$methodRef$$$1, this, string);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, ReplayStatisticsMBeanImpl.class, $$$methodRef$$$1, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, ReplayStatisticsMBeanImpl.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getStatisticsForDataSource(String string) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, ReplayStatisticsMBeanImpl.class, $$$methodRef$$$2, this, string);
            }
            boolean foundOne = false;
            StringBuffer buf = new StringBuffer();
            for (StatisticsTracker tracker : trackerSet) {
                void dataSourceName;
                String dsName = tracker.getDataSourceName();
                if (dataSourceName == null || !dataSourceName.equals(dsName)) continue;
                if (!foundOne) {
                    buf.append(tracker.getReplayStatistics().toString());
                    foundOne = true;
                    continue;
                }
                buf.append("\n\nWARNING: there are data sources with duplicate names and replay statistics is only reported for one of them. Check names and try again.");
                break;
            }
            if (!foundOne) {
                buf.append("WARNING: replay statistics not available for this data source name. Check name and try again.");
            }
            String string2 = buf.toString();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, ReplayStatisticsMBeanImpl.class, $$$methodRef$$$2, this, string2);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, ReplayStatisticsMBeanImpl.class, $$$methodRef$$$2, this, null);
            }
            return string2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, ReplayStatisticsMBeanImpl.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected String getDescription(MBeanInfo mBeanInfo) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, ReplayStatisticsMBeanImpl.class, $$$methodRef$$$3, this, mBeanInfo);
            }
            String string = DatabaseError.findMessage("ReplayStatisticsMBeanDescription", (Object)this);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, ReplayStatisticsMBeanImpl.class, $$$methodRef$$$3, this, string);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, ReplayStatisticsMBeanImpl.class, $$$methodRef$$$3, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, ReplayStatisticsMBeanImpl.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected String getDescription(MBeanConstructorInfo mBeanConstructorInfo) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, ReplayStatisticsMBeanImpl.class, $$$methodRef$$$4, this, mBeanConstructorInfo);
            }
            String string = DatabaseError.findMessage("ReplayStatisticsMBeanConstructor", (Object)this);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, ReplayStatisticsMBeanImpl.class, $$$methodRef$$$4, this, string);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, ReplayStatisticsMBeanImpl.class, $$$methodRef$$$4, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, ReplayStatisticsMBeanImpl.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected String getDescription(MBeanOperationInfo mBeanOperationInfo) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void info;
            String n2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, ReplayStatisticsMBeanImpl.class, $$$methodRef$$$5, this, mBeanOperationInfo);
            }
            if ((n2 = info.getName()).equals("allStatistics")) {
                String string = DatabaseError.findMessage("ReplayStatisticsMBeanAllStatisticsDescription", (Object)this);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, ReplayStatisticsMBeanImpl.class, $$$methodRef$$$5, this, string);
                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, ReplayStatisticsMBeanImpl.class, $$$methodRef$$$5, this, null);
                }
                return string;
            }
            if (n2.equals("getStatisticsForDataSource")) {
                String string = DatabaseError.findMessage("ReplayStatisticsMBeanGetDSStatisticsDescription", (Object)this);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, ReplayStatisticsMBeanImpl.class, $$$methodRef$$$5, this, string);
                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, ReplayStatisticsMBeanImpl.class, $$$methodRef$$$5, this, null);
                }
                return string;
            }
            Logger.getLogger("oracle.jdbc.internal.replay").log(Level.SEVERE, "Got a request to describe an unexpected operation: " + n2);
            String string = super.getDescription((MBeanOperationInfo)info);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, ReplayStatisticsMBeanImpl.class, $$$methodRef$$$5, this, string);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, ReplayStatisticsMBeanImpl.class, $$$methodRef$$$5, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, ReplayStatisticsMBeanImpl.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$6 = ReplayStatisticsMBeanImpl.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$5 = ReplayStatisticsMBeanImpl.class.getDeclaredMethod("getDescription", MBeanOperationInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$4 = ReplayStatisticsMBeanImpl.class.getDeclaredMethod("getDescription", MBeanConstructorInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$3 = ReplayStatisticsMBeanImpl.class.getDeclaredMethod("getDescription", MBeanInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$2 = ReplayStatisticsMBeanImpl.class.getDeclaredMethod("getStatisticsForDataSource", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$1 = ReplayStatisticsMBeanImpl.class.getDeclaredMethod("allStatistics", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$0 = ReplayStatisticsMBeanImpl.class.getDeclaredMethod("addTrackerForDS", StatisticsTracker.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        SOLE_INSTANCE = new ReplayStatisticsMBeanImpl();
        trackerSet = Collections.synchronizedSet(new HashSet());
    }
}

