/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.server.mysql;

import java.util.regex.Pattern;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.inclusionrule.RegularExpressionExclusionRule;
import schemacrawler.plugin.EnumDataTypeHelper;
import schemacrawler.schemacrawler.DatabaseServerType;
import schemacrawler.server.mysql.MySQLEnumDataTypeHelper;
import schemacrawler.tools.databaseconnector.DatabaseConnectionUrlBuilder;
import schemacrawler.tools.databaseconnector.DatabaseConnector;
import schemacrawler.tools.executable.commandline.PluginCommand;

public final class MySQLDatabaseConnector
extends DatabaseConnector {
    public MySQLDatabaseConnector() {
        super(new DatabaseServerType("mysql", "MySQL"), url -> url != null && Pattern.matches("jdbc:(mysql|mariadb):.*", url), (informationSchemaViewsBuilder, connection) -> informationSchemaViewsBuilder.fromResourceFolder("/mysql.information_schema"), (schemaRetrievalOptionsBuilder, connection) -> schemaRetrievalOptionsBuilder.withEnumDataTypeHelper((EnumDataTypeHelper)new MySQLEnumDataTypeHelper()), limitOptionsBuilder -> limitOptionsBuilder.includeSchemas((InclusionRule)new RegularExpressionExclusionRule("sys|mysql")), () -> DatabaseConnectionUrlBuilder.builder((String)"jdbc:mysql://${host}:${port}/${database}").withDefaultPort(3306).withDefaultUrlx("nullNamePatternMatchesAll", true).withDefaultUrlx("noAccessToProcedureBodies", true).withDefaultUrlx("logger", "Jdk14Logger").withDefaultUrlx("dumpQueriesOnException", true).withDefaultUrlx("dumpMetadataOnColumnNotFound", true).withDefaultUrlx("maxQuerySizeToLog", "4096").withDefaultUrlx("disableMariaDbDriver", true).withDefaultUrlx("useInformationSchema", true));
    }

    public PluginCommand getHelpCommand() {
        PluginCommand pluginCommand = super.getHelpCommand();
        pluginCommand.addOption("server", String.class, new String[]{"--server=mysql%nLoads SchemaCrawler plug-in for MySQL"}).addOption("host", String.class, new String[]{"Host name%nOptional, defaults to localhost"}).addOption("port", Integer.class, new String[]{"Port number%nOptional, defaults to 3306"}).addOption("database", String.class, new String[]{"Database name"});
        return pluginCommand;
    }
}

