/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Executable;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import javax.security.auth.DestroyFailedException;
import oracle.jdbc.AccessToken;
import oracle.jdbc.driver.DMSFactory;
import oracle.jdbc.driver.JsonWebTokenCache;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.logging.annotations.Blind;
import oracle.net.nt.CustomSSLSocketFactory;
import oracle.sql.json.OracleJsonFactory;

public final class JsonWebToken
implements AccessToken {
    private static final OracleJsonFactory JSON_FACTORY;
    private static final DateTimeFormatter DATE_FORMATTER;
    private final OpaqueString token;
    private final OpaqueString privateKey;
    private final long exp;
    private static final byte[] BEGIN_PRIVATE_KEY_UTF8;
    private static final byte[] END_PRIVATE_KEY_UTF8;
    private static final byte[] LINE_SEPARATOR;
    private static final int CACHES_SIZE = 128;
    private static final Map<Builder, JsonWebTokenCache> CACHES;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;

    private JsonWebToken(@Blind OpaqueString token, @Blind OpaqueString privateKey) {
        this.token = token;
        this.privateKey = privateKey;
        this.exp = token.map(JsonWebToken::parseExp);
    }

    public OpaqueString token() {
        return this.token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Blind
    public byte[] sign(@Blind byte[] header) throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, SignatureException {
        if (this.privateKey == null) {
            return null;
        }
        PrivateKey deobfuscatedKey = JsonWebToken.decodeKey(this.privateKey);
        try {
            Signature signature = Signature.getInstance("SHA256withRSA");
            signature.initSign(deobfuscatedKey);
            signature.update(header);
            byte[] byArray = signature.sign();
            return byArray;
        }
        finally {
            JsonWebToken.tryDestroyKey(deobfuscatedKey);
        }
    }

    public long exp() {
        return this.exp;
    }

    @Blind
    public String toString() {
        return super.toString();
    }

    public boolean equals(Object object) {
        return object == this || object instanceof JsonWebToken && Objects.equals(this.token, ((JsonWebToken)object).token) && Objects.equals(this.privateKey, ((JsonWebToken)object).privateKey);
    }

    public int hashCode() {
        return Objects.hash(this.token, this.privateKey);
    }

    @Blind
    static JsonWebToken fromFile(Path path) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        return new JsonWebToken(JsonWebToken.readTokenFile(path.resolve("token")), JsonWebToken.readPemFile(path.resolve("oci_db_key.pem")));
    }

    static Builder requestBuilder() {
        return new Builder();
    }

    @Blind
    public static JsonWebToken createProofOfPossessionToken(@Blind char[] token, @Blind PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        return new JsonWebToken(OpaqueString.newOpaqueString(token), JsonWebToken.encodeKey(privateKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Blind
    private static OpaqueString readTokenFile(Path path) throws IOException {
        byte[] tokenBytes = Files.readAllBytes(path);
        try {
            OpaqueString opaqueString;
            CharBuffer tokenBuffer = StandardCharsets.UTF_8.decode(ByteBuffer.wrap(tokenBytes));
            try {
                char[] tokenChars = new char[tokenBuffer.remaining()];
                tokenBuffer.get(tokenChars);
                opaqueString = OpaqueString.newOpaqueString(tokenChars);
                tokenBuffer.clear();
            }
            catch (Throwable throwable) {
                tokenBuffer.clear();
                tokenBuffer.put(new char[tokenBuffer.remaining()]);
                throw throwable;
            }
            tokenBuffer.put(new char[tokenBuffer.remaining()]);
            return opaqueString;
        }
        finally {
            Arrays.fill(tokenBytes, (byte)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Blind
    private static OpaqueString readPemFile(Path path) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] pemBytes = Files.readAllBytes(path);
        try {
            OpaqueString opaqueString;
            int beginTagOffset = JsonWebToken.findTag(pemBytes, 0, BEGIN_PRIVATE_KEY_UTF8);
            if (beginTagOffset == -1) {
                throw new IOException(path + " does not contain: " + new String(BEGIN_PRIVATE_KEY_UTF8, StandardCharsets.UTF_8));
            }
            int payloadOffset = beginTagOffset + BEGIN_PRIVATE_KEY_UTF8.length + LINE_SEPARATOR.length;
            int endTagOffset = JsonWebToken.findTag(pemBytes, payloadOffset, END_PRIVATE_KEY_UTF8);
            if (endTagOffset == -1) {
                throw new IOException(path + " does not contain: " + new String(END_PRIVATE_KEY_UTF8, StandardCharsets.UTF_8));
            }
            byte[] base64Key = Arrays.copyOfRange(pemBytes, payloadOffset, endTagOffset);
            try {
                opaqueString = JsonWebToken.decodeBase64Key(base64Key);
            }
            catch (Throwable throwable) {
                Arrays.fill(base64Key, (byte)0);
                throw throwable;
            }
            Arrays.fill(base64Key, (byte)0);
            return opaqueString;
        }
        finally {
            Arrays.fill(pemBytes, (byte)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Blind
    private static OpaqueString decodeBase64Key(@Blind byte[] base64Key) throws NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] encodedKey = Base64.getMimeDecoder().decode(base64Key);
        try {
            OpaqueString opaqueString;
            PrivateKey privateKey = KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(encodedKey));
            try {
                opaqueString = JsonWebToken.encodeKey(privateKey);
            }
            catch (Throwable throwable) {
                JsonWebToken.tryDestroyKey(privateKey);
                throw throwable;
            }
            JsonWebToken.tryDestroyKey(privateKey);
            return opaqueString;
        }
        finally {
            Arrays.fill(encodedKey, (byte)0);
        }
    }

    private static int findTag(@Blind byte[] pemBytes, int offset, byte[] tag) {
        while (offset < pemBytes.length) {
            if (JsonWebToken.arrayEquals(pemBytes, offset, tag)) {
                return offset;
            }
            int lineEnd = JsonWebToken.arrayIndexOf(pemBytes, offset, LINE_SEPARATOR);
            if (lineEnd == -1) break;
            offset = lineEnd + 1;
        }
        return -1;
    }

    private static int arrayIndexOf(@Blind byte[] array, int arrayOffset, byte[] match) {
        for (int i2 = arrayOffset; i2 < array.length; ++i2) {
            if (!JsonWebToken.arrayEquals(array, i2, match)) continue;
            return i2;
        }
        return -1;
    }

    private static boolean arrayEquals(@Blind byte[] a2, int aOffset, byte[] b2) {
        if (aOffset + b2.length > a2.length) {
            return false;
        }
        for (int i2 = 0; i2 < b2.length; ++i2) {
            if (a2[i2 + aOffset] == b2[i2]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Blind
    private static OpaqueString encodeKey(@Blind PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] encoded = KeyFactory.getInstance("RSA").getKeySpec(privateKey, PKCS8EncodedKeySpec.class).getEncoded();
        try {
            char[] encodedChars = new char[encoded.length];
            for (int i2 = 0; i2 < encoded.length; ++i2) {
                encodedChars[i2] = (char)encoded[i2];
            }
            OpaqueString opaqueString = OpaqueString.newOpaqueString(encodedChars);
            return opaqueString;
        }
        finally {
            Arrays.fill(encoded, (byte)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Blind
    private static PrivateKey decodeKey(@Blind OpaqueString opaqueString) throws NoSuchAlgorithmException, InvalidKeySpecException {
        char[] encodedChars = opaqueString.getChars();
        try {
            PrivateKey privateKey;
            byte[] encoded = new byte[encodedChars.length];
            try {
                for (int i2 = 0; i2 < encodedChars.length; ++i2) {
                    encoded[i2] = (byte)encodedChars[i2];
                }
                privateKey = KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(encoded));
            }
            catch (Throwable throwable) {
                Arrays.fill(encoded, (byte)0);
                throw throwable;
            }
            Arrays.fill(encoded, (byte)0);
            return privateKey;
        }
        finally {
            Arrays.fill(encodedChars, '\u0000');
        }
    }

    private static void tryDestroyKey(@Blind PrivateKey privateKey) {
        try {
            privateKey.destroy();
        }
        catch (DestroyFailedException destroyFailedException) {
            // empty catch block
        }
    }

    /*
     * Exception decompiling
     */
    private static long parseExp(@Blind char[] jwt) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Blind
    private static AccessToken requestBearerToken(Builder builder) throws IOException {
        URL url = new URL(builder.endPoint);
        if (!"https".equalsIgnoreCase(url.getProtocol())) {
            throw new IllegalArgumentException("Protocol of endpoint is not https: " + url.getProtocol());
        }
        HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("Accept-Type", "application/json");
        connection.setSSLSocketFactory(CustomSSLSocketFactory.getSSLSocketFactory(builder.sqlNetOptions, new DMSFactory().new DMSFactory.DMSNoun()));
        connection.setRequestProperty("Date", LocalDateTime.now().atZone(ZoneOffset.UTC).format(DATE_FORMATTER));
        connection.setRequestProperty("Authorization", JsonWebToken.createAuthorization(builder.user, builder.password));
        connection.setDoOutput(true);
        try (OutputStream request = connection.getOutputStream();){
            request.write(String.format("{\"scope\": \"urn:oracle:db::id::%s\", \"tenantId\": \"%s\"}", builder.compartment == null ? "*" : (builder.database == null ? builder.compartment : builder.compartment + "::" + builder.database), builder.tenancy).getBytes(StandardCharsets.UTF_8));
            request.flush();
        }
        var4_4 = null;
        try (InputStream response = connection.getInputStream();){
            OpaqueString token = OpaqueString.newOpaqueString(JSON_FACTORY.createJsonTextValue(response).asJsonObject().getString("token"));
            if (token.isNull()) {
                throw new IOException("JSON response does not contain a token");
            }
            JsonWebToken jsonWebToken = new JsonWebToken(token, null);
            return jsonWebToken;
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Blind
    private static String createAuthorization(String user, @Blind OpaqueString password) {
        byte[] userColonBytes = (user + ":").getBytes(StandardCharsets.UTF_8);
        ByteBuffer passwordBuffer = password.map(chars -> StandardCharsets.UTF_8.encode(CharBuffer.wrap(chars)));
        try {
            String string;
            byte[] userColonPassword = new byte[userColonBytes.length + passwordBuffer.remaining()];
            try {
                System.arraycopy(userColonBytes, 0, userColonPassword, 0, userColonBytes.length);
                passwordBuffer.get(userColonPassword, userColonBytes.length, passwordBuffer.remaining());
                string = "Basic " + Base64.getEncoder().encodeToString(userColonPassword);
            }
            catch (Throwable throwable) {
                Arrays.fill(userColonPassword, (byte)0);
                throw throwable;
            }
            Arrays.fill(userColonPassword, (byte)0);
            return string;
        }
        finally {
            passwordBuffer.clear();
            passwordBuffer.put(new byte[passwordBuffer.remaining()]);
        }
    }

    static {
        try {
            $$$methodRef$$$24 = JsonWebToken.class.getDeclaredConstructor(OpaqueString.class, OpaqueString.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = JsonWebToken.class.getDeclaredMethod("access$900", Builder.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = JsonWebToken.class.getDeclaredMethod("access$800", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = JsonWebToken.class.getDeclaredMethod("lambda$createAuthorization$0", char[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = JsonWebToken.class.getDeclaredMethod("createAuthorization", String.class, OpaqueString.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = JsonWebToken.class.getDeclaredMethod("requestBearerToken", Builder.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = JsonWebToken.class.getDeclaredMethod("parseExp", char[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = JsonWebToken.class.getDeclaredMethod("tryDestroyKey", PrivateKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = JsonWebToken.class.getDeclaredMethod("decodeKey", OpaqueString.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = JsonWebToken.class.getDeclaredMethod("encodeKey", PrivateKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = JsonWebToken.class.getDeclaredMethod("arrayEquals", byte[].class, Integer.TYPE, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = JsonWebToken.class.getDeclaredMethod("arrayIndexOf", byte[].class, Integer.TYPE, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = JsonWebToken.class.getDeclaredMethod("findTag", byte[].class, Integer.TYPE, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = JsonWebToken.class.getDeclaredMethod("decodeBase64Key", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = JsonWebToken.class.getDeclaredMethod("readPemFile", Path.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = JsonWebToken.class.getDeclaredMethod("readTokenFile", Path.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = JsonWebToken.class.getDeclaredMethod("createProofOfPossessionToken", char[].class, PrivateKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = JsonWebToken.class.getDeclaredMethod("requestBuilder", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = JsonWebToken.class.getDeclaredMethod("fromFile", Path.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = JsonWebToken.class.getDeclaredMethod("hashCode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = JsonWebToken.class.getDeclaredMethod("equals", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = JsonWebToken.class.getDeclaredMethod("toString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = JsonWebToken.class.getDeclaredMethod("exp", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = JsonWebToken.class.getDeclaredMethod("sign", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = JsonWebToken.class.getDeclaredMethod("token", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        JSON_FACTORY = new OracleJsonFactory();
        DATE_FORMATTER = DateTimeFormatter.ofPattern("E, dd MMM uuuu HH:mm:ss z", Locale.US);
        BEGIN_PRIVATE_KEY_UTF8 = "-----BEGIN PRIVATE KEY-----".getBytes(StandardCharsets.UTF_8);
        END_PRIVATE_KEY_UTF8 = "-----END PRIVATE KEY-----".getBytes(StandardCharsets.UTF_8);
        LINE_SEPARATOR = "\n".getBytes(StandardCharsets.UTF_8);
        CACHES = Collections.synchronizedMap(new LinkedHashMap<Builder, JsonWebTokenCache>(16, 0.75f, true){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            protected boolean removeEldestEntry(Map.Entry<Builder, JsonWebTokenCache> entry) {
                return this.size() > 128;
            }

            static {
                try {
                    $$$methodRef$$$1 = 1.class.getDeclaredConstructor(Integer.TYPE, Float.TYPE, Boolean.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("removeEldestEntry", Map.Entry.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
    }

    static final class Builder {
        private String endPoint;
        private String tenancy;
        private String compartment;
        private String database;
        private String user;
        private OpaqueString password;
        private Properties sqlNetOptions;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;
        private static Executable $$$methodRef$$$9;
        private static Logger $$$loggerRef$$$9;
        private static Executable $$$methodRef$$$10;
        private static Logger $$$loggerRef$$$10;
        private static Executable $$$methodRef$$$11;
        private static Logger $$$loggerRef$$$11;
        private static Executable $$$methodRef$$$12;
        private static Logger $$$loggerRef$$$12;
        private static Executable $$$methodRef$$$13;
        private static Logger $$$loggerRef$$$13;
        private static Executable $$$methodRef$$$14;
        private static Logger $$$loggerRef$$$14;
        private static Executable $$$methodRef$$$15;
        private static Logger $$$loggerRef$$$15;
        private static Executable $$$methodRef$$$16;
        private static Logger $$$loggerRef$$$16;
        private static Executable $$$methodRef$$$17;
        private static Logger $$$loggerRef$$$17;
        private static Executable $$$methodRef$$$18;
        private static Logger $$$loggerRef$$$18;
        private static Executable $$$methodRef$$$19;
        private static Logger $$$loggerRef$$$19;
        private static Executable $$$methodRef$$$20;
        private static Logger $$$loggerRef$$$20;

        private Builder() {
        }

        Builder endPoint(String endPoint) {
            this.endPoint = endPoint;
            return this;
        }

        Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        Builder compartment(String compartment) {
            this.compartment = compartment;
            return this;
        }

        Builder database(String database) {
            this.database = database;
            return this;
        }

        Builder user(String user) {
            this.user = user;
            return this;
        }

        Builder password(@Blind OpaqueString password) {
            this.password = password;
            return this;
        }

        Builder sqlNetOptions(Properties sqlNetOptions) {
            this.sqlNetOptions = (Properties)sqlNetOptions.clone();
            return this;
        }

        @Blind
        JsonWebToken build() throws IOException {
            try {
                return CACHES.computeIfAbsent(this, this0 -> JsonWebTokenCache.create(() -> {
                    try {
                        return JsonWebToken.requestBearerToken(this);
                    }
                    catch (IOException ioException) {
                        throw new UncheckedIOException(ioException);
                    }
                })).get();
            }
            catch (UncheckedIOException ioException) {
                throw ioException.getCause();
            }
        }

        public boolean equals(Object object) {
            return this == object || object instanceof Builder && Objects.equals(this.endPoint, ((Builder)object).endPoint) && Objects.equals(this.tenancy, ((Builder)object).tenancy) && Objects.equals(this.compartment, ((Builder)object).compartment) && Objects.equals(this.database, ((Builder)object).database) && Objects.equals(this.user, ((Builder)object).user) && Objects.equals(this.password, ((Builder)object).password) && Objects.equals(this.sqlNetOptions, ((Builder)object).sqlNetOptions);
        }

        public int hashCode() {
            return Objects.hash(this.endPoint, this.tenancy, this.compartment, this.database, this.user, this.password, this.sqlNetOptions);
        }

        static {
            try {
                $$$methodRef$$$20 = Builder.class.getDeclaredConstructor(1.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$19 = Builder.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$18 = Builder.class.getDeclaredMethod("access$700", Builder.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$17 = Builder.class.getDeclaredMethod("access$600", Builder.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$16 = Builder.class.getDeclaredMethod("access$500", Builder.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$15 = Builder.class.getDeclaredMethod("access$400", Builder.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$14 = Builder.class.getDeclaredMethod("access$300", Builder.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$13 = Builder.class.getDeclaredMethod("access$200", Builder.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$12 = Builder.class.getDeclaredMethod("access$100", Builder.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$11 = Builder.class.getDeclaredMethod("lambda$null$0", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$10 = Builder.class.getDeclaredMethod("lambda$build$1", Builder.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$9 = Builder.class.getDeclaredMethod("hashCode", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$8 = Builder.class.getDeclaredMethod("equals", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$7 = Builder.class.getDeclaredMethod("build", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$6 = Builder.class.getDeclaredMethod("sqlNetOptions", Properties.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$5 = Builder.class.getDeclaredMethod("password", OpaqueString.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = Builder.class.getDeclaredMethod("user", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = Builder.class.getDeclaredMethod("database", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = Builder.class.getDeclaredMethod("compartment", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = Builder.class.getDeclaredMethod("tenancy", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = Builder.class.getDeclaredMethod("endPoint", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

