SELECT /*+ PARALLEL(AUTO) */
  NULL AS SEQUENCE_CATALOG,
  SEQUENCES.SEQUENCE_OWNER AS SEQUENCE_SCHEMA,
  SEQUENCES.SEQUENCE_NAME AS SEQUENCE_NAME,
  SEQUENCES.INCREMENT_BY AS "INCREMENT",
  NULL AS START_VALUE,
  SEQUENCES.MIN_VALUE AS MINIMUM_VALUE,
  SEQUENCES.MAX_VALUE AS MAXIMUM_VALUE,
  CASE WHEN SEQUENCES.CYCLE_FLAG = 'Y' THEN 'YES' ELSE 'NO' END AS CYCLE_OPTION,
  SEQUENCES.ORDER_FLAG,
  SEQUENCES.CACHE_SIZE,
  SEQUENCES.LAST_NUMBER
FROM
  ${catalogscope}_SEQUENCES SEQUENCES
WHERE
  SEQUENCES.SEQUENCE_OWNER NOT IN
    ('ANONYMOUS', 'APEX_PUBLIC_USER', 'APPQOSSYS', 'BI', 'CTXSYS', 'DBSNMP', 'DIP',
    'EXFSYS', 'FLOWS_30000', 'FLOWS_FILES', 'GSMADMIN_INTERNAL', 'IX', 'LBACSYS',
    'MDDATA', 'MDSYS', 'MGMT_VIEW', 'OE', 'OLAPSYS', 'ORACLE_OCM',
    'ORDPLUGINS', 'ORDSYS', 'OUTLN', 'OWBSYS', 'PM', 'SCOTT', 'SH',
    'SI_INFORMTN_SCHEMA', 'SPATIAL_CSW_ADMIN_USR', 'SPATIAL_WFS_ADMIN_USR',
    'SYS', 'SYSMAN', 'SYSTEM', 'TSMSYS', 'WKPROXY', 'WKSYS', 'WK_TEST',
    'WMSYS', 'XDB', 'XS$NULL', 'RDSADMIN')
  AND NOT REGEXP_LIKE(SEQUENCES.SEQUENCE_OWNER, '^APEX_[0-9]{6}$')
  AND NOT REGEXP_LIKE(SEQUENCES.SEQUENCE_OWNER, '^FLOWS_[0-9]{5,6}$')
  AND REGEXP_LIKE(SEQUENCES.SEQUENCE_OWNER, '${schemas}')
ORDER BY
  SEQUENCE_OWNER,
  SEQUENCE_NAME
