/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.util;

import java.text.ParseException;
import java.util.Date;
import org.apache.solr.analytics.facet.RangeFacet;
import org.apache.solr.analytics.util.FacetRangeGenerator;
import org.apache.solr.util.DateMathParser;

class DateFacetRangeGenerator
extends FacetRangeGenerator<Date> {
    private final Date now;

    public DateFacetRangeGenerator(RangeFacet rangeFacet, Date now) {
        super(rangeFacet);
        this.now = now;
    }

    @Override
    public String formatValue(Date val) {
        return val.toInstant().toString();
    }

    @Override
    protected Date parseVal(String rawval) {
        return DateMathParser.parseMath((Date)this.now, (String)rawval);
    }

    @Override
    protected Object parseGap(String rawval) {
        return rawval;
    }

    @Override
    public Date parseAndAddGap(Date value, String gap) throws ParseException {
        DateMathParser dmp = new DateMathParser();
        dmp.setNow(value);
        return dmp.parseMath(gap);
    }
}

