/* application.c generated by valac 0.56.1, the Vala compiler
 * generated from application.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2003 Jacob Perkins
 * Copyright (C) 2005, 2006 Stefan Walter
 * Copyright (C) 2011 Collabora Ltd.
 * Copyright (C) 2012 Stefan Walter
 * Copyright (C) 2018 Niels De Graef
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see
 * <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include "seahorse-common.h"
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include "config.h"
#include <handy.h>
#include "seahorse-gkr.h"
#include "seahorse-ssh.h"
#include "pgp/seahorse-pgp-backend.h"
#include "pkcs11/seahorse-pkcs11-backend.h"

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SEAHORSE_TYPE_APPLICATION (seahorse_application_get_type ())
#define SEAHORSE_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SEAHORSE_TYPE_APPLICATION, SeahorseApplication))
#define SEAHORSE_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SEAHORSE_TYPE_APPLICATION, SeahorseApplicationClass))
#define SEAHORSE_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SEAHORSE_TYPE_APPLICATION))
#define SEAHORSE_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SEAHORSE_TYPE_APPLICATION))
#define SEAHORSE_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SEAHORSE_TYPE_APPLICATION, SeahorseApplicationClass))

typedef struct _SeahorseApplication SeahorseApplication;
typedef struct _SeahorseApplicationClass SeahorseApplicationClass;
typedef struct _SeahorseApplicationPrivate SeahorseApplicationPrivate;

#define SEAHORSE_TYPE_SEARCH_PROVIDER (seahorse_search_provider_get_type ())
#define SEAHORSE_SEARCH_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SEAHORSE_TYPE_SEARCH_PROVIDER, SeahorseSearchProvider))
#define SEAHORSE_SEARCH_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SEAHORSE_TYPE_SEARCH_PROVIDER, SeahorseSearchProviderClass))
#define SEAHORSE_IS_SEARCH_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SEAHORSE_TYPE_SEARCH_PROVIDER))
#define SEAHORSE_IS_SEARCH_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SEAHORSE_TYPE_SEARCH_PROVIDER))
#define SEAHORSE_SEARCH_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SEAHORSE_TYPE_SEARCH_PROVIDER, SeahorseSearchProviderClass))

typedef struct _SeahorseSearchProvider SeahorseSearchProvider;
typedef struct _SeahorseSearchProviderClass SeahorseSearchProviderClass;

#define SEAHORSE_TYPE_KEY_MANAGER (seahorse_key_manager_get_type ())
#define SEAHORSE_KEY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SEAHORSE_TYPE_KEY_MANAGER, SeahorseKeyManager))
#define SEAHORSE_KEY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SEAHORSE_TYPE_KEY_MANAGER, SeahorseKeyManagerClass))
#define SEAHORSE_IS_KEY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SEAHORSE_TYPE_KEY_MANAGER))
#define SEAHORSE_IS_KEY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SEAHORSE_TYPE_KEY_MANAGER))
#define SEAHORSE_KEY_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SEAHORSE_TYPE_KEY_MANAGER, SeahorseKeyManagerClass))

typedef struct _SeahorseKeyManager SeahorseKeyManager;
typedef struct _SeahorseKeyManagerClass SeahorseKeyManagerClass;
enum  {
	SEAHORSE_APPLICATION_0_PROPERTY,
	SEAHORSE_APPLICATION_NUM_PROPERTIES
};
static GParamSpec* seahorse_application_properties[SEAHORSE_APPLICATION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _SeahorseApplication {
	GtkApplication parent_instance;
	SeahorseApplicationPrivate * priv;
};

struct _SeahorseApplicationClass {
	GtkApplicationClass parent_class;
};

struct _SeahorseApplicationPrivate {
	SeahorseSearchProvider* search_provider;
	guint search_provider_dbus_id;
	SeahorseKeyManager* key_mgr;
};

struct _Block1Data {
	int _ref_count_;
	SeahorseApplication* self;
	GtkAboutDialog* about;
};

static gint SeahorseApplication_private_offset;
static gpointer seahorse_application_parent_class = NULL;

VALA_EXTERN GType seahorse_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SeahorseApplication, g_object_unref)
VALA_EXTERN GType seahorse_search_provider_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SeahorseSearchProvider, g_object_unref)
VALA_EXTERN guint seahorse_search_provider_register_object (void* object,
                                                GDBusConnection* connection,
                                                const gchar* path,
                                                GError** error);
VALA_EXTERN GType seahorse_key_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SeahorseKeyManager, g_object_unref)
static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self);
static void seahorse_application_on_app_help (SeahorseApplication* self,
                                       GSimpleAction* action,
                                       GVariant* param);
static void _seahorse_application_on_app_help_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self);
static void seahorse_application_on_app_about (SeahorseApplication* self,
                                        GSimpleAction* action,
                                        GVariant* param);
static void _seahorse_application_on_app_about_gsimple_action_activate_callback (GSimpleAction* action,
                                                                          GVariant* parameter,
                                                                          gpointer self);
static void seahorse_application_on_app_preferences (SeahorseApplication* self,
                                              GSimpleAction* action,
                                              GVariant* param);
static void _seahorse_application_on_app_preferences_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                GVariant* parameter,
                                                                                gpointer self);
VALA_EXTERN SeahorseApplication* seahorse_application_new (void);
VALA_EXTERN SeahorseApplication* seahorse_application_construct (GType object_type);
VALA_EXTERN SeahorseSearchProvider* seahorse_search_provider_new (GApplication* app);
VALA_EXTERN SeahorseSearchProvider* seahorse_search_provider_construct (GType object_type,
                                                            GApplication* app);
static void seahorse_application_add_action_accelerators (SeahorseApplication* self);
static void seahorse_application_real_startup (GApplication* base);
static void seahorse_application_real_activate (GApplication* base);
VALA_EXTERN SeahorseKeyManager* seahorse_key_manager_new (SeahorseApplication* app);
VALA_EXTERN SeahorseKeyManager* seahorse_key_manager_construct (GType object_type,
                                                    SeahorseApplication* app);
static void seahorse_application_real_open (GApplication* base,
                                     GFile** files,
                                     gint files_length1,
                                     const gchar* hint);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
VALA_EXTERN void seahorse_key_manager_import_files (SeahorseKeyManager* self,
                                        gchar** uris,
                                        gint uris_length1);
static gint seahorse_application_real_handle_local_options (GApplication* base,
                                                     GVariantDict* options);
static gboolean seahorse_application_real_dbus_register (GApplication* base,
                                                  GDBusConnection* connection,
                                                  const gchar* object_path,
                                                  GError** error);
static void seahorse_application_real_dbus_unregister (GApplication* base,
                                                GDBusConnection* connection,
                                                const gchar* object_path);
VALA_EXTERN void seahorse_application_initialize_search (SeahorseApplication* self);
VALA_EXTERN void seahorse_search_provider_load (SeahorseSearchProvider* self,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
VALA_EXTERN void seahorse_search_provider_load_finish (SeahorseSearchProvider* self,
                                           GAsyncResult* _res_,
                                           GError** error);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda24_ (Block1Data* _data1_,
                  gint response);
static void ___lambda24__gtk_dialog_response (GtkDialog* _sender,
                                       gint response_id,
                                       gpointer self);
static void seahorse_application_finalize (GObject * obj);
static GType seahorse_application_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const gchar* SEAHORSE_APPLICATION_AUTHORS[11] = {"Jacob Perkins <jap1@users.sourceforge.net>", "Jose Carlos Garcia Sogo <jsogo@users.sourceforge.net>", "Jean Schurger <yshark@schurger.org>", "Stef Walter <stef@memberwebs.com>", "Adam Schreiber <sadam@clemson.edu>", "Niels De Graef <nielsdegraef@gmail.com>", "", N_ ("Contributions:"), "Albrecht Dreß <albrecht.dress@arcor.de>", "Jim Pharis <binbrain@gmail.com>", NULL};
static const gchar* SEAHORSE_APPLICATION_DOCUMENTERS[4] = {"Jacob Perkins <jap1@users.sourceforge.net>", "Adam Schreiber <sadam@clemson.edu>", "Milo Casagrande <milo_casagrande@yahoo.it>", NULL};
static const gchar* SEAHORSE_APPLICATION_ARTISTS[3] = {"Jacob Perkins <jap1@users.sourceforge.net>", "Stef Walter <stef@memberwebs.com>", NULL};
static const GActionEntry SEAHORSE_APPLICATION_action_entries[4] = {{"quit", _g_application_quit_gsimple_action_activate_callback}, {"help", _seahorse_application_on_app_help_gsimple_action_activate_callback}, {"about", _seahorse_application_on_app_about_gsimple_action_activate_callback}, {"preferences", _seahorse_application_on_app_preferences_gsimple_action_activate_callback}};
static const GOptionEntry SEAHORSE_APPLICATION_cmd_options[2] = {{"version", 'v', (gint) 0, G_OPTION_ARG_NONE, NULL, N_ ("Version of this application"), NULL}, {NULL}};

static inline gpointer
seahorse_application_get_instance_private (SeahorseApplication* self)
{
	return G_STRUCT_MEMBER_P (self, SeahorseApplication_private_offset);
}

static void
_g_application_quit_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self)
{
	g_application_quit ((GApplication*) self);
}

static void
_seahorse_application_on_app_help_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self)
{
	seahorse_application_on_app_help ((SeahorseApplication*) self, action, parameter);
}

static void
_seahorse_application_on_app_about_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self)
{
	seahorse_application_on_app_about ((SeahorseApplication*) self, action, parameter);
}

static void
_seahorse_application_on_app_preferences_gsimple_action_activate_callback (GSimpleAction* action,
                                                                           GVariant* parameter,
                                                                           gpointer self)
{
	seahorse_application_on_app_preferences ((SeahorseApplication*) self, action, parameter);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

SeahorseApplication*
seahorse_application_construct (GType object_type)
{
	SeahorseApplication * self = NULL;
	SeahorseSearchProvider* _tmp0_;
	GSimpleAction* pref_action = NULL;
	GAction* _tmp1_;
	GSimpleAction* _tmp2_;
	self = (SeahorseApplication*) g_object_new (object_type, "application-id", APPLICATION_ID, "resource-base-path", "/org/gnome/Seahorse", "flags", G_APPLICATION_HANDLES_OPEN, NULL);
	_tmp0_ = seahorse_search_provider_new ((GApplication*) self);
	_g_object_unref0 (self->priv->search_provider);
	self->priv->search_provider = _tmp0_;
	g_action_map_add_action_entries ((GActionMap*) self, SEAHORSE_APPLICATION_action_entries, (gint) G_N_ELEMENTS (SEAHORSE_APPLICATION_action_entries), self);
	_tmp1_ = g_action_map_lookup_action ((GActionMap*) self, "preferences");
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp1_) : NULL);
	pref_action = _tmp2_;
	g_simple_action_set_enabled (pref_action, seahorse_prefs_available ());
	seahorse_application_add_action_accelerators (self);
	g_application_add_main_option_entries ((GApplication*) self, SEAHORSE_APPLICATION_cmd_options);
	_g_object_unref0 (pref_action);
	return self;
}

SeahorseApplication*
seahorse_application_new (void)
{
	return seahorse_application_construct (SEAHORSE_TYPE_APPLICATION);
}

static void
seahorse_application_add_action_accelerators (SeahorseApplication* self)
{
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gchar* _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	gchar* _tmp12_;
	gchar** _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	gchar* _tmp15_;
	gchar** _tmp16_;
	gchar** _tmp17_;
	gint _tmp17__length1;
	gchar* _tmp18_;
	gchar** _tmp19_;
	gchar** _tmp20_;
	gint _tmp20__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("F1");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.help", _tmp2_);
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	_tmp3_ = g_strdup ("<control>q");
	_tmp4_ = g_new0 (gchar*, 1 + 1);
	_tmp4_[0] = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.quit", _tmp5_);
	_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
	_tmp6_ = g_strdup ("<control>f");
	_tmp7_ = g_new0 (gchar*, 1 + 1);
	_tmp7_[0] = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp8__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.show-search", _tmp8_);
	_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
	_tmp9_ = g_strdup ("<control>n");
	_tmp10_ = g_new0 (gchar*, 1 + 1);
	_tmp10_[0] = _tmp9_;
	_tmp11_ = _tmp10_;
	_tmp11__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.new-item", _tmp11_);
	_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
	_tmp12_ = g_strdup ("<control>i");
	_tmp13_ = g_new0 (gchar*, 1 + 1);
	_tmp13_[0] = _tmp12_;
	_tmp14_ = _tmp13_;
	_tmp14__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.import-file", _tmp14_);
	_tmp14_ = (_vala_array_free (_tmp14_, _tmp14__length1, (GDestroyNotify) g_free), NULL);
	_tmp15_ = g_strdup ("<control>c");
	_tmp16_ = g_new0 (gchar*, 1 + 1);
	_tmp16_[0] = _tmp15_;
	_tmp17_ = _tmp16_;
	_tmp17__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.copy", _tmp17_);
	_tmp17_ = (_vala_array_free (_tmp17_, _tmp17__length1, (GDestroyNotify) g_free), NULL);
	_tmp18_ = g_strdup ("<control>v");
	_tmp19_ = g_new0 (gchar*, 1 + 1);
	_tmp19_[0] = _tmp18_;
	_tmp20_ = _tmp19_;
	_tmp20__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.paste", _tmp20_);
	_tmp20_ = (_vala_array_free (_tmp20_, _tmp20__length1, (GDestroyNotify) g_free), NULL);
}

static void
seahorse_application_real_startup (GApplication* base)
{
	SeahorseApplication * self;
	HdyStyleManager* _tmp0_;
	self = (SeahorseApplication*) base;
	G_APPLICATION_CLASS (seahorse_application_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	hdy_init ();
	_tmp0_ = hdy_style_manager_get_default ();
	hdy_style_manager_set_color_scheme (_tmp0_, HDY_COLOR_SCHEME_PREFER_LIGHT);
	seahorse_icons_init ();
	seahorse_gkr_backend_initialize ();
	seahorse_ssh_backend_initialize ();
	seahorse_pgp_backend_initialize (NULL);
	seahorse_pkcs11_backend_initialize ();
}

static void
seahorse_application_real_activate (GApplication* base)
{
	SeahorseApplication * self;
	GtkWindow* _tmp0_;
	SeahorseKeyManager* _tmp2_;
	self = (SeahorseApplication*) base;
	_tmp0_ = gtk_application_get_active_window ((GtkApplication*) self);
	if (_tmp0_ == NULL) {
		SeahorseKeyManager* _tmp1_;
		_tmp1_ = seahorse_key_manager_new (self);
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->key_mgr);
		self->priv->key_mgr = _tmp1_;
	}
	_tmp2_ = self->priv->key_mgr;
	gtk_window_present ((GtkWindow*) _tmp2_);
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
seahorse_application_real_open (GApplication* base,
                                GFile** files,
                                gint files_length1,
                                const gchar* hint)
{
	SeahorseApplication * self;
	SeahorseKeyManager* _tmp0_;
	gchar** uris = NULL;
	gchar** _tmp1_;
	gint uris_length1;
	gint _uris_size_;
	SeahorseKeyManager* _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	self = (SeahorseApplication*) base;
	g_return_if_fail (hint != NULL);
	g_application_activate ((GApplication*) self);
	_tmp0_ = self->priv->key_mgr;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = g_new0 (gchar*, 0 + 1);
	uris = _tmp1_;
	uris_length1 = 0;
	_uris_size_ = uris_length1;
	{
		GFile** file_collection = NULL;
		gint file_collection_length1 = 0;
		gint _file_collection_size_ = 0;
		gint file_it = 0;
		file_collection = files;
		file_collection_length1 = files_length1;
		for (file_it = 0; file_it < file_collection_length1; file_it = file_it + 1) {
			GFile* _tmp2_;
			GFile* file = NULL;
			_tmp2_ = _g_object_ref0 (file_collection[file_it]);
			file = _tmp2_;
			{
				GFile* _tmp3_;
				gchar* _tmp4_;
				_tmp3_ = file;
				_tmp4_ = g_file_get_uri (_tmp3_);
				_vala_array_add1 (&uris, &uris_length1, &_uris_size_, _tmp4_);
				_g_object_unref0 (file);
			}
		}
	}
	_tmp5_ = self->priv->key_mgr;
	_tmp6_ = uris;
	_tmp6__length1 = uris_length1;
	seahorse_key_manager_import_files (_tmp5_, _tmp6_, (gint) _tmp6__length1);
	uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
}

static gint
seahorse_application_real_handle_local_options (GApplication* base,
                                                GVariantDict* options)
{
	SeahorseApplication * self;
	gint result;
	self = (SeahorseApplication*) base;
	g_return_val_if_fail (options != NULL, 0);
	if (g_variant_dict_contains (options, "version")) {
		g_print ("%s\n", PACKAGE_STRING);
		g_print ("GNUPG: %s (%d.%d.%d)\n", GNUPG, GPG_MAJOR, GPG_MINOR, GPG_MICRO);
		result = 0;
		return result;
	}
	result = -1;
	return result;
}

static gboolean
seahorse_application_real_dbus_register (GApplication* base,
                                         GDBusConnection* connection,
                                         const gchar* object_path,
                                         GError** error)
{
	SeahorseApplication * self;
	gboolean _tmp0_ = FALSE;
	guint _tmp2_ = 0U;
	SeahorseSearchProvider* _tmp3_;
	guint _tmp4_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (SeahorseApplication*) base;
	g_return_val_if_fail (connection != NULL, FALSE);
	g_return_val_if_fail (object_path != NULL, FALSE);
	_tmp0_ = G_APPLICATION_CLASS (seahorse_application_parent_class)->dbus_register ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), connection, object_path, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp1_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp1_;
	}
	if (!_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp3_ = self->priv->search_provider;
	_tmp4_ = seahorse_search_provider_register_object (_tmp3_, connection, object_path, &_inner_error0_);
	_tmp2_ = _tmp4_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp5_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp5_;
	}
	self->priv->search_provider_dbus_id = _tmp2_;
	result = TRUE;
	return result;
}

static void
seahorse_application_real_dbus_unregister (GApplication* base,
                                           GDBusConnection* connection,
                                           const gchar* object_path)
{
	SeahorseApplication * self;
	self = (SeahorseApplication*) base;
	g_return_if_fail (connection != NULL);
	g_return_if_fail (object_path != NULL);
	if (self->priv->search_provider_dbus_id != ((guint) 0)) {
		g_dbus_connection_unregister_object (connection, self->priv->search_provider_dbus_id);
		self->priv->search_provider_dbus_id = (guint) 0;
	}
	G_APPLICATION_CLASS (seahorse_application_parent_class)->dbus_unregister ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), connection, object_path);
}

void
seahorse_application_initialize_search (SeahorseApplication* self)
{
	SeahorseSearchProvider* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->search_provider;
	seahorse_search_provider_load (_tmp0_, NULL, NULL);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		SeahorseApplication* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->about);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
__lambda24_ (Block1Data* _data1_,
             gint response)
{
	SeahorseApplication* self;
	self = _data1_->self;
	gtk_widget_hide ((GtkWidget*) _data1_->about);
}

static void
___lambda24__gtk_dialog_response (GtkDialog* _sender,
                                  gint response_id,
                                  gpointer self)
{
	__lambda24_ (self, response_id);
}

static void
seahorse_application_on_app_about (SeahorseApplication* self,
                                   GSimpleAction* action,
                                   GVariant* param)
{
	Block1Data* _data1_;
	GtkAboutDialog* _tmp0_;
	SeahorseKeyManager* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = (GtkAboutDialog*) gtk_about_dialog_new ();
	g_object_ref_sink (_tmp0_);
	_data1_->about = _tmp0_;
	gtk_about_dialog_set_artists (_data1_->about, SEAHORSE_APPLICATION_ARTISTS);
	gtk_about_dialog_set_authors (_data1_->about, SEAHORSE_APPLICATION_AUTHORS);
	gtk_about_dialog_set_documenters (_data1_->about, SEAHORSE_APPLICATION_DOCUMENTERS);
	gtk_about_dialog_set_version (_data1_->about, VERSION);
	gtk_about_dialog_set_comments (_data1_->about, _ ("Passwords and Keys"));
	gtk_about_dialog_set_copyright (_data1_->about, "© 2002 - 2018 Seahorse Contributors");
	gtk_about_dialog_set_translator_credits (_data1_->about, _ ("translator-credits"));
	gtk_about_dialog_set_logo_icon_name (_data1_->about, APPLICATION_ID);
	gtk_about_dialog_set_website (_data1_->about, "https://wiki.gnome.org/Apps/Seahorse");
	gtk_about_dialog_set_website_label (_data1_->about, _ ("Seahorse Project Homepage"));
	g_signal_connect_data ((GtkDialog*) _data1_->about, "response", (GCallback) ___lambda24__gtk_dialog_response, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp1_ = self->priv->key_mgr;
	gtk_window_set_transient_for ((GtkWindow*) _data1_->about, (GtkWindow*) _tmp1_);
	gtk_dialog_run ((GtkDialog*) _data1_->about);
	gtk_widget_destroy ((GtkWidget*) _data1_->about);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static void
seahorse_application_on_app_help (SeahorseApplication* self,
                                  GSimpleAction* action,
                                  GVariant* param)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	{
		SeahorseKeyManager* _tmp0_;
		_tmp0_ = self->priv->key_mgr;
		gtk_show_uri_on_window ((GtkWindow*) _tmp0_, "help:seahorse", gtk_get_current_event_time (), &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = err;
		_tmp2_ = _tmp1_->message;
		g_warning ("application.vala:194: Error showing help: %s", _tmp2_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
seahorse_application_on_app_preferences (SeahorseApplication* self,
                                         GSimpleAction* action,
                                         GVariant* param)
{
	SeahorsePrefs* prefs_dialog = NULL;
	SeahorseKeyManager* _tmp0_;
	SeahorsePrefs* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->key_mgr;
	_tmp1_ = seahorse_prefs_new ((GtkWindow*) _tmp0_);
	g_object_ref_sink (_tmp1_);
	prefs_dialog = _tmp1_;
	gtk_window_present ((GtkWindow*) prefs_dialog);
	_g_object_unref0 (prefs_dialog);
}

static void
seahorse_application_class_init (SeahorseApplicationClass * klass,
                                 gpointer klass_data)
{
	seahorse_application_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SeahorseApplication_private_offset);
	((GApplicationClass *) klass)->startup = (void (*) (GApplication*)) seahorse_application_real_startup;
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) seahorse_application_real_activate;
	((GApplicationClass *) klass)->open = (void (*) (GApplication*, GFile**, gint, const gchar*)) seahorse_application_real_open;
	((GApplicationClass *) klass)->handle_local_options = (gint (*) (GApplication*, GVariantDict*)) seahorse_application_real_handle_local_options;
	((GApplicationClass *) klass)->dbus_register = (gboolean (*) (GApplication*, GDBusConnection*, const gchar*, GError**)) seahorse_application_real_dbus_register;
	((GApplicationClass *) klass)->dbus_unregister = (void (*) (GApplication*, GDBusConnection*, const gchar*)) seahorse_application_real_dbus_unregister;
	G_OBJECT_CLASS (klass)->finalize = seahorse_application_finalize;
}

static void
seahorse_application_instance_init (SeahorseApplication * self,
                                    gpointer klass)
{
	self->priv = seahorse_application_get_instance_private (self);
	self->priv->search_provider_dbus_id = (guint) 0;
	self->priv->key_mgr = NULL;
}

static void
seahorse_application_finalize (GObject * obj)
{
	SeahorseApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_TYPE_APPLICATION, SeahorseApplication);
	_g_object_unref0 (self->priv->search_provider);
	_g_object_unref0 (self->priv->key_mgr);
	G_OBJECT_CLASS (seahorse_application_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
seahorse_application_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorseApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseApplication), 0, (GInstanceInitFunc) seahorse_application_instance_init, NULL };
	GType seahorse_application_type_id;
	seahorse_application_type_id = g_type_register_static (gtk_application_get_type (), "SeahorseApplication", &g_define_type_info, 0);
	SeahorseApplication_private_offset = g_type_add_instance_private (seahorse_application_type_id, sizeof (SeahorseApplicationPrivate));
	return seahorse_application_type_id;
}

GType
seahorse_application_get_type (void)
{
	static volatile gsize seahorse_application_type_id__once = 0;
	if (g_once_init_enter (&seahorse_application_type_id__once)) {
		GType seahorse_application_type_id;
		seahorse_application_type_id = seahorse_application_get_type_once ();
		g_once_init_leave (&seahorse_application_type_id__once, seahorse_application_type_id);
	}
	return seahorse_application_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

