/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.users;

import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.catalina.Group;
import org.apache.catalina.Role;
import org.apache.catalina.UserDatabase;
import org.apache.catalina.users.AbstractUser;
import org.apache.catalina.users.MemoryUserDatabase;
import org.apache.tomcat.util.buf.StringUtils;
import org.apache.tomcat.util.security.Escape;

public class MemoryUser
extends AbstractUser {
    protected final MemoryUserDatabase database;
    protected final CopyOnWriteArrayList<Group> groups = new CopyOnWriteArrayList();
    protected final CopyOnWriteArrayList<Role> roles = new CopyOnWriteArrayList();

    MemoryUser(MemoryUserDatabase memoryUserDatabase, String string, String string2, String string3) {
        this.database = memoryUserDatabase;
        this.setUsername(string);
        this.setPassword(string2);
        this.setFullName(string3);
    }

    @Override
    public Iterator<Group> getGroups() {
        return this.groups.iterator();
    }

    @Override
    public Iterator<Role> getRoles() {
        return this.roles.iterator();
    }

    @Override
    public UserDatabase getUserDatabase() {
        return this.database;
    }

    @Override
    public void addGroup(Group group) {
        this.groups.addIfAbsent(group);
    }

    @Override
    public void addRole(Role role) {
        this.roles.addIfAbsent(role);
    }

    @Override
    public boolean isInGroup(Group group) {
        return this.groups.contains(group);
    }

    @Override
    public boolean isInRole(Role role) {
        return this.roles.contains(role);
    }

    @Override
    public void removeGroup(Group group) {
        this.groups.remove(group);
    }

    @Override
    public void removeGroups() {
        this.groups.clear();
    }

    @Override
    public void removeRole(Role role) {
        this.roles.remove(role);
    }

    @Override
    public void removeRoles() {
        this.roles.clear();
    }

    public String toXml() {
        StringBuilder stringBuilder = new StringBuilder("<user username=\"");
        stringBuilder.append(Escape.xml((String)this.username));
        stringBuilder.append("\" password=\"");
        stringBuilder.append(Escape.xml((String)this.password));
        stringBuilder.append("\"");
        if (this.fullName != null) {
            stringBuilder.append(" fullName=\"");
            stringBuilder.append(Escape.xml((String)this.fullName));
            stringBuilder.append("\"");
        }
        stringBuilder.append(" groups=\"");
        StringUtils.join(this.groups, (char)',', (StringUtils.Function)new StringUtils.Function<Group>(){

            public String apply(Group group) {
                return Escape.xml((String)group.getGroupname());
            }
        }, (StringBuilder)stringBuilder);
        stringBuilder.append("\"");
        stringBuilder.append(" roles=\"");
        StringUtils.join(this.roles, (char)',', (StringUtils.Function)new StringUtils.Function<Role>(){

            public String apply(Role role) {
                return Escape.xml((String)role.getRolename());
            }
        }, (StringBuilder)stringBuilder);
        stringBuilder.append("\"");
        stringBuilder.append("/>");
        return stringBuilder.toString();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("User username=\"");
        stringBuilder.append(Escape.xml((String)this.username));
        stringBuilder.append("\"");
        if (this.fullName != null) {
            stringBuilder.append(", fullName=\"");
            stringBuilder.append(Escape.xml((String)this.fullName));
            stringBuilder.append("\"");
        }
        stringBuilder.append(", groups=\"");
        StringUtils.join(this.groups, (char)',', (StringUtils.Function)new StringUtils.Function<Group>(){

            public String apply(Group group) {
                return Escape.xml((String)group.getGroupname());
            }
        }, (StringBuilder)stringBuilder);
        stringBuilder.append("\"");
        stringBuilder.append(", roles=\"");
        StringUtils.join(this.roles, (char)',', (StringUtils.Function)new StringUtils.Function<Role>(){

            public String apply(Role role) {
                return Escape.xml((String)role.getRolename());
            }
        }, (StringBuilder)stringBuilder);
        stringBuilder.append("\"");
        return stringBuilder.toString();
    }
}

