/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.results.cpu;

import org.graalvm.visualvm.lib.jfluid.global.TransactionalSupport;
import org.graalvm.visualvm.lib.jfluid.results.cpu.ThreadInfo;

public class ThreadInfos {
    public ThreadInfo[] threadInfos;
    String[] threadNames;
    String[] threadClassNames;
    int threadInfosLastIdx;
    private TransactionalSupport transaction = new TransactionalSupport();

    public ThreadInfos() {
        this.reset();
    }

    public void beginTrans(boolean mutable) {
        this.transaction.beginTrans(mutable);
    }

    boolean beginTrans(boolean mutable, boolean failEarly) {
        return this.transaction.beginTrans(mutable, failEarly);
    }

    public void endTrans() {
        this.transaction.endTrans();
    }

    public boolean isEmpty() {
        this.beginTrans(false);
        try {
            if (this.threadInfos == null || this.threadInfos.length == 0) {
                boolean bl = true;
                return bl;
            }
            for (int i = 0; i < this.threadInfos.length; ++i) {
                if (this.threadInfos[i] == null || this.threadInfos[i].stack == null || this.threadInfos[i].stack[0] == null || this.threadInfos[i].stack[0].getChildren() == null || this.threadInfos[i].stack[0].getChildren().length <= 0) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.endTrans();
        }
    }

    public String[] getThreadNames() {
        this.beginTrans(false);
        try {
            String[] stringArray = this.threadNames;
            return stringArray;
        }
        finally {
            this.endTrans();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newThreadInfo(int threadId, String threadName, String threadClassName) {
        this.beginTrans(true);
        try {
            if (threadId > this.threadInfosLastIdx || this.threadInfos == null) {
                int newLen = threadId + 1;
                ThreadInfo[] newInfos = new ThreadInfo[newLen];
                String[] newNames = new String[newLen];
                String[] newClassNames = new String[newLen];
                if (this.threadInfos != null) {
                    System.arraycopy(this.threadInfos, 0, newInfos, 0, this.threadInfos.length);
                    System.arraycopy(this.threadNames, 0, newNames, 0, this.threadNames.length);
                    System.arraycopy(this.threadClassNames, 0, newClassNames, 0, this.threadNames.length);
                }
                this.threadInfos = newInfos;
                this.threadNames = newNames;
                this.threadClassNames = newClassNames;
                this.threadInfosLastIdx = threadId;
            }
            if (this.threadInfos[threadId] == null) {
                this.threadInfos[threadId] = new ThreadInfo(threadId);
                this.threadNames[threadId] = threadName;
                this.threadClassNames[threadId] = threadClassName;
            }
        }
        finally {
            this.endTrans();
        }
    }

    public void reset() {
        this.beginTrans(true);
        try {
            this.threadInfos = null;
            this.threadNames = null;
            this.threadClassNames = null;
            this.threadInfosLastIdx = -1;
        }
        finally {
            this.endTrans();
        }
    }
}

