/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.search.RegexpUtil;
import org.netbeans.api.search.SearchPattern;
import org.netbeans.api.search.SearchScopeOptions;
import org.netbeans.modules.search.TextRegexpUtil;
import org.openide.loaders.DataObject;

public final class BasicSearchCriteria {
    private static int instanceCounter;
    private final int instanceId = instanceCounter++;
    private static final Logger LOG;
    private SearchPattern searchPattern = SearchPattern.create(null, false, false, false);
    private SearchScopeOptions searcherOptions = SearchScopeOptions.create();
    private String replaceExpr;
    private String replaceString;
    private boolean preserveCase;
    private boolean textPatternSpecified = false;
    private boolean fileNamePatternSpecified = false;
    private boolean textPatternValid = false;
    private boolean replacePatternValid = false;
    private boolean fileNamePatternValid = false;
    private Pattern textPattern;
    private Pattern fileNamePattern;
    private boolean useIgnoreList = false;
    private boolean criteriaUsable = false;
    private ChangeListener usabilityChangeListener;
    private DataObject dataObject;

    BasicSearchCriteria() {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "#{0}: <init>()", this.instanceId);
        }
    }

    BasicSearchCriteria(BasicSearchCriteria basicSearchCriteria) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "#{0}: <init>(template)", this.instanceId);
        }
        this.setCaseSensitive(basicSearchCriteria.searchPattern.isMatchCase());
        this.setWholeWords(basicSearchCriteria.searchPattern.isWholeWords());
        this.setMatchType(basicSearchCriteria.searchPattern.getMatchType());
        this.setPreserveCase(basicSearchCriteria.preserveCase);
        this.setSearchInArchives(basicSearchCriteria.searcherOptions.isSearchInArchives());
        this.setSearchInGenerated(basicSearchCriteria.searcherOptions.isSearchInGenerated());
        this.setFileNameRegexp(basicSearchCriteria.searcherOptions.isRegexp());
        this.setUseIgnoreList(basicSearchCriteria.useIgnoreList);
        this.setTextPattern(basicSearchCriteria.searchPattern.getSearchExpression());
        this.setFileNamePattern(basicSearchCriteria.searcherOptions.getPattern());
        this.setReplaceExpr(basicSearchCriteria.replaceExpr);
    }

    Pattern getTextPattern() {
        if (!this.textPatternValid || !this.textPatternSpecified) {
            return null;
        }
        if (this.textPattern != null) {
            return this.textPattern;
        }
        try {
            return TextRegexpUtil.makeTextPattern(this.searchPattern);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            this.textPatternValid = false;
            return null;
        }
    }

    public String getTextPatternExpr() {
        return this.searchPattern.getSearchExpression() != null ? this.searchPattern.getSearchExpression() : "";
    }

    void setTextPattern(String string) {
        this.searchPattern = this.searchPattern.changeSearchExpression(string);
        boolean bl = this.textPatternValid;
        if (string == null || string.equals("")) {
            this.textPattern = null;
            this.textPatternSpecified = false;
            this.textPatternValid = false;
        } else {
            this.textPatternSpecified = true;
            this.updateTextPattern();
        }
        this.replacePatternValid = this.validateReplacePattern();
        this.updateUsability(this.textPatternValid != bl);
    }

    private void updateFileNamePattern() {
        try {
            if (this.fileNamePatternSpecified) {
                this.fileNamePattern = RegexpUtil.makeFileNamePattern(this.searcherOptions);
                this.fileNamePatternValid = true;
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            this.fileNamePattern = null;
            this.fileNamePatternValid = false;
        }
    }

    private void updateTextPattern() throws NullPointerException {
        try {
            if (this.textPatternSpecified) {
                this.textPattern = TextRegexpUtil.makeTextPattern(this.searchPattern);
                this.textPatternValid = true;
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            this.textPatternValid = false;
        }
    }

    private boolean validateReplacePattern() {
        if (this.searchPattern.isRegExp() && this.textPatternValid && this.textPatternSpecified && this.replaceExpr != null && !this.replaceExpr.isEmpty()) {
            int n = this.getTextPattern().matcher("").groupCount();
            String string = "";
            for (int i = 1; i <= n; ++i) {
                string = string + "(" + i + ")";
            }
            try {
                Pattern.compile(string).matcher("123456789").replaceFirst(this.replaceExpr);
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    SearchPattern.MatchType getMatchType() {
        return this.searchPattern.getMatchType();
    }

    boolean isPreserveCase() {
        return this.preserveCase;
    }

    void setPreserveCase(boolean bl) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "setPreservecase({0}{1}", new Object[]{bl, Character.valueOf(')')});
        }
        if (bl == this.preserveCase) {
            LOG.finest(" - no change");
            return;
        }
        this.preserveCase = bl;
        if (!this.searchPattern.isRegExp()) {
            this.textPattern = null;
        }
    }

    public boolean isFileNameRegexp() {
        return this.searcherOptions.isRegexp();
    }

    public void setFileNameRegexp(boolean bl) {
        if (this.searcherOptions.isRegexp() != bl) {
            this.searcherOptions.setRegexp(bl);
            this.updateFileNamePattern();
            this.updateUsability(true);
        }
    }

    public boolean isSearchInArchives() {
        return this.searcherOptions.isSearchInArchives();
    }

    public void setSearchInArchives(boolean bl) {
        this.searcherOptions.setSearchInArchives(bl);
    }

    public boolean isSearchInGenerated() {
        return this.searcherOptions.isSearchInGenerated();
    }

    public void setSearchInGenerated(boolean bl) {
        this.searcherOptions.setSearchInGenerated(bl);
    }

    public boolean isUseIgnoreList() {
        return this.useIgnoreList;
    }

    public void setUseIgnoreList(boolean bl) {
        this.useIgnoreList = bl;
    }

    void setMatchType(SearchPattern.MatchType matchType) {
        this.searchPattern = this.searchPattern.changeMatchType(matchType);
        this.updateTextPattern();
        this.replacePatternValid = this.validateReplacePattern();
        this.updateUsability(true);
    }

    boolean isWholeWords() {
        return this.searchPattern.isWholeWords();
    }

    void setWholeWords(boolean bl) {
        this.searchPattern = this.searchPattern.changeWholeWords(bl);
        this.updateTextPattern();
    }

    boolean isCaseSensitive() {
        return this.searchPattern.isMatchCase();
    }

    void setCaseSensitive(boolean bl) {
        this.searchPattern = this.searchPattern.changeMatchCase(bl);
        this.updateTextPattern();
    }

    boolean isFullText() {
        return this.textPatternValid;
    }

    Pattern getFileNamePattern() {
        if (!this.fileNamePatternValid || !this.fileNamePatternSpecified) {
            return null;
        }
        if (this.fileNamePattern == null) {
            this.updateFileNamePattern();
            return this.fileNamePattern;
        }
        return this.fileNamePattern;
    }

    String getFileNamePatternExpr() {
        return this.searcherOptions.getPattern();
    }

    void setFileNamePattern(String string) {
        this.searcherOptions.setPattern(string);
        if (this.searcherOptions.getPattern().isEmpty()) {
            this.fileNamePatternSpecified = false;
        } else {
            this.fileNamePatternSpecified = true;
            this.updateFileNamePattern();
        }
        boolean bl = !this.isFileNameRegexp();
        this.updateUsability(bl);
    }

    boolean isSearchAndReplace() {
        return this.replaceExpr != null;
    }

    public String getReplaceExpr() {
        return this.replaceExpr;
    }

    String getReplaceString() {
        if (this.replaceString == null && this.replaceExpr != null) {
            String[] stringArray = this.replaceExpr.split("\\\\\\\\", this.replaceExpr.length());
            String string = "";
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                string2 = string2.replace("\\r", "\r");
                string2 = string2.replace("\\n", "\n");
                string2 = string2.replace("\\t", "\t");
                string = string + string2;
                if (i == stringArray.length - 1) continue;
                string = string + "\\\\";
            }
            this.replaceString = string;
        }
        return this.replaceString;
    }

    void setReplaceExpr(String string) {
        this.replaceExpr = string;
        this.replaceString = null;
        this.replacePatternValid = this.validateReplacePattern();
        this.updateUsability(false);
    }

    private void updateUsability(boolean bl) {
        boolean bl2 = this.criteriaUsable;
        this.criteriaUsable = this.isUsable();
        if (this.criteriaUsable != bl2 || bl) {
            this.fireUsabilityChanged();
        }
    }

    boolean isUsable() {
        return (this.textPatternSpecified || !this.isSearchAndReplace() && this.fileNamePatternSpecified) && !this.isInvalid();
    }

    private boolean isInvalid() {
        return this.isTextPatternInvalid() || this.isFileNamePatternInvalid() || this.isReplacePatternInvalid();
    }

    void setUsabilityChangeListener(ChangeListener changeListener) {
        this.usabilityChangeListener = changeListener;
    }

    private void fireUsabilityChanged() {
        if (this.usabilityChangeListener != null) {
            this.usabilityChangeListener.stateChanged(new ChangeEvent(this));
        }
    }

    boolean isTextPatternUsable() {
        return this.textPatternSpecified && this.textPatternValid;
    }

    boolean isTextPatternInvalid() {
        return this.textPatternSpecified && !this.textPatternValid;
    }

    boolean isReplacePatternInvalid() {
        return !this.replacePatternValid;
    }

    boolean isFileNamePatternUsable() {
        return this.fileNamePatternSpecified && this.fileNamePatternValid;
    }

    boolean isFileNamePatternInvalid() {
        return this.fileNamePatternSpecified && !this.fileNamePatternValid;
    }

    void onOk() {
        LOG.finer("onOk()");
        if (this.textPatternValid && this.textPattern == null) {
            this.textPattern = TextRegexpUtil.makeTextPattern(this.searchPattern);
        }
        if (this.fileNamePatternValid && this.fileNamePattern == null) {
            this.fileNamePattern = RegexpUtil.makeFileNamePattern(this.searcherOptions);
        }
        assert (!this.textPatternValid || this.textPattern != null);
        assert (!this.fileNamePatternValid || this.fileNamePattern != null);
    }

    boolean isTextPatternValidAndSpecified() {
        return this.textPatternValid && this.textPatternSpecified;
    }

    SearchPattern getSearchPattern() {
        return this.searchPattern;
    }

    SearchScopeOptions getSearcherOptions() {
        return this.searcherOptions;
    }

    static {
        LOG = Logger.getLogger("org.netbeans.modules.search.BasicSearchCriteria");
    }
}

