/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.lang.javascript;

import java.util.Locale;
import org.graalvm.visualvm.heapviewer.truffle.details.SourceSectionView;
import org.graalvm.visualvm.lib.jfluid.heap.Field;
import org.graalvm.visualvm.lib.jfluid.heap.FieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectFieldValue;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.api.DetailsSupport;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsProvider;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsUtils;

public class JavaScriptDetailsProvider
extends DetailsProvider.Basic {
    private static final String SYMBOL_MASK = "com.oracle.truffle.js.runtime.Symbol";
    private static final String JS_NODE_MASK = "com.oracle.truffle.js.nodes.JavaScriptNode+";
    private static final String JS_STRING_MASK = "com.oracle.truffle.js.runtime.objects.JSLazyString";
    private static final String JS_INT_MASK = "com.oracle.truffle.js.runtime.objects.JSLazyString$JSLazyIntWrapper";
    private static final String JS_FUNCTION_MASK = "com.oracle.truffle.js.runtime.builtins.JSFunctionObject+";
    private static final String JS_FDATA_MASK = "com.oracle.truffle.js.runtime.builtins.JSFunctionData";
    private static final String JS_FUNCTION_ROOT_NODE_MASK = "com.oracle.truffle.js.nodes.function.FunctionRootNode";
    private static final String JS_CONSTRUCTOR_ROOT_NODE_MASK = "com.oracle.truffle.js.nodes.function.ConstructorRootNode";
    private static final String JS_NEW_TARGET_ROOT_NODE_MASK = "com.oracle.truffle.js.nodes.function.NewTargetRootNode+";
    private static final String JS_NATIVE_FUNCTION_ROOT_NODE_MASK = "com.oracle.truffle.trufflenode.node.ExecuteNativeFunctionNode$NativeFunctionRootNode";
    private static final String JS_FUNCTION_TEMPLATE_MASK = "com.oracle.truffle.trufflenode.info.FunctionTemplate";
    private static final String JS_REGEX_NODE_MASK = "com.oracle.truffle.regex.RegexNode+";
    private static final String JS_TREGEX_NODE_MASK = "com.oracle.truffle.regex.tregex.TRegexRootNode+";
    private static final String JS_JAVA_PACKAGE_MASK = "com.oracle.truffle.js.runtime.java.JavaPackageObject";
    private static final String SOURCE_SECTION = "com.oracle.truffle.api.source.SourceSection";

    public JavaScriptDetailsProvider() {
        super(new String[]{SYMBOL_MASK, JS_NODE_MASK, JS_STRING_MASK, JS_INT_MASK, JS_FUNCTION_MASK, JS_FDATA_MASK, JS_FUNCTION_ROOT_NODE_MASK, JS_CONSTRUCTOR_ROOT_NODE_MASK, JS_NEW_TARGET_ROOT_NODE_MASK, JS_NATIVE_FUNCTION_ROOT_NODE_MASK, JS_FUNCTION_TEMPLATE_MASK, JS_REGEX_NODE_MASK, JS_TREGEX_NODE_MASK, JS_JAVA_PACKAGE_MASK});
    }

    public String getDetailsString(String className, Instance instance) {
        String patternSource;
        String regexClass;
        String regexSimpleName;
        String engineLabel;
        String name;
        String name2;
        Object val;
        if (SYMBOL_MASK.equals(className)) {
            String description = DetailsUtils.getInstanceFieldString((Instance)instance, (String)"description");
            if (description != null) {
                return description;
            }
            return DetailsUtils.getInstanceFieldString((Instance)instance, (String)"name");
        }
        if (JS_STRING_MASK.equals(className)) {
            val = instance.getValueOfField("length");
            Object vall = instance.getValueOfField("left");
            Object valr = instance.getValueOfField("right");
            if (val instanceof Integer) {
                String left = DetailsUtils.getInstanceString((Instance)((Instance)vall));
                if (valr == null || left.length() > 160) {
                    return left;
                }
                return left + DetailsUtils.getInstanceString((Instance)((Instance)valr));
            }
        }
        if (JS_INT_MASK.equals(className)) {
            int value = DetailsUtils.getIntFieldValue((Instance)instance, (String)"value", (int)0);
            return Integer.toString(value);
        }
        if (JS_FUNCTION_MASK.equals(className)) {
            return DetailsUtils.getInstanceFieldString((Instance)instance, (String)"functionData");
        }
        if (JS_FDATA_MASK.equals(className)) {
            name2 = DetailsUtils.getInstanceFieldString((Instance)instance, (String)"name");
            if (name2 == null || name2.isEmpty()) {
                name2 = DetailsUtils.getInstanceFieldString((Instance)instance, (String)"lazyInit");
            }
            if (name2 == null || name2.isEmpty()) {
                String callTargetName = DetailsUtils.getInstanceFieldString((Instance)instance, (String)"callTarget");
                int spaceIndex = callTargetName == null ? -1 : callTargetName.indexOf(32);
                name2 = spaceIndex > 0 ? callTargetName.substring(0, spaceIndex) : callTargetName;
            }
            return name2;
        }
        if (JS_FUNCTION_ROOT_NODE_MASK.equals(className)) {
            name2 = DetailsUtils.getInstanceFieldString((Instance)instance, (String)"internalFunctionName");
            if (name2 != null) {
                return name2;
            }
            return DetailsUtils.getInstanceFieldString((Instance)instance, (String)"functionData");
        }
        if (JS_CONSTRUCTOR_ROOT_NODE_MASK.equals(className) && (val = this.getValueOfField(instance, "callTarget", instance.getJavaClass())) instanceof Instance && (name = DetailsUtils.getInstanceString((Instance)((Instance)val))) != null) {
            return "[Construct] " + name;
        }
        if (JS_NEW_TARGET_ROOT_NODE_MASK.equals(className) && (val = this.getValueOfField(instance, "callTarget", instance.getJavaClass().getSuperClass())) instanceof Instance && (name = DetailsUtils.getInstanceString((Instance)((Instance)val))) != null) {
            return "[NewTarget] " + name;
        }
        if (JS_NATIVE_FUNCTION_ROOT_NODE_MASK.equals(className)) {
            return DetailsUtils.getInstanceFieldString((Instance)instance, (String)"template");
        }
        if (JS_FUNCTION_TEMPLATE_MASK.equals(className)) {
            return DetailsUtils.getInstanceFieldString((Instance)instance, (String)"className");
        }
        if (JS_REGEX_NODE_MASK.equals(className) && (engineLabel = (regexSimpleName = (regexClass = instance.getJavaClass().getName()).substring(regexClass.lastIndexOf(46) + 1, regexClass.length())).substring(0, regexSimpleName.indexOf("RegexNode"))) != null) {
            String pattern = DetailsUtils.getInstanceFieldString((Instance)instance, (String)"pattern");
            if (pattern == null) {
                pattern = DetailsUtils.getInstanceFieldString((Instance)instance, (String)"node");
            }
            if (engineLabel != null && pattern != null) {
                return engineLabel.toLowerCase(Locale.US) + ": " + pattern;
            }
        }
        if (JS_TREGEX_NODE_MASK.equals(className) && (patternSource = DetailsUtils.getInstanceFieldString((Instance)instance, (String)"patternSource")) != null) {
            return "TRegex fwd " + patternSource;
        }
        if (JS_JAVA_PACKAGE_MASK.equals(className)) {
            return DetailsUtils.getInstanceFieldString((Instance)instance, (String)"packageName");
        }
        return null;
    }

    public DetailsProvider.View getDetailsView(String className, Instance instance) {
        if (JS_NODE_MASK.equals(className)) {
            Instance source = (Instance)instance.getValueOfField("source");
            if (source == null) {
                return null;
            }
            if (this.isSourceSection(source)) {
                return DetailsSupport.getDetailsView((Instance)source);
            }
            Integer charIndexInt = (Integer)instance.getValueOfField("charIndex");
            Integer charLengthInt = (Integer)instance.getValueOfField("charLength");
            Instance code = this.getCodeString(source);
            if (code == null) {
                return null;
            }
            int charIndex = charIndexInt & 0x3FFFFFFF;
            int charLength = charLengthInt & 0x3FFFFFFF;
            return new SourceSectionView(className, code, charIndex, charLength);
        }
        return null;
    }

    private Instance getCodeString(Instance source) {
        Instance content = (Instance)source.getValueOfField("content");
        if (content instanceof Instance) {
            return (Instance)content.getValueOfField("code");
        }
        Instance key = (Instance)source.getValueOfField("key");
        if (key instanceof Instance) {
            return (Instance)key.getValueOfField("content");
        }
        return null;
    }

    private Object getValueOfField(Instance instance, String name, JavaClass jcls) {
        for (FieldValue fieldValue : instance.getFieldValues()) {
            Field f = fieldValue.getField();
            if (!f.getName().equals(name) || !f.getDeclaringClass().equals(jcls)) continue;
            if (fieldValue instanceof ObjectFieldValue) {
                return ((ObjectFieldValue)fieldValue).getInstance();
            }
            return fieldValue.getValue();
        }
        return null;
    }

    private boolean isSourceSection(Instance source) {
        for (JavaClass jcls = source.getJavaClass(); jcls != null; jcls = jcls.getSuperClass()) {
            if (!SOURCE_SECTION.equals(jcls.getName())) continue;
            return true;
        }
        return false;
    }
}

